/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.vhdl.base;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.file.FileWriter;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.vhdl.base.VhdlContent;
import com.cburch.logisim.vhdl.base.VhdlEntityAttributes;
import com.cburch.logisim.vhdl.base.VhdlParser;
import java.util.ArrayList;

public class VhdlHdlGeneratorFactory
extends AbstractHdlGeneratorFactory {
    public static final String HDL_DIRECTORY = "circuit";

    public VhdlHdlGeneratorFactory() {
        super(HDL_DIRECTORY);
        this.getWiresPortsDuringHDLWriting = true;
    }

    @Override
    public void getGenerationTimeWiresPorts(Netlist theNetlist, AttributeSet attrs) {
        VhdlContent content = ((VhdlEntityAttributes)attrs).getContent();
        int i = 0;
        for (VhdlParser.PortDescription port : content.getPorts()) {
            this.myPorts.add(port.getType(), port.getName(), port.getWidth().getWidth(), i++);
        }
    }

    public ArrayList<String> getArchitecture(Netlist theNetlist, AttributeSet attrs, String componentName) {
        ArrayList<String> contents = new ArrayList<String>(FileWriter.getGenerateRemark(componentName, theNetlist.projName()));
        VhdlContent content = ((VhdlEntityAttributes)attrs).getContent();
        contents.add(content.getLibraries());
        contents.add(content.getArchitecture());
        return contents;
    }

    @Override
    public boolean isHdlSupportedTarget(AttributeSet attrs) {
        return Hdl.isVhdl();
    }
}

