/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.vhdl.sim;

import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.std.hdl.VhdlEntityComponent;
import com.cburch.logisim.util.FileUtil;
import com.cburch.logisim.util.LocaleManager;
import com.cburch.logisim.vhdl.base.VhdlEntity;
import com.cburch.logisim.vhdl.base.VhdlSimConstants;
import com.cburch.logisim.vhdl.sim.VhdlSimulatorTop;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VhdlSimulatorTclComp {
    static final Logger logger = LoggerFactory.getLogger(VhdlSimulatorTclComp.class);
    private boolean valid = false;
    private final VhdlSimulatorTop vsim;

    public VhdlSimulatorTclComp(VhdlSimulatorTop vs) {
        this.vsim = vs;
    }

    public void fireInvalidated() {
        this.valid = false;
    }

    public void generate(List<Component> comps) {
        String template;
        if (this.valid) {
            return;
        }
        StringBuilder compFiles = new StringBuilder();
        compFiles.append("Autogenerated by logisim");
        compFiles.append(System.getProperty("line.separator"));
        for (Component comp : comps) {
            if (!comp.getFactory().getClass().equals(VhdlEntity.class) && !comp.getFactory().getClass().equals(VhdlEntityComponent.class)) continue;
            InstanceState state = this.vsim.getProject().getCircuitState().getInstanceState(comp);
            ComponentFactory fact = comp.getFactory();
            String componentName = fact instanceof VhdlEntity ? ((VhdlEntity)fact).getSimName(state.getInstance().getAttributeSet()) : ((VhdlEntityComponent)fact).getSimName(state.getInstance().getAttributeSet());
            compFiles.append("vcom -reportprogress 300 -work work ../src/").append(componentName).append(".vhdl").append(System.getProperty("line.separator"));
        }
        try {
            template = new String(FileUtil.getBytes(this.getClass().getResourceAsStream("/resources/logisim/sim/comp.templ")));
            template = template.replaceAll("%date%", LocaleManager.PARSER_SDF.format(new Date()));
            template = template.replaceAll("%comp_files%", compFiles.toString());
        }
        catch (IOException e) {
            logger.error("Could not read template : {}", (Object)e.getMessage());
            return;
        }
        try {
            PrintWriter writer = new PrintWriter(VhdlSimConstants.SIM_PATH + "comp.tcl", StandardCharsets.UTF_8);
            writer.print(template);
            writer.close();
        }
        catch (IOException e) {
            logger.error("Could not create run.tcl file : {}", (Object)e.getMessage());
            e.printStackTrace();
            return;
        }
        this.valid = true;
    }
}

