/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.layout.counter;

import com.openhtmltopdf.css.parser.CounterData;
import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.layout.counter.AbstractCounterContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RootCounterContext
implements AbstractCounterContext {
    private final Map<String, Integer> counterMap = new HashMap<String, Integer>();

    public void resetCounterValue(CalculatedStyle style) {
        List<CounterData> resets = style.getCounterReset();
        if (resets != null) {
            resets.forEach(cd -> this.counterMap.put(cd.getName(), cd.getValue()));
        }
    }

    public void incrementCounterValue(CalculatedStyle style) {
        List<CounterData> incs = style.getCounterIncrement();
        if (incs != null) {
            for (CounterData cd : incs) {
                this.counterMap.merge(cd.getName(), cd.getValue(), (old, newVal) -> old + newVal);
            }
        }
    }

    @Override
    public int getCurrentCounterValue(String name) {
        Integer current = this.counterMap.get(name);
        if (current != null) {
            return current;
        }
        this.counterMap.put(name, 0);
        return 0;
    }

    @Override
    public List<Integer> getCurrentCounterValues(String name) {
        return Collections.singletonList(this.getCurrentCounterValue(name));
    }
}

