/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.swing.checkboxtree;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import org.scijava.swing.checkboxtree.CheckBoxNodeData;
import org.scijava.swing.checkboxtree.CheckBoxNodePanel;
import org.scijava.swing.checkboxtree.CheckBoxNodeRenderer;

public class CheckBoxNodeEditor
extends AbstractCellEditor
implements TreeCellEditor {
    private final CheckBoxNodeRenderer renderer = new CheckBoxNodeRenderer();
    private final JTree theTree;

    public CheckBoxNodeEditor(JTree tree) {
        this.theTree = tree;
    }

    @Override
    public Object getCellEditorValue() {
        CheckBoxNodePanel panel = this.renderer.getPanel();
        CheckBoxNodeData checkBoxNode = new CheckBoxNodeData(panel.label.getText(), panel.check.isSelected());
        return checkBoxNode;
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        if (!(event instanceof MouseEvent)) {
            return false;
        }
        MouseEvent mouseEvent = (MouseEvent)event;
        TreePath path = this.theTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (path == null) {
            return false;
        }
        Object node = path.getLastPathComponent();
        if (!(node instanceof DefaultMutableTreeNode)) {
            return false;
        }
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
        Object userObject = treeNode.getUserObject();
        return userObject instanceof CheckBoxNodeData;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
        Component editor = this.renderer.getTreeCellRendererComponent(tree, value, true, expanded, leaf, row, true);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (CheckBoxNodeEditor.this.stopCellEditing()) {
                    CheckBoxNodeEditor.this.fireEditingStopped();
                }
            }
        };
        if (editor instanceof CheckBoxNodePanel) {
            CheckBoxNodePanel panel = (CheckBoxNodePanel)editor;
            panel.check.addItemListener(itemListener);
        }
        return editor;
    }
}

