/*
 * Decompiled with CFR 0.152.
 */
package com.bric.colorpicker.colorslider;

import com.bric.colorpicker.ColorPickerMode;
import com.bric.colorpicker.listeners.ColorListener;
import com.bric.colorpicker.listeners.ColorListenerWrapper;
import com.bric.colorpicker.listeners.ModeListener;
import com.bric.colorpicker.models.ColorModel;
import com.bric.colorpicker.models.ModeModel;
import java.text.MessageFormat;
import javax.swing.JSlider;

public class ColorSlider
extends JSlider
implements ColorListener,
ModeListener {
    private ColorPickerMode mode;
    private ColorModel colorModel;
    private final ColorListenerWrapper colorListenerWrapper = ColorListenerWrapper.withListener(colorModel -> this.updateValue());

    public ColorSlider() {
        super(1, 0, 100, 0);
    }

    @Override
    public void colorChanged(ColorModel colorModel) {
        this.colorModel = colorModel;
        if (this.mode != null) {
            this.colorListenerWrapper.colorChanged(colorModel);
        }
    }

    private void updateValue() {
        switch (this.mode) {
            case HUE: {
                this.setValue((int)(this.colorModel.getHue() * (float)this.mode.getMax()));
                break;
            }
            case BRIGHTNESS: {
                this.setValue((int)(this.colorModel.getBrightness() * (float)this.mode.getMax()));
                break;
            }
            case SATURATION: {
                this.setValue((int)(this.colorModel.getSaturation() * (float)this.mode.getMax()));
                break;
            }
            case RED: {
                this.setValue(this.colorModel.getRed());
                break;
            }
            case GREEN: {
                this.setValue(this.colorModel.getGreen());
                break;
            }
            case BLUE: {
                this.setValue(this.colorModel.getBlue());
                break;
            }
            case ALPHA: {
                this.setValue(this.colorModel.getAlpha());
                break;
            }
            default: {
                throw new IllegalStateException(MessageFormat.format("Mode not supported: {0}", new Object[]{this.mode}));
            }
        }
        this.repaint();
    }

    @Override
    public void modeChanged(ModeModel modeModel) {
        this.mode = modeModel.getMode();
        this.setInverted(this.mode == ColorPickerMode.HUE);
        this.setMaximum(this.mode.getMax());
        if (this.colorModel != null) {
            this.aboutToChangeColor();
            this.updateValue();
        }
    }

    public void aboutToChangeColor() {
        this.colorListenerWrapper.aboutToChangeValue();
    }
}

