/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.actions;

import com.cburch.draw.Strings;
import com.cburch.draw.actions.ModelAction;
import com.cburch.draw.model.CanvasModel;
import com.cburch.draw.model.CanvasObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ModelAddAction
extends ModelAction {
    private final List<CanvasObject> added;
    private final int addIndex;

    public ModelAddAction(CanvasModel model, CanvasObject added) {
        this(model, Collections.singleton(added));
    }

    public ModelAddAction(CanvasModel model, Collection<CanvasObject> added) {
        super(model);
        this.added = new ArrayList<CanvasObject>(added);
        this.addIndex = model.getObjectsFromBottom().size();
    }

    public ModelAddAction(CanvasModel model, Collection<CanvasObject> added, int index) {
        super(model);
        this.added = new ArrayList<CanvasObject>(added);
        this.addIndex = index;
    }

    @Override
    void doSub(CanvasModel model) {
        model.addObjects(this.addIndex, this.added);
    }

    public int getDestinationIndex() {
        return this.addIndex;
    }

    @Override
    public String getName() {
        return Strings.S.get("actionAdd", ModelAddAction.getShapesName(this.added));
    }

    @Override
    public Collection<CanvasObject> getObjects() {
        return Collections.unmodifiableList(this.added);
    }

    @Override
    void undoSub(CanvasModel model) {
        model.removeObjects(this.added);
    }
}

