/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.gui;

import com.cburch.draw.canvas.Selection;
import com.cburch.draw.canvas.SelectionEvent;
import com.cburch.draw.canvas.SelectionListener;
import com.cburch.draw.model.CanvasObject;
import com.cburch.logisim.data.AbstractAttributeSet;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeListener;
import com.cburch.logisim.data.AttributeSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SelectionAttributes
extends AbstractAttributeSet {
    private final Selection selection;
    private Listener listener;
    private Map<AttributeSet, CanvasObject> selected;
    private Attribute<?>[] selAttrs;
    private Object[] selValues;
    private List<Attribute<?>> attrsView;

    public SelectionAttributes(Selection selection) {
        this.selection = selection;
        this.listener = new Listener();
        this.selected = Collections.emptyMap();
        this.selAttrs = new Attribute[0];
        this.selValues = new Object[0];
        this.attrsView = List.of(this.selAttrs);
        selection.addSelectionListener(this.listener);
        this.listener.selectionChanged(null);
    }

    private static Object getSelectionValue(Attribute<?> attr, Set<AttributeSet> sel) {
        Object ret = null;
        for (AttributeSet attrs : sel) {
            if (!attrs.containsAttribute(attr)) continue;
            Object val = attrs.getValue(attr);
            if (ret == null) {
                ret = val;
                continue;
            }
            if (val != null && val.equals(ret)) continue;
            return null;
        }
        return ret;
    }

    @Override
    protected void copyInto(AbstractAttributeSet dest) {
        this.listener = new Listener();
        this.selection.addSelectionListener(this.listener);
    }

    public Iterable<Map.Entry<AttributeSet, CanvasObject>> entries() {
        Set<Map.Entry<AttributeSet, CanvasObject>> raw = this.selected.entrySet();
        return new ArrayList<Map.Entry<AttributeSet, CanvasObject>>(raw);
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return this.attrsView;
    }

    @Override
    public <V> V getValue(Attribute<V> attr) {
        Attribute<?>[] attrs = this.selAttrs;
        Object[] values = this.selValues;
        for (int i = 0; i < attrs.length; ++i) {
            if (attrs[i] != attr) continue;
            Object ret = values[i];
            return (V)ret;
        }
        return null;
    }

    @Override
    public <V> void setValue(Attribute<V> attr, V value) {
        Attribute<?>[] attrs = this.selAttrs;
        Object[] values = this.selValues;
        for (int i = 0; i < attrs.length; ++i) {
            if (attrs[i] != attr) continue;
            boolean same = Objects.equals(value, values[i]);
            if (same) break;
            values[i] = value;
            for (AttributeSet objAttrs : this.selected.keySet()) {
                objAttrs.setValue(attr, value);
            }
            break;
        }
    }

    private class Listener
    implements SelectionListener,
    AttributeListener {
        private Listener() {
        }

        @Override
        public void attributeListChanged(AttributeEvent e) {
            this.computeAttributeList(SelectionAttributes.this.selected.keySet());
        }

        @Override
        public void attributeValueChanged(AttributeEvent e) {
            if (SelectionAttributes.this.selected.containsKey(e.getSource())) {
                Attribute<?> attr = e.getAttribute();
                Attribute<?>[] attrs = SelectionAttributes.this.selAttrs;
                Object[] values = SelectionAttributes.this.selValues;
                for (int i = 0; i < attrs.length; ++i) {
                    if (attrs[i] != attr) continue;
                    values[i] = SelectionAttributes.getSelectionValue(attr, SelectionAttributes.this.selected.keySet());
                }
            }
        }

        private void computeAttributeList(Set<AttributeSet> attrsSet) {
            LinkedHashSet<Attribute> attrSet = new LinkedHashSet<Attribute>();
            Iterator<AttributeSet> sit = attrsSet.iterator();
            if (sit.hasNext()) {
                AttributeSet first = sit.next();
                attrSet.addAll(first.getAttributes());
                while (sit.hasNext()) {
                    AttributeSet next = sit.next();
                    attrSet.removeIf(attr -> !next.containsAttribute((Attribute<?>)attr));
                }
            }
            Attribute[] attrs = new Attribute[attrSet.size()];
            Object[] values = new Object[attrs.length];
            int i = 0;
            Iterator iterator = attrSet.iterator();
            while (iterator.hasNext()) {
                Attribute attr2;
                attrs[i] = attr2 = (Attribute)iterator.next();
                values[i] = SelectionAttributes.getSelectionValue(attr2, attrsSet);
                ++i;
            }
            SelectionAttributes.this.selAttrs = attrs;
            SelectionAttributes.this.selValues = values;
            SelectionAttributes.this.attrsView = List.of(attrs);
            SelectionAttributes.this.fireAttributeListChanged();
        }

        @Override
        public void selectionChanged(SelectionEvent ex) {
            Map<AttributeSet, CanvasObject> oldSel = SelectionAttributes.this.selected;
            HashMap<AttributeSet, CanvasObject> newSel = new HashMap<AttributeSet, CanvasObject>();
            for (CanvasObject o : SelectionAttributes.this.selection.getSelected()) {
                if (o == null) continue;
                newSel.put(o.getAttributeSet(), o);
            }
            SelectionAttributes.this.selected = newSel;
            boolean change = false;
            for (AttributeSet attrs : oldSel.keySet()) {
                if (newSel.containsKey(attrs)) continue;
                change = true;
                attrs.removeAttributeListener(this);
            }
            for (AttributeSet attrs : newSel.keySet()) {
                if (oldSel.containsKey(attrs)) continue;
                change = true;
                attrs.addAttributeListener(this);
            }
            if (change) {
                this.computeAttributeList(newSel.keySet());
                SelectionAttributes.this.fireAttributeListChanged();
            }
        }
    }
}

