/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.icons;

import com.cburch.logisim.gui.icons.BaseIcon;
import com.cburch.logisim.prefs.AppPreferences;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;

public class DrawPolylineIcon
extends BaseIcon {
    private static final int[] points = new int[]{1, 14, 1, 1, 7, 8, 13, 4, 10, 13};
    private boolean isPolylineClosed = false;

    public DrawPolylineIcon(boolean closed) {
        this.isPolylineClosed = closed;
    }

    @Override
    protected void paintIcon(Graphics2D gfx) {
        gfx.setStroke(new BasicStroke(AppPreferences.getScaled(2)));
        gfx.setColor(Color.BLUE.darker());
        GeneralPath p = new GeneralPath();
        int i = 0;
        p.moveTo(AppPreferences.getScaled(points[i++]), AppPreferences.getScaled(points[i++]));
        while (i < points.length - 1) {
            p.lineTo(AppPreferences.getScaled(points[i]), AppPreferences.getScaled(points[i + 1]));
            i += 2;
        }
        if (this.isPolylineClosed) {
            p.closePath();
        }
        gfx.draw(p);
        gfx.setStroke(new BasicStroke(AppPreferences.getScaled(1)));
        gfx.setColor(Color.GRAY);
        int wh = AppPreferences.getScaled(3);
        for (i = 0; i <= points.length - 1; i += 2) {
            gfx.drawRect(AppPreferences.getScaled(points[i] - 1), AppPreferences.getScaled(points[i + 1] - 1), wh, wh);
        }
    }
}

