/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.util;

import com.cburch.draw.util.EditableLabelField;
import com.cburch.draw.util.TextMetrics;
import com.cburch.logisim.data.Bounds;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

public class EditableLabel
implements Cloneable {
    public static final int LEFT = 2;
    public static final int RIGHT = 4;
    public static final int CENTER = 0;
    public static final int TOP = 8;
    public static final int MIDDLE = 9;
    public static final int BASELINE = 10;
    public static final int BOTTOM = 11;
    private int x;
    private int y;
    private String text;
    private Font font;
    private Color color;
    private int horzAlign;
    private int vertAlign;
    private boolean dimsKnown;
    private int width;
    private int ascent;
    private int descent;

    public EditableLabel(int x, int y, String text, Font font) {
        this.x = x;
        this.y = y;
        this.text = text;
        this.font = font;
        this.color = Color.BLACK;
        this.horzAlign = 2;
        this.vertAlign = 10;
        this.dimsKnown = false;
    }

    public EditableLabel clone() {
        try {
            return (EditableLabel)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return new EditableLabel(this.x, this.y, this.text, this.font);
        }
    }

    private void computeDimensions(Graphics g) {
        TextMetrics tm = new TextMetrics(g, this.text);
        this.width = tm.width;
        this.ascent = tm.ascent;
        this.descent = tm.descent;
        this.dimsKnown = true;
    }

    public void configureTextField(EditableLabelField field) {
        this.configureTextField(field, 1.0);
    }

    public void configureTextField(EditableLabelField field, double zoom) {
        int w;
        Font font = this.font;
        if (zoom != 1.0) {
            font = font.deriveFont(AffineTransform.getScaleInstance(zoom, zoom));
        }
        field.setFont(font);
        Dimension dim = field.getPreferredSize();
        int border = 2;
        if (this.dimsKnown) {
            w = this.width + 1 + 4;
        } else {
            TextMetrics tm = new TextMetrics(field, this.font, this.text);
            this.ascent = tm.ascent;
            this.descent = tm.descent;
            w = tm.width;
        }
        float x0 = this.x;
        float y0 = this.getBaseY() - (float)this.ascent;
        if (zoom != 1.0) {
            x0 = (int)Math.round((double)x0 * zoom);
            y0 = (int)Math.round((double)y0 * zoom);
            w = (int)Math.round((double)w * zoom);
        }
        w = Math.max(w, dim.width);
        int h = dim.height;
        x0 = switch (this.horzAlign) {
            case 2 -> x0 - 2.0f;
            case 0 -> x0 - (float)w / 2.0f + 1.0f;
            case 4 -> x0 - (float)w + 2.0f + 1.0f;
            default -> x0 - 2.0f;
        };
        field.setHorizontalAlignment(this.horzAlign);
        field.setForeground(this.color);
        field.setBounds((int)x0, (int)(y0 -= 2.0f), w, h);
    }

    public boolean contains(int qx, int qy) {
        float x0 = this.getLeftX();
        float y0 = this.getBaseY();
        return (float)qx >= x0 && (float)qx < x0 + (float)this.width && (float)qy >= y0 - (float)this.ascent && (float)qy < y0 + (float)this.descent;
    }

    public boolean equals(Object other) {
        if (other instanceof EditableLabel) {
            EditableLabel that = (EditableLabel)other;
            return this.x == that.x && this.y == that.y && this.text.equals(that.text) && this.font.equals(that.font) && this.color.equals(that.color) && this.horzAlign == that.horzAlign && this.vertAlign == that.vertAlign;
        }
        return false;
    }

    private float getBaseY() {
        return switch (this.vertAlign) {
            case 8 -> this.y + this.ascent;
            case 9 -> (float)this.y + (float)(this.ascent - this.descent) / 2.0f;
            case 10 -> this.y;
            case 11 -> this.y - this.descent;
            default -> this.y;
        };
    }

    public Bounds getBounds() {
        int x0 = (int)this.getLeftX();
        int y0 = (int)this.getBaseY() - this.ascent;
        int w = this.width;
        int h = this.ascent + this.descent;
        return Bounds.create(x0, y0, w, h);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color value) {
        this.color = value;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font value) {
        this.font = value;
        this.dimsKnown = false;
    }

    public int getHorizontalAlignment() {
        return this.horzAlign;
    }

    public void setHorizontalAlignment(int value) {
        if (value != 2 && value != 0 && value != 4) {
            throw new IllegalArgumentException("argument must be LEFT, CENTER, or RIGHT");
        }
        this.horzAlign = value;
        this.dimsKnown = false;
    }

    private float getLeftX() {
        return switch (this.horzAlign) {
            case 2 -> this.x;
            case 0 -> (float)this.x - (float)this.width / 2.0f;
            case 4 -> this.x - this.width;
            default -> this.x;
        };
    }

    public String getText() {
        return this.text;
    }

    public void setText(String value) {
        this.dimsKnown = false;
        this.text = value;
    }

    public int getVerticalAlignment() {
        return this.vertAlign;
    }

    public void setVerticalAlignment(int value) {
        if (value != 8 && value != 9 && value != 10 && value != 11) {
            throw new IllegalArgumentException("argument must be TOP, MIDDLE, BASELINE, or BOTTOM");
        }
        this.vertAlign = value;
        this.dimsKnown = false;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int hashCode() {
        int ret = this.x * 31 + this.y;
        ret = ret * 31 + this.text.hashCode();
        ret = ret * 31 + this.font.hashCode();
        ret = ret * 31 + this.color.hashCode();
        ret = ret * 31 + this.horzAlign;
        ret = ret * 31 + this.vertAlign;
        return ret;
    }

    public void paint(Graphics g) {
        g.setFont(this.font);
        g.setColor(this.color);
        this.computeDimensions(g);
        float x0 = this.getLeftX();
        float y0 = this.getBaseY();
        ((Graphics2D)g).drawString(this.text, x0, y0);
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }
}

