/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.util;

import com.cburch.draw.model.CanvasModel;
import com.cburch.draw.model.CanvasObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public final class ZOrder {
    private ZOrder() {
    }

    private static int getIndex(CanvasObject query, List<CanvasObject> objs) {
        int index = -1;
        for (CanvasObject o : objs) {
            ++index;
            if (o != query) continue;
            return index;
        }
        return -1;
    }

    public static CanvasObject getObjectAbove(CanvasObject query, CanvasModel model, Collection<? extends CanvasObject> ignore) {
        return ZOrder.getPrevious(query, model.getObjectsFromTop(), model, ignore);
    }

    public static CanvasObject getObjectBelow(CanvasObject query, CanvasModel model, Collection<? extends CanvasObject> ignore) {
        return ZOrder.getPrevious(query, model.getObjectsFromBottom(), model, ignore);
    }

    private static CanvasObject getPrevious(CanvasObject query, List<CanvasObject> objs, CanvasModel model, Collection<? extends CanvasObject> ignore) {
        int index = ZOrder.getIndex(query, objs);
        if (index > 0) {
            Set<CanvasObject> set = ZOrder.toSet(model.getObjectsOverlapping(query));
            ListIterator<CanvasObject> it = objs.listIterator(index);
            while (it.hasPrevious()) {
                CanvasObject o = it.previous();
                if (!set.contains(o) || ignore.contains(o)) continue;
                return o;
            }
        }
        return null;
    }

    public static int getZIndex(CanvasObject query, CanvasModel model) {
        return ZOrder.getIndex(query, model.getObjectsFromBottom());
    }

    public static Map<CanvasObject, Integer> getZIndex(Collection<? extends CanvasObject> query, CanvasModel model) {
        if (query == null) {
            return Collections.emptyMap();
        }
        Set<? extends CanvasObject> querySet = ZOrder.toSet(query);
        LinkedHashMap<CanvasObject, Integer> ret = new LinkedHashMap<CanvasObject, Integer>(query.size());
        int z = -1;
        for (CanvasObject o : model.getObjectsFromBottom()) {
            ++z;
            if (!querySet.contains(o)) continue;
            ret.put(o, z);
        }
        return ret;
    }

    public static <E extends CanvasObject> List<E> sortBottomFirst(Collection<E> objects, CanvasModel model) {
        return ZOrder.sortXFirst(objects, model, model.getObjectsFromTop());
    }

    public static <E extends CanvasObject> List<E> sortTopFirst(Collection<E> objects, CanvasModel model) {
        return ZOrder.sortXFirst(objects, model, model.getObjectsFromBottom());
    }

    private static <E extends CanvasObject> List<E> sortXFirst(Collection<E> objects, CanvasModel model, Collection<CanvasObject> objs) {
        Set<E> set = ZOrder.toSet(objects);
        ArrayList<CanvasObject> ret = new ArrayList<CanvasObject>(objects.size());
        for (CanvasObject o : objs) {
            if (!set.contains(o)) continue;
            CanvasObject toAdd = o;
            ret.add(toAdd);
        }
        return ret;
    }

    private static <E> Set<E> toSet(Collection<E> objects) {
        return objects instanceof Set ? (Set)objects : new HashSet<E>(objects);
    }
}

