/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.hex;

import com.cburch.hex.Caret;
import com.cburch.hex.HexModel;
import com.cburch.hex.HexModelListener;
import com.cburch.hex.Highlighter;
import com.cburch.hex.Measures;
import com.cburch.logisim.prefs.AppPreferences;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.Scrollable;

public class HexEditor
extends JComponent
implements Scrollable {
    private static final long serialVersionUID = 1L;
    private final Listener listener;
    private final Measures measures;
    private final Caret caret;
    private final Highlighter highlighter;
    private HexModel model;

    public HexEditor(HexModel model) {
        this.model = model;
        this.listener = new Listener();
        this.measures = new Measures(this);
        this.caret = new Caret(this);
        this.highlighter = new Highlighter(this);
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        if (model != null) {
            model.addHexModelListener(this.listener);
        }
        this.measures.recompute();
    }

    public Object addHighlight(int start, int end, Color color) {
        return this.highlighter.add(start, end, color);
    }

    public void delete() {
        long p0 = this.caret.getMark();
        long p1 = this.caret.getDot();
        if (p0 < 0L || p1 < 0L) {
            return;
        }
        if (p0 > p1) {
            long t = p0;
            p0 = p1;
            p1 = t;
        }
        this.model.fill(p0, p1 - p0 + 1L, 0L);
    }

    public Caret getCaret() {
        return this.caret;
    }

    Highlighter getHighlighter() {
        return this.highlighter;
    }

    Measures getMeasures() {
        return this.measures;
    }

    public HexModel getModel() {
        return this.model;
    }

    public void setModel(HexModel value) {
        if (this.model == value) {
            return;
        }
        if (this.model != null) {
            this.model.removeHexModelListener(this.listener);
        }
        this.model = value;
        this.highlighter.clear();
        this.caret.setDot(-1L, false);
        if (this.model != null) {
            this.model.addHexModelListener(this.listener);
        }
        this.measures.recompute();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle vis, int orientation, int direction) {
        if (orientation == 1) {
            int height = this.measures.getCellHeight();
            if (height < 1) {
                this.measures.recompute();
                height = this.measures.getCellHeight();
                if (height < 1) {
                    return 19 * vis.height / 20;
                }
            }
            int lines = Math.max(1, vis.height / height - 1);
            return lines * height;
        }
        return 19 * vis.width / 20;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle vis, int orientation, int direction) {
        if (orientation == 1) {
            int ret = this.measures.getCellHeight();
            if (ret < 1) {
                this.measures.recompute();
                ret = this.measures.getCellHeight();
                if (ret < 1) {
                    return 1;
                }
            }
            return ret;
        }
        return Math.max(1, vis.width / 20);
    }

    @Override
    protected void paintComponent(Graphics gfx) {
        if (AppPreferences.AntiAliassing.getBoolean()) {
            Graphics2D g2 = (Graphics2D)gfx;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.measures.ensureComputed(gfx);
        Rectangle clip = gfx.getClipBounds();
        if (this.isOpaque()) {
            gfx.setColor(this.getBackground());
            gfx.fillRect(clip.x, clip.y, clip.width, clip.height);
        }
        long addr0 = this.model.getFirstOffset();
        long addr1 = this.model.getLastOffset();
        long xaddr0 = this.measures.toAddress(0, clip.y);
        if (xaddr0 == addr0) {
            xaddr0 = this.measures.getBaseAddress(this.model);
        }
        long xaddr1 = this.measures.toAddress(this.getWidth(), clip.y + clip.height) + 1L;
        this.highlighter.paint(gfx, xaddr0, xaddr1);
        gfx.setColor(this.getForeground());
        Font baseFont = gfx.getFont();
        FontMetrics baseFm = gfx.getFontMetrics(baseFont);
        Font labelFont = baseFont.deriveFont(2);
        FontMetrics labelFm = gfx.getFontMetrics(labelFont);
        int cols = this.measures.getColumnCount();
        int baseX = this.measures.getBaseX();
        int baseY = this.measures.toY(xaddr0) + baseFm.getAscent() + baseFm.getLeading() / 2;
        int dy = this.measures.getCellHeight();
        int labelWidth = this.measures.getLabelWidth();
        int labelChars = this.measures.getLabelChars();
        int cellWidth = this.measures.getCellWidth();
        int cellChars = this.measures.getCellChars();
        long a = xaddr0;
        while (a < xaddr1) {
            String label = this.toHex(a, labelChars);
            gfx.setFont(labelFont);
            gfx.drawString(label, baseX - labelWidth + (labelWidth - labelFm.stringWidth(label)) / 2, baseY);
            gfx.setFont(baseFont);
            long b = a;
            int j = 0;
            while (j < cols) {
                if (b >= addr0 && b <= addr1) {
                    String val = this.toHex(this.model.get(b), cellChars);
                    int x = this.measures.toX(b) + (cellWidth - baseFm.stringWidth(val)) / 2;
                    gfx.drawString(val, x, baseY);
                }
                ++j;
                ++b;
            }
            a += (long)cols;
            baseY += dy;
        }
        this.caret.paintForeground(gfx, xaddr0, xaddr1);
    }

    public void removeHighlight(Object tag) {
        this.highlighter.remove(tag);
    }

    public void scrollAddressToVisible(int start, int end) {
        if (start < 0 || end < 0) {
            return;
        }
        int x0 = this.measures.toX(start);
        int x1 = this.measures.toX(end) + this.measures.getCellWidth();
        int y0 = this.measures.toY(start);
        int y1 = this.measures.toY(end);
        int h = this.measures.getCellHeight();
        if (y0 == y1) {
            this.scrollRectToVisible(new Rectangle(x0, y0, x1 - x0, h));
        } else {
            this.scrollRectToVisible(new Rectangle(x0, y0, x1 - x0, y1 + h - y0));
        }
    }

    public void selectAll() {
        this.caret.setDot(this.model.getLastOffset(), false);
        this.caret.setDot(0L, true);
    }

    public boolean selectionExists() {
        return this.caret.getMark() >= 0L && this.caret.getDot() >= 0L;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.measures.widthChanged();
    }

    @Override
    public void setFont(Font value) {
        super.setFont(value);
        this.measures.recompute();
    }

    private String toHex(long value, int chars) {
        String ret = String.format("%0" + chars + "x", value);
        return ret.length() > chars ? ret.substring(ret.length() - chars) : ret;
    }

    private class Listener
    implements HexModelListener {
        private Listener() {
        }

        @Override
        public void bytesChanged(HexModel source, long start, long numBytes, long[] oldValues) {
            HexEditor.this.repaint(0, HexEditor.this.measures.toY(start), HexEditor.this.getWidth(), HexEditor.this.measures.toY(start + numBytes) + HexEditor.this.measures.getCellHeight());
        }

        @Override
        public void metainfoChanged(HexModel source) {
            HexEditor.this.measures.recompute();
            HexEditor.this.repaint();
        }
    }
}

