/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.analyze.gui;

import com.cburch.logisim.analyze.data.ExpressionRenderData;
import com.cburch.logisim.analyze.model.Expression;
import com.cburch.logisim.analyze.model.Expressions;
import com.cburch.logisim.prefs.AppPreferences;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JPanel;

class ExpressionView
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final MyListener myListener = new MyListener();
    private Expression.Notation notation = Expression.Notation.MATHEMATICAL;
    private ExpressionRenderData renderData;
    private Expression expr;
    private int width;
    private boolean selected;

    boolean isSelected() {
        return this.selected;
    }

    public ExpressionView() {
        this.addComponentListener(this.myListener);
        this.setExpression((Expression)null);
        this.width = -1;
        FocusListener f = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (e.isTemporary()) {
                    return;
                }
                ExpressionView.this.selected = true;
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (e.isTemporary()) {
                    return;
                }
                ExpressionView.this.selected = false;
            }
        };
        this.addFocusListener(f);
    }

    public void setWidth(int w) {
        this.removeComponentListener(this.myListener);
        this.width = w;
    }

    public ExpressionRenderData getRenderData() {
        return this.renderData;
    }

    public void setNotation(Expression.Notation notation) {
        if (this.notation == notation || this.expr == null) {
            return;
        }
        this.notation = notation;
        this.setExpression(this.expr);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (AppPreferences.AntiAliassing.getBoolean()) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        super.paintComponent(g);
        if (this.renderData != null) {
            Dimension bds = this.renderData.getPreferredSize();
            int x = Math.max(0, this.width < 0 ? (this.getWidth() - (int)bds.getWidth()) / 2 : 0);
            int y = Math.max(0, this.width < 0 ? (this.getHeight() - (int)bds.getHeight()) / 2 : 0);
            this.renderData.paint(g, x, y);
        }
    }

    public int getExpressionHeight() {
        int defaultHeight = 25;
        if (this.renderData == null) {
            return 25;
        }
        return (int)this.renderData.getPreferredSize().getHeight();
    }

    public void setExpression(NamedExpression e) {
        if (e.expr != null) {
            this.setExpression(e.name, e.expr);
        } else {
            this.setError(e.name, e.err != null ? e.err : "unspecified");
        }
    }

    public void setExpression(Expression expr) {
        this.expr = expr;
        this.renderData = new ExpressionRenderData(expr, this.width < 0 ? this.getWidth() : this.width, this.notation);
        this.setPreferredSize(this.renderData.getPreferredSize());
        this.revalidate();
        this.repaint();
    }

    public void setExpression(String name, Expression expr) {
        this.setExpression(Expressions.eq(Expressions.variable(name), expr));
    }

    public void setError(String name, String msg) {
        this.setExpression(Expressions.eq(Expressions.variable(name), Expressions.variable(msg)));
    }

    private class MyListener
    extends ComponentAdapter {
        private MyListener() {
        }

        @Override
        public void componentResized(ComponentEvent arg0) {
            int width = ExpressionView.this.getWidth();
            if (ExpressionView.this.renderData != null && Math.abs(ExpressionView.this.renderData.getParentWidth() - width) > 2) {
                ExpressionView.this.renderData = new ExpressionRenderData(ExpressionView.this.expr, width, ExpressionView.this.notation);
                ExpressionView.this.setPreferredSize(ExpressionView.this.renderData.getPreferredSize());
                ExpressionView.this.revalidate();
                ExpressionView.this.repaint();
            }
        }
    }

    public static class NamedExpression {
        public final String name;
        public Expression expr;
        public String exprString;
        public String err;

        NamedExpression(String n) {
            this.name = n;
        }

        NamedExpression(String n, Expression e, String s) {
            this.name = n;
            this.expr = e;
            this.exprString = s;
        }
    }
}

