/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.analyze.gui;

import com.cburch.logisim.analyze.Strings;
import com.cburch.logisim.analyze.gui.AnalyzerTab;
import com.cburch.logisim.analyze.model.ParserException;
import com.cburch.logisim.analyze.model.Var;
import com.cburch.logisim.analyze.model.VariableList;
import com.cburch.logisim.analyze.model.VariableListEvent;
import com.cburch.logisim.analyze.model.VariableListListener;
import com.cburch.logisim.gui.menu.EditHandler;
import com.cburch.logisim.gui.menu.LogisimMenuBar;
import com.cburch.logisim.gui.menu.LogisimMenuItem;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.util.SyntaxChecker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DropMode;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import org.jdesktop.swingx.prompt.BuddySupport;

public class VariableTab
extends AnalyzerTab {
    private static final long serialVersionUID = 1L;
    private final JTable inputsTable;
    private final JTable outputsTable;
    private final JLabel error = new JLabel(" ");
    private final JLabel inputsLabel;
    private final JLabel outputsLabel;
    private JTable focus;
    public static final int OK = 0;
    public static final int EMPTY = 1;
    public static final int UNCHANGED = 2;
    public static final int RESIZED = 3;
    public static final int BAD_NAME = 4;
    public static final int DUP_NAME = 5;
    private static final int TOO_WIDE = 6;
    public static final int NO_START_PAR = -1;
    public static final int NO_VALID_MSB_INDEX = -2;
    public static final int NO_VALID_INDEX_SEP = -3;
    public static final int NO_VALID_LSB_INDEX = -4;
    public static final int LSB_BIGGER_MSB = -5;
    public static final int NO_FINAL_PAR = -6;
    public static final int INVALID_CHARS = -7;
    final EditHandler editHandler = new EditHandler(){

        @Override
        public void computeEnabled() {
            int n = VariableTab.this.focus == null || VariableTab.this.focus.isEditing() ? -1 : VariableTab.this.focus.getRowCount() - 1;
            int i = VariableTab.this.focus == null || VariableTab.this.focus.isEditing() ? -1 : VariableTab.this.focus.getSelectedRow();
            this.setEnabled(LogisimMenuBar.CUT, true);
            this.setEnabled(LogisimMenuBar.COPY, true);
            this.setEnabled(LogisimMenuBar.PASTE, true);
            this.setEnabled(LogisimMenuBar.DELETE, true);
            this.setEnabled(LogisimMenuBar.DUPLICATE, false);
            this.setEnabled(LogisimMenuBar.SELECT_ALL, VariableTab.this.focus != null && VariableTab.this.focus.isEditing());
            this.setEnabled(LogisimMenuBar.RAISE, 0 < i && i <= n - 1);
            this.setEnabled(LogisimMenuBar.LOWER, 0 <= i && i < n - 1);
            this.setEnabled(LogisimMenuBar.RAISE_TOP, 0 < i && i <= n - 1);
            this.setEnabled(LogisimMenuBar.LOWER_BOTTOM, 0 <= i && i < n - 1);
            this.setEnabled(LogisimMenuBar.ADD_CONTROL, false);
            this.setEnabled(LogisimMenuBar.REMOVE_CONTROL, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object action = e.getSource();
            if (VariableTab.this.focus != null) {
                VariableTab.this.focus.getActionMap().get(action).actionPerformed(null);
            }
        }
    };

    private JTable ioTable(VariableList data, LogisimMenuBar menubar) {
        final SingleClickVarEditor ed1 = new SingleClickVarEditor(data);
        final DoubleClickVarEditor ed2 = new DoubleClickVarEditor(data);
        JTable table = new JTable(this, 1, 1){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ VariableTab this$0;
            {
                this.this$0 = this$0;
                super(arg0, arg1);
            }

            @Override
            public TableCellEditor getCellEditor(int row, int column) {
                return row == this.getRowCount() - 1 ? ed1 : ed2;
            }
        };
        table.getTableHeader().setUI(null);
        table.setModel(new VariableTableModel(data, table));
        table.setDefaultRenderer(Var.class, new VarRenderer());
        table.setRowHeight(30);
        table.setShowGrid(false);
        table.setDragEnabled(true);
        table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        table.setSelectionMode(0);
        VarTransferHandler ccp = new VarTransferHandler(table, data);
        table.setTransferHandler(ccp);
        table.setDropMode(DropMode.INSERT_ROWS);
        InputMap inputMap = table.getInputMap();
        for (LogisimMenuItem item : LogisimMenuBar.EDIT_ITEMS) {
            KeyStroke accel = menubar.getAccelerator(item);
            inputMap.put(accel, item);
        }
        ActionMap actionMap = table.getActionMap();
        actionMap.put(LogisimMenuBar.CUT, TransferHandler.getCutAction());
        actionMap.put(LogisimMenuBar.COPY, TransferHandler.getCopyAction());
        actionMap.put(LogisimMenuBar.PASTE, TransferHandler.getPasteAction());
        actionMap.put(LogisimMenuBar.DELETE, new AbstractAction(this, table, data){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ 1 val$table;
            final /* synthetic */ VariableList val$data;
            final /* synthetic */ VariableTab this$0;
            {
                this.val$table = var2_2;
                this.val$data = variableList;
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int idx = this.val$table.getSelectedRow();
                if (idx < 0 || idx >= this.val$data.vars.size()) {
                    return;
                }
                this.val$data.remove(this.val$data.vars.get(idx));
                if (idx >= this.val$data.vars.size()) {
                    idx = this.val$data.vars.size() - 1;
                }
                if (idx >= 0) {
                    this.val$table.changeSelection(idx, 0, false, false);
                }
            }
        });
        actionMap.put(LogisimMenuBar.RAISE, new AbstractAction(this, table, data){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ 1 val$table;
            final /* synthetic */ VariableList val$data;
            final /* synthetic */ VariableTab this$0;
            {
                this.val$table = var2_2;
                this.val$data = variableList;
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int idx = this.val$table.getSelectedRow();
                if (idx <= 0 || idx > this.val$data.vars.size() - 1) {
                    return;
                }
                this.val$data.move(this.val$data.vars.get(idx), -1);
                this.val$table.changeSelection(idx - 1, 0, false, false);
            }
        });
        actionMap.put(LogisimMenuBar.LOWER, new AbstractAction(this, table, data){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ 1 val$table;
            final /* synthetic */ VariableList val$data;
            final /* synthetic */ VariableTab this$0;
            {
                this.val$table = var2_2;
                this.val$data = variableList;
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int idx = this.val$table.getSelectedRow();
                if (idx < 0 || idx >= this.val$data.vars.size() - 1) {
                    return;
                }
                this.val$data.move(this.val$data.vars.get(idx), 1);
                this.val$table.changeSelection(idx + 1, 0, false, false);
            }
        });
        actionMap.put(LogisimMenuBar.RAISE_TOP, new AbstractAction(this, table, data){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ 1 val$table;
            final /* synthetic */ VariableList val$data;
            final /* synthetic */ VariableTab this$0;
            {
                this.val$table = var2_2;
                this.val$data = variableList;
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int idx = this.val$table.getSelectedRow();
                if (idx <= 0 || idx > this.val$data.vars.size() - 1) {
                    return;
                }
                this.val$data.move(this.val$data.vars.get(idx), -idx);
                this.val$table.changeSelection(0, 0, false, false);
            }
        });
        actionMap.put(LogisimMenuBar.LOWER_BOTTOM, new AbstractAction(this, table, data){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ 1 val$table;
            final /* synthetic */ VariableList val$data;
            final /* synthetic */ VariableTab this$0;
            {
                this.val$table = var2_2;
                this.val$data = variableList;
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int idx = this.val$table.getSelectedRow();
                int end = this.val$data.vars.size() - 1;
                if (idx < 0 || idx >= this.val$data.vars.size() - 1) {
                    return;
                }
                this.val$data.move(this.val$data.vars.get(idx), end - idx);
                this.val$table.changeSelection(end, 0, false, false);
            }
        });
        return table;
    }

    private JScrollPane wrap(final JTable table) {
        JScrollPane scroll = new JScrollPane(table, 22, 31);
        scroll.setPreferredSize(new Dimension(AppPreferences.getScaled(60), AppPreferences.getScaled(100)));
        scroll.addMouseListener(new MouseAdapter(this){

            @Override
            public void mouseClicked(MouseEvent me) {
                table.changeSelection(table.getRowCount() - 1, 0, false, false);
                table.grabFocus();
            }
        });
        scroll.setTransferHandler(table.getTransferHandler());
        table.addFocusListener(new FocusListener(){
            final /* synthetic */ VariableTab this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (e.isTemporary()) {
                    return;
                }
                this.this$0.focus = table;
                this.this$0.editHandler.computeEnabled();
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (e.isTemporary()) {
                    return;
                }
                table.clearSelection();
                if (this.this$0.focus == table) {
                    this.this$0.focus = null;
                }
            }
        });
        return scroll;
    }

    VariableTab(VariableList inputs, VariableList outputs, LogisimMenuBar menubar) {
        inputs.addCompanion(outputs);
        outputs.addCompanion(inputs);
        this.inputsTable = this.ioTable(inputs, menubar);
        this.outputsTable = this.ioTable(outputs, menubar);
        JScrollPane inputsTablePane = this.wrap(this.inputsTable);
        JScrollPane outputsTablePane = this.wrap(this.outputsTable);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gbl);
        gbc.insets = new Insets(10, 10, 2, 10);
        gbc.fill = 2;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        this.inputsLabel = new JLabel("Input Variables");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbl.setConstraints(this.inputsLabel, gbc);
        this.add(this.inputsLabel);
        this.outputsLabel = new JLabel("Output Variables");
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbl.setConstraints(this.outputsLabel, gbc);
        this.add(this.outputsLabel);
        gbc.insets = new Insets(2, 10, 3, 10);
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbl.setConstraints(inputsTablePane, gbc);
        this.add(inputsTablePane);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbl.setConstraints(outputsTablePane, gbc);
        this.add(outputsTablePane);
        gbc.insets = new Insets(3, 10, 10, 10);
        gbc.fill = 2;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbl.setConstraints(this.error, gbc);
        this.add(this.error);
        this.error.setForeground(Color.RED);
        if (!outputs.vars.isEmpty()) {
            this.outputsTable.changeSelection(0, 0, false, false);
            this.focus = this.outputsTable;
        } else if (!inputs.vars.isEmpty()) {
            this.inputsTable.changeSelection(0, 0, false, false);
            this.focus = this.inputsTable;
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (VariableTab.this.focus != null) {
                    VariableTab.this.focus.requestFocusInWindow();
                }
            }
        });
        this.editHandler.computeEnabled();
    }

    @Override
    void localeChanged() {
        this.inputsLabel.setText(Strings.S.get("inputVariables"));
        this.outputsLabel.setText(Strings.S.get("outputVariables"));
    }

    @Override
    void updateTab() {
        VariableTableModel inputModel = (VariableTableModel)this.inputsTable.getModel();
        inputModel.update();
        VariableTableModel outputModel = (VariableTableModel)this.outputsTable.getModel();
        outputModel.update();
    }

    public static int checkindex(String index) {
        int length = index.length();
        int pos = 0;
        if (length < 2) {
            return 0;
        }
        if (index.charAt(pos++) != '[') {
            return -1;
        }
        while (pos < length && "0123456789".indexOf(index.charAt(pos)) >= 0) {
            ++pos;
        }
        if (pos == 1) {
            return -2;
        }
        int msbIndex = Integer.parseInt(index.substring(1, pos));
        if (pos >= length) {
            return -6;
        }
        if (index.charAt(pos) == ']') {
            if (++pos != length) {
                return -7;
            }
            return msbIndex;
        }
        if (pos >= length - 2) {
            return -3;
        }
        if (!index.startsWith("..", pos)) {
            return -3;
        }
        int curpos = pos += 2;
        while (pos < length && "0123456789".indexOf(index.charAt(pos)) >= 0) {
            ++pos;
        }
        if (pos == curpos) {
            return -4;
        }
        int lsbIndex = Integer.parseInt(index.substring(curpos, pos));
        if (lsbIndex > msbIndex) {
            return -5;
        }
        if (pos >= length) {
            return -6;
        }
        if (index.charAt(pos++) != ']') {
            return -6;
        }
        if (pos != length) {
            return -7;
        }
        return msbIndex - lsbIndex + 1;
    }

    private int validateInput(VariableList data, Var oldVar, String text, int w) {
        String message;
        int err = 0;
        if (text.length() == 0) {
            err = 1;
        } else if (!Character.isJavaIdentifierStart(text.charAt(0))) {
            this.error.setText(Strings.S.get("variableStartError"));
            err = 4;
        } else {
            for (int i = 1; i < text.length() && err == 0; ++i) {
                char c = text.charAt(i);
                if (Character.isJavaIdentifierPart(c)) continue;
                this.error.setText(Strings.S.get("variablePartError", "" + c));
                err = 4;
            }
        }
        if (err == 0 && (message = SyntaxChecker.getErrorMessage(text)) != null) {
            err = 4;
            this.error.setText(message);
        }
        if (err == 0 && oldVar != null) {
            if (oldVar.name.equals(text) && oldVar.width == w) {
                err = 2;
            } else if (oldVar.name.equals(text)) {
                err = 3;
            }
        }
        if (err == 0 && data.containsDuplicate(data, oldVar, text)) {
            this.error.setText(Strings.S.get("variableDuplicateError"));
            err = 5;
        }
        if (err == 0 || err == 1) {
            if (data.bits.size() + w > data.getMaximumSize()) {
                this.error.setText(Strings.S.get("variableMaximumError", "" + data.getMaximumSize()));
                err = 6;
            } else {
                this.error.setText(" ");
            }
        }
        return err;
    }

    @Override
    EditHandler getEditHandler() {
        return this.editHandler;
    }

    Var parse(String s) {
        try {
            return Var.parse(s);
        }
        catch (ParserException e) {
            this.error.setText(e.getMessage());
            return null;
        }
    }

    public class SingleClickVarEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        final JTextField field = new JTextField();
        final JComboBox<Integer> width;
        Var editing;
        final VariableList data;

        public SingleClickVarEditor(VariableList data) {
            this.field.setBorder(BorderFactory.createCompoundBorder(this.field.getBorder(), BorderFactory.createEmptyBorder(1, 3, 1, 3)));
            this.data = data;
            int maxwidth = data.getMaximumSize();
            Integer[] widths = new Integer[Math.min(maxwidth, 32)];
            for (int i = 0; i < widths.length; ++i) {
                widths[i] = i + 1;
            }
            this.width = new JComboBox<Integer>(widths);
            this.width.setFocusable(false);
            this.width.setRenderer(new BitWidthRenderer());
            this.width.setMaximumRowCount(widths.length);
            BuddySupport.addRight(this.width, this.field);
        }

        @Override
        public Object getCellEditorValue() {
            String name = this.field.getText().trim();
            Integer w = (Integer)this.width.getSelectedItem();
            return new Var(name, w);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.editing = (Var)value;
            this.field.setText(this.editing.name);
            this.width.setSelectedItem(this.editing.width);
            return this.field;
        }

        @Override
        public boolean stopCellEditing() {
            if (this.ok()) {
                super.stopCellEditing();
                return true;
            }
            return false;
        }

        boolean ok() {
            int err;
            int w;
            Var oldVar = this.editing;
            this.editing = null;
            String text = this.field.getText().trim();
            String name = "";
            String index = "";
            if (text.contains("[")) {
                int idx = text.indexOf(91);
                name = text.substring(0, idx);
                index = text.substring(idx);
                w = VariableTab.checkindex(index);
                if (w <= 0) {
                    String errorText = null;
                    if (w == -1) {
                        errorText = Strings.S.get("variableRangeStartPar");
                    } else if (w == -2) {
                        errorText = Strings.S.get("variableRangeMSBWrong");
                    } else if (w == -3) {
                        errorText = Strings.S.get("variableRangeWrongSep");
                    } else if (w == -4) {
                        errorText = Strings.S.get("variableRangeWrongSep");
                    } else if (w == -5) {
                        errorText = Strings.S.get("variableRangeWrongLB");
                    } else if (w == -6) {
                        errorText = Strings.S.get("variableRangeFinalPar");
                    } else if (w == -7) {
                        errorText = Strings.S.get("variableRangeInvalChar");
                    }
                    if (errorText != null) {
                        VariableTab.this.error.setText(errorText);
                    }
                    w = (Integer)this.width.getSelectedItem();
                    return false;
                }
                this.width.setSelectedIndex(w - 1);
                --w;
                this.field.setText(name);
            } else {
                name = text;
                w = (Integer)this.width.getSelectedItem();
            }
            if (oldVar == null || oldVar.name.equals("")) {
                err = VariableTab.this.validateInput(this.data, null, name, w);
                if (err == 1) {
                    return true;
                }
                if (err == 4 || err == 5 || err == 6) {
                    return false;
                }
                return err == 0;
            }
            err = VariableTab.this.validateInput(this.data, oldVar, name, w);
            if (err == 1 || err == 4 || err == 5 || err == 6) {
                return false;
            }
            if (err == 2) {
                return true;
            }
            return err == 0 || err == 3;
        }
    }

    public class DoubleClickVarEditor
    extends SingleClickVarEditor {
        private static final long serialVersionUID = 1L;

        public DoubleClickVarEditor(VariableList data) {
            super(data);
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (super.isCellEditable(e)) {
                if (e instanceof MouseEvent) {
                    MouseEvent me = (MouseEvent)e;
                    return me.getClickCount() >= 2;
                }
                if (e instanceof KeyEvent) {
                    KeyEvent ke = (KeyEvent)e;
                    return ke.getKeyCode() == 113 || ke.getKeyCode() == 10;
                }
            }
            return false;
        }
    }

    private static class VariableTableModel
    extends AbstractTableModel
    implements VariableListListener {
        private static final long serialVersionUID = 1L;
        private final JTable table;
        private final VariableList list;
        private Var[] listCopy;
        private final Var empty = new Var("", 1);

        public VariableTableModel(VariableList list, JTable table) {
            this.list = list;
            this.table = table;
            this.updateCopy();
            list.addVariableListListener(this);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }

        @Override
        public void setValueAt(Object obj, int row, int column) {
            Var newVar = (Var)obj;
            Var oldVar = (Var)this.getValueAt(row, column);
            if (newVar == null || newVar.name.equals("") || newVar.equals(oldVar)) {
                return;
            }
            if (row == this.listCopy.length) {
                this.list.add(newVar);
                this.table.changeSelection(row + 1, column, false, false);
            } else {
                this.list.replace(oldVar, newVar);
                this.table.changeSelection(row, column, false, false);
            }
            this.table.grabFocus();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row == this.listCopy.length) {
                return this.empty;
            }
            if (row >= 0 && row < this.listCopy.length) {
                return this.listCopy[row];
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int column) {
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return Var.class;
        }

        @Override
        public int getRowCount() {
            return this.listCopy.length + 1;
        }

        @Override
        public void listChanged(VariableListEvent event) {
            int oldSize = this.listCopy.length;
            this.updateCopy();
            Integer idx = event.getIndex();
            switch (event.getType()) {
                case 0: {
                    this.fireTableRowsUpdated(0, oldSize);
                    break;
                }
                case 1: {
                    this.fireTableRowsInserted(idx, idx);
                    break;
                }
                case 2: {
                    this.fireTableRowsDeleted(idx, idx);
                    break;
                }
                case 3: {
                    this.fireTableRowsUpdated(0, this.listCopy.length - 1);
                    break;
                }
                case 4: {
                    this.fireTableRowsUpdated(idx, idx);
                    break;
                }
            }
        }

        private void update() {
            this.updateCopy();
            this.fireTableDataChanged();
        }

        private void updateCopy() {
            this.listCopy = this.list.vars.toArray(new Var[0]);
        }
    }

    public static class VarRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        final Border border = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        final Font plain;
        final Font italic;

        public VarRenderer() {
            this.setBorder(this.border);
            this.plain = AppPreferences.getScaledFont(this.getFont());
            this.italic = AppPreferences.getScaledFont(this.plain.deriveFont(2));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            boolean empty = value.toString().equals("");
            if (empty) {
                value = Strings.S.get("variableClickToAdd");
            }
            JComponent c = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            c.setFont(empty ? this.italic : this.plain);
            return c;
        }
    }

    private class VarTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 1L;
        final JTable table;
        final VariableList data;
        Var pendingDelete;

        VarTransferHandler(JTable table, VariableList data) {
            this.table = table;
            this.data = data;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            int err;
            int oldIdx;
            String s;
            try {
                s = (String)info.getTransferable().getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception e) {
                return false;
            }
            Var newVar = VariableTab.this.parse(s);
            if (newVar == null) {
                return false;
            }
            int newIdx = this.data.vars.size();
            if (info.isDrop()) {
                try {
                    JTable.DropLocation dl = (JTable.DropLocation)info.getDropLocation();
                    newIdx = Math.min(dl.getRow(), this.data.vars.size());
                }
                catch (ClassCastException dl) {
                    // empty catch block
                }
            }
            Var oldVar = null;
            for (oldIdx = 0; oldIdx < this.data.vars.size(); ++oldIdx) {
                Var v = this.data.vars.get(oldIdx);
                if (!v.name.equals(newVar.name)) continue;
                oldVar = v;
                break;
            }
            if ((err = VariableTab.this.validateInput(this.data, oldVar, newVar.name, newVar.width)) == 2) {
                this.pendingDelete = null;
                if (newIdx > oldIdx) {
                    --newIdx;
                }
                if (oldIdx != newIdx) {
                    this.data.move(oldVar, newIdx - oldIdx);
                    this.table.changeSelection(newIdx, 0, false, false);
                    this.table.grabFocus();
                }
                return true;
            }
            if (err == 0) {
                this.pendingDelete = null;
                this.data.add(newVar);
                if (newIdx < this.data.vars.size() - 1) {
                    this.data.move(newVar, newIdx - this.data.vars.size() + 2);
                }
                this.table.changeSelection(newIdx, 0, false, false);
                this.table.grabFocus();
                return true;
            }
            if (err == 3) {
                this.pendingDelete = null;
                this.data.replace(oldVar, newVar);
                this.table.changeSelection(oldIdx, 0, false, false);
                this.table.grabFocus();
                return true;
            }
            return false;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            int row = this.table.getSelectedRow();
            if (row < 0 || row >= this.data.vars.size()) {
                return null;
            }
            this.pendingDelete = this.data.vars.get(row);
            return new StringSelection(this.pendingDelete.toString());
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }

        @Override
        protected void exportDone(JComponent c, Transferable tdata, int action) {
            if (action == 2 && this.pendingDelete != null) {
                this.data.remove(this.pendingDelete);
            }
            this.pendingDelete = null;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return support.isDataFlavorSupported(DataFlavor.stringFlavor);
        }
    }

    static class BitWidthRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object w, int index, boolean isSelected, boolean cellHasFocus) {
            String s = (Integer)w == 1 ? "1 bit" : String.valueOf(w) + " bits";
            return super.getListCellRendererComponent(list, s, index, isSelected, cellHasFocus);
        }
    }
}

