/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.circuit.WidthIncompatibilityData;
import com.cburch.logisim.circuit.Wire;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.EndData;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Location;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

class CircuitPoints {
    private final HashMap<Location, LocationData> map = new HashMap();
    private final HashMap<Location, WidthIncompatibilityData> incompatibilityData = new HashMap();

    void add(Component comp) {
        if (comp instanceof Wire) {
            Wire w = (Wire)comp;
            this.addSub(w.getEnd0(), w, null);
            this.addSub(w.getEnd1(), w, null);
        } else {
            for (EndData endData : comp.getEnds()) {
                if (endData == null) continue;
                this.addSub(endData.getLocation(), comp, endData);
            }
        }
    }

    void add(Component comp, EndData endData) {
        if (endData != null) {
            this.addSub(endData.getLocation(), comp, endData);
        }
    }

    private void addSub(Location loc, Component comp, EndData endData) {
        LocationData locData = this.map.get(loc);
        if (locData == null) {
            locData = new LocationData();
            this.map.put(loc, locData);
        }
        locData.components.add(comp);
        locData.ends.add(endData);
        this.computeIncompatibilityData(loc, locData);
    }

    private void computeIncompatibilityData(Location loc, LocationData locData) {
        WidthIncompatibilityData error = null;
        if (locData != null) {
            BitWidth width = BitWidth.UNKNOWN;
            for (EndData endData : locData.ends) {
                if (endData == null) continue;
                BitWidth endWidth = endData.getWidth();
                if (width == BitWidth.UNKNOWN) {
                    width = endWidth;
                    continue;
                }
                if (width == endWidth || endWidth == BitWidth.UNKNOWN) continue;
                if (error == null) {
                    error = new WidthIncompatibilityData();
                    error.add(loc, width);
                }
                error.add(loc, endWidth);
            }
            locData.width = width;
        }
        if (error == null) {
            this.incompatibilityData.remove(loc);
        } else {
            this.incompatibilityData.put(loc, error);
        }
    }

    private Collection<? extends Component> find(Location loc, boolean isWire) {
        LocationData locData = this.map.get(loc);
        if (locData == null) {
            return Collections.emptySet();
        }
        ArrayList<Component> components = locData.components;
        int retSize = 0;
        Component retValue = null;
        for (Component comp : components) {
            if (comp instanceof Wire != isWire) continue;
            retValue = comp;
            ++retSize;
        }
        if (retSize == components.size()) {
            return components;
        }
        if (retSize == 0) {
            return Collections.emptySet();
        }
        if (retSize == 1) {
            return Collections.singleton(retValue);
        }
        Component[] ret = new Component[retSize];
        int retPos = 0;
        for (Component comp : components) {
            if (comp instanceof Wire != isWire) continue;
            ret[retPos] = comp;
            ++retPos;
        }
        return Arrays.asList(ret);
    }

    int getComponentCount(Location loc) {
        LocationData locData = this.map.get(loc);
        return locData == null ? 0 : locData.components.size();
    }

    Collection<? extends Component> getComponents(Location loc) {
        LocationData locData = this.map.get(loc);
        if (locData == null) {
            return Collections.emptySet();
        }
        return locData.components;
    }

    Component getExclusive(Location loc) {
        LocationData locData = this.map.get(loc);
        if (locData == null) {
            return null;
        }
        int i = -1;
        for (EndData endData : locData.ends) {
            ++i;
            if (endData == null || !endData.isExclusive()) continue;
            return locData.components.get(i);
        }
        return null;
    }

    Collection<? extends Component> getNonWires(Location loc) {
        return this.find(loc, false);
    }

    Collection<? extends Component> getSplitCauses(Location loc) {
        return this.getComponents(loc);
    }

    Set<Location> getAllLocations() {
        return this.map.keySet();
    }

    BitWidth getWidth(Location loc) {
        LocationData locData = this.map.get(loc);
        return locData == null ? BitWidth.UNKNOWN : locData.width;
    }

    Collection<WidthIncompatibilityData> getWidthIncompatibilityData() {
        return this.incompatibilityData.values();
    }

    Collection<Wire> getWires(Location loc) {
        Collection<? extends Component> ret = this.find(loc, true);
        return ret;
    }

    boolean hasConflict(Component comp) {
        if (!(comp instanceof Wire)) {
            for (EndData endData : comp.getEnds()) {
                if (endData == null || !endData.isExclusive() || this.getExclusive(endData.getLocation()) == null) continue;
                return true;
            }
        }
        return false;
    }

    void remove(Component comp) {
        if (comp instanceof Wire) {
            Wire wire = (Wire)comp;
            this.removeSub(wire.getEnd0(), wire);
            this.removeSub(wire.getEnd1(), wire);
        } else {
            for (EndData endData : comp.getEnds()) {
                if (endData == null) continue;
                this.removeSub(endData.getLocation(), comp);
            }
        }
    }

    void remove(Component comp, EndData endData) {
        if (endData != null) {
            this.removeSub(endData.getLocation(), comp);
        }
    }

    private void removeSub(Location loc, Component comp) {
        LocationData locData = this.map.get(loc);
        if (locData == null) {
            return;
        }
        int index = locData.components.indexOf(comp);
        if (index < 0) {
            return;
        }
        if (locData.components.size() == 1) {
            this.map.remove(loc);
            this.incompatibilityData.remove(loc);
        } else {
            locData.components.remove(index);
            locData.ends.remove(index);
            this.computeIncompatibilityData(loc, locData);
        }
    }

    private static class LocationData {
        BitWidth width = BitWidth.UNKNOWN;
        final ArrayList<Component> components = new ArrayList(4);
        final ArrayList<EndData> ends = new ArrayList(4);

        private LocationData() {
        }
    }
}

