/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.circuit.CircuitPoints;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.Propagator;
import com.cburch.logisim.circuit.Splitter;
import com.cburch.logisim.circuit.SplitterAttributes;
import com.cburch.logisim.circuit.WidthIncompatibilityData;
import com.cburch.logisim.circuit.Wire;
import com.cburch.logisim.circuit.WireBundle;
import com.cburch.logisim.circuit.WireSet;
import com.cburch.logisim.circuit.WireThread;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.comp.EndData;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeListener;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.wiring.Pin;
import com.cburch.logisim.std.wiring.PullResistor;
import com.cburch.logisim.std.wiring.Tunnel;
import com.cburch.logisim.util.CollectionUtil;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.IteratorUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircuitWires {
    private HashSet<Wire> wires = new HashSet();
    private HashSet<Splitter> splitters = new HashSet();
    private HashSet<Component> tunnels = new HashSet();
    private HashSet<Component> pulls = new HashSet();
    private HashSet<Component> components = new HashSet();
    static final Logger logger = LoggerFactory.getLogger(CircuitWires.class);
    final CircuitPoints points = new CircuitPoints();
    private Bounds bounds = Bounds.EMPTY_BOUNDS;
    private volatile Connectivity masterConnectivity = null;
    private TunnelListener tunnelListener = new TunnelListener();

    State newState(CircuitState circState) {
        return new State(this.getConnectivity(), circState.getWireData());
    }

    CircuitWires() {
    }

    boolean add(Component comp) {
        boolean added = true;
        if (comp instanceof Wire) {
            Wire wire = (Wire)comp;
            added = this.addWire(wire);
        } else if (comp instanceof Splitter) {
            Splitter splitter = (Splitter)comp;
            this.splitters.add(splitter);
        } else {
            ComponentFactory factory = comp.getFactory();
            if (factory instanceof Tunnel) {
                this.tunnels.add(comp);
                comp.getAttributeSet().addAttributeListener(this.tunnelListener);
            } else if (factory instanceof PullResistor) {
                this.pulls.add(comp);
                comp.getAttributeSet().addAttributeListener(this.tunnelListener);
            } else {
                this.components.add(comp);
            }
        }
        if (added) {
            this.points.add(comp);
            this.voidConnectivity();
        }
        return added;
    }

    void add(Component comp, EndData end) {
        this.points.add(comp, end);
        this.voidConnectivity();
    }

    private boolean addWire(Wire w) {
        boolean added = this.wires.add(w);
        if (!added) {
            return false;
        }
        if (this.bounds != Bounds.EMPTY_BOUNDS) {
            this.bounds = this.bounds.add(w.e0).add(w.e1);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeConnectivity(Connectivity ret) {
        Object width;
        ArrayList<EndData> ends;
        this.connectComponents(ret);
        this.connectWires(ret);
        this.connectTunnels(ret);
        this.connectPullResistors(ret);
        Iterator<Object> it = ret.getBundles().iterator();
        while (it.hasNext()) {
            WireBundle b = it.next();
            WireBundle bpar = b.find();
            if (bpar == b) continue;
            for (Location location : b.tempPoints) {
                ret.setBundleAt(location, bpar);
            }
            bpar.tempPoints.addAll(b.tempPoints);
            bpar.addPullValue(b.getPullValue());
            it.remove();
        }
        for (Splitter spl : this.splitters) {
            ends = new ArrayList<EndData>(spl.getEnds());
            for (EndData endData : ends) {
                Location p = endData.getLocation();
                WireBundle pb = ret.createBundleAt(p);
                pb.setWidth(endData.getWidth(), p);
            }
        }
        for (Location p : ret.getBundlePoints()) {
            WireBundle pb = ret.getBundleAt(p);
            BitWidth width2 = this.points.getWidth(p);
            if (width2 == BitWidth.UNKNOWN) continue;
            pb.setWidth(width2, p);
        }
        for (Splitter spl : this.splitters) {
            ends = new ArrayList<EndData>(spl.getEnds());
            int index = -1;
            for (EndData end : ends) {
                ++index;
                Location p = end.getLocation();
                WireBundle pb = ret.getBundleAt(p);
                if (pb == null) continue;
                pb.setWidth(end.getWidth(), p);
                spl.wireData.endBundle[index] = pb;
            }
        }
        for (WireBundle b : ret.getBundles()) {
            b.xpoints = b.tempPoints.toArray(new Location[b.tempPoints.size()]);
            b.tempPoints = null;
            width = b.getWidth();
            if (width == BitWidth.UNKNOWN) continue;
            int n = ((BitWidth)width).getWidth();
            b.threads = new WireThread[n];
            for (int i = 0; i < n; ++i) {
                b.threads[i] = new WireThread();
            }
        }
        for (Splitter spl : this.splitters) {
            width = spl;
            synchronized (width) {
                SplitterAttributes splAttrs = (SplitterAttributes)spl.getAttributeSet();
                byte[] byArray = splAttrs.bitEnd;
                SplitterData splData = spl.wireData;
                WireBundle fromBundle = splData.endBundle[0];
                if (fromBundle == null || !fromBundle.isValid()) {
                    continue;
                }
                for (int i = 0; i < byArray.length; ++i) {
                    byte j = byArray[i];
                    if (j <= 0) continue;
                    byte thr = spl.bitThread[i];
                    WireBundle toBundle = splData.endBundle[j];
                    WireThread[] toThreads = toBundle.threads;
                    if (toThreads == null || !toBundle.isValid()) continue;
                    WireThread[] fromThreads = fromBundle.threads;
                    if (i >= fromThreads.length) {
                        throw new ArrayIndexOutOfBoundsException("from " + i + " of " + fromThreads.length);
                    }
                    if (thr >= toThreads.length) {
                        throw new ArrayIndexOutOfBoundsException("to " + thr + " of " + toThreads.length);
                    }
                    fromThreads[i].unite(toThreads[thr]);
                }
            }
        }
        for (WireBundle wireBundle : ret.getBundles()) {
            if (wireBundle.threads == null) continue;
            for (int i = 0; i < wireBundle.threads.length; ++i) {
                WireThread thr;
                wireBundle.threads[i] = thr = wireBundle.threads[i].getRepresentative();
                thr.addBundlePosition(i, wireBundle);
            }
        }
        for (WireBundle b : ret.getBundles()) {
            if (b.threads == null) continue;
            for (WireThread t : b.threads) {
                t.finishConstructing();
            }
        }
        ret.allComponents.addAll(this.components);
        ret.allLocations.addAll(this.points.getAllLocations());
        for (Location p : ret.allLocations) {
            ArrayList<Component> a = null;
            for (Component component : this.points.getComponents(p)) {
                if (component instanceof Wire || component instanceof Splitter) continue;
                if (a == null) {
                    a = new ArrayList<Component>();
                }
                a.add(component);
            }
            if (a == null) continue;
            ret.componentsAtLocations.put(p, a);
        }
        Collection<WidthIncompatibilityData> exceptions = this.points.getWidthIncompatibilityData();
        if (CollectionUtil.isNotEmpty(exceptions)) {
            for (WidthIncompatibilityData wid : exceptions) {
                ret.addWidthIncompatibilityData(wid);
            }
        }
        for (WireBundle wireBundle : ret.getBundles()) {
            WidthIncompatibilityData e = wireBundle.getWidthIncompatibilityData();
            if (e == null) continue;
            ret.addWidthIncompatibilityData(e);
        }
    }

    private void connectPullResistors(Connectivity ret) {
        for (Component comp : this.pulls) {
            Location loc = comp.getEnd(0).getLocation();
            WireBundle b = ret.getBundleAt(loc);
            if (b == null) {
                b = ret.createBundleAt(loc);
                b.tempPoints.add(loc);
                ret.setBundleAt(loc, b);
            }
            Instance instance = Instance.getInstanceFor(comp);
            b.addPullValue(PullResistor.getPullValue(instance));
        }
    }

    private void connectTunnels(Connectivity ret) {
        HashMap<String, ArrayList> tunnelSets = new HashMap<String, ArrayList>();
        for (Component comp : this.tunnels) {
            String label = comp.getAttributeSet().getValue(StdAttr.LABEL).trim();
            if (label.equals("")) continue;
            ArrayList tunnelSet = tunnelSets.computeIfAbsent(label, k -> new ArrayList(3));
            tunnelSet.add(comp.getLocation());
        }
        for (ArrayList tunnelSet : tunnelSets.values()) {
            WireBundle bundle;
            WireBundle foundBundle = null;
            Location foundLocation = null;
            for (Location loc : tunnelSet) {
                bundle = ret.getBundleAt(loc);
                if (bundle == null) continue;
                foundBundle = bundle;
                foundLocation = loc;
                break;
            }
            if (foundBundle == null) {
                foundLocation = (Location)tunnelSet.get(0);
                foundBundle = ret.createBundleAt(foundLocation);
            }
            for (Location loc : tunnelSet) {
                if (loc == foundLocation) continue;
                bundle = ret.getBundleAt(loc);
                if (bundle == null) {
                    foundBundle.tempPoints.add(loc);
                    ret.setBundleAt(loc, foundBundle);
                    continue;
                }
                bundle.unite(foundBundle);
            }
        }
    }

    private void connectComponents(Connectivity ret) {
        for (Component comp : this.components) {
            for (EndData e : comp.getEnds()) {
                Location loc;
                WireBundle b;
                if (e.getType() == 1 || (b = ret.getBundleAt(loc = e.getLocation())) != null) continue;
                b = ret.createBundleAt(loc);
                b.tempPoints.add(loc);
                ret.setBundleAt(loc, b);
            }
        }
    }

    private void connectWires(Connectivity ret) {
        for (Wire wire : this.wires) {
            WireBundle bundleB;
            WireBundle bundleA = ret.getBundleAt(wire.e0);
            if (bundleA == null) {
                bundleB = ret.createBundleAt(wire.e1);
                bundleB.tempPoints.add(wire.e0);
                ret.setBundleAt(wire.e0, bundleB);
                continue;
            }
            bundleB = ret.getBundleAt(wire.e1);
            if (bundleB == null) {
                bundleA.tempPoints.add(wire.e1);
                ret.setBundleAt(wire.e1, bundleA);
                continue;
            }
            bundleB.unite(bundleA);
        }
    }

    static Value getBusValue(CircuitState state, Location loc) {
        State s = state.getWireData();
        if (s == null) {
            return Value.NIL;
        }
        ValuedBus vb = s.busAt.get(loc);
        if (vb == null) {
            return Value.NIL;
        }
        Value v = vb.busVal;
        if (v == null) {
            return Value.NIL;
        }
        return v;
    }

    void draw(ComponentDrawContext context, Collection<Component> hidden) {
        boolean showState = context.getShowState();
        CircuitState state = context.getCircuitState();
        Graphics2D g = (Graphics2D)context.getGraphics();
        g.setColor(Color.BLACK);
        GraphicsUtil.switchToWidth(g, 3);
        WireSet highlighted = context.getHighlightedWires();
        Connectivity cmap = this.getConnectivity();
        boolean isValid = cmap.isValid();
        if (CollectionUtil.isNullOrEmpty(hidden)) {
            for (Wire wire : this.wires) {
                Location s = wire.e0;
                Location t = wire.e1;
                WireBundle wireBundle = cmap.getBundleAt(s);
                int width = 5;
                if (!wireBundle.isValid()) {
                    g.setColor(Value.widthErrorColor);
                } else if (!showState) {
                    g.setColor(Color.BLACK);
                } else if (!isValid) {
                    g.setColor(Value.nilColor);
                } else {
                    g.setColor(CircuitWires.getBusValue(state, s).getColor());
                }
                if (highlighted.containsWire(wire)) {
                    width = wireBundle.isBus() ? 5 : 4;
                    GraphicsUtil.switchToWidth(g, width);
                    g.drawLine(s.getX(), s.getY(), t.getX(), t.getY());
                    Stroke oldStroke = g.getStroke();
                    g.setStroke(Wire.HIGHLIGHTED_STROKE);
                    g.setColor(Value.strokeColor);
                    g.drawLine(s.getX(), s.getY(), t.getX(), t.getY());
                    g.setStroke(oldStroke);
                } else {
                    width = wireBundle.isBus() ? 4 : 3;
                    GraphicsUtil.switchToWidth(g, width);
                    g.drawLine(s.getX(), s.getY(), t.getX(), t.getY());
                }
                if (!wire.isDrcHighlighted()) continue;
                width += 2;
                g.setColor(wire.getDrcHighlightColor());
                GraphicsUtil.switchToWidth(g, 2);
                if (wire.isVertical()) {
                    g.drawLine(s.getX() - width, s.getY(), t.getX() - width, t.getY());
                    g.drawLine(s.getX() + width, s.getY(), t.getX() + width, t.getY());
                    continue;
                }
                g.drawLine(s.getX(), s.getY() - width, t.getX(), t.getY() - width);
                g.drawLine(s.getX(), s.getY() + width, t.getX(), t.getY() + width);
            }
            for (Location loc : this.points.getAllLocations()) {
                WireBundle wb;
                if (this.points.getComponentCount(loc) <= 2 || (wb = cmap.getBundleAt(loc)) == null) continue;
                Color color = Color.BLACK;
                if (!wb.isValid()) {
                    color = Value.widthErrorColor;
                } else if (showState) {
                    color = !isValid ? Value.nilColor : state.getValue(loc).getColor();
                }
                g.setColor(color);
                int n = highlighted.containsLocation(loc) ? (wb.isBus() ? 6 : 5) : (wb.isBus() ? 5 : 4);
                n = (int)((double)n * 1.35);
                g.fillOval(loc.getX() - n, loc.getY() - n, n * 2, n * 2);
            }
        } else {
            for (Wire wire : this.wires) {
                if (hidden.contains(wire)) continue;
                Location s = wire.e0;
                Location t = wire.e1;
                WireBundle wireBundle = cmap.getBundleAt(s);
                if (!wireBundle.isValid()) {
                    g.setColor(Value.widthErrorColor);
                } else if (showState) {
                    g.setColor(!isValid ? Value.nilColor : CircuitWires.getBusValue(state, s).getColor());
                } else {
                    g.setColor(Color.BLACK);
                }
                if (highlighted.containsWire(wire)) {
                    GraphicsUtil.switchToWidth(g, 5);
                    g.drawLine(s.getX(), s.getY(), t.getX(), t.getY());
                    GraphicsUtil.switchToWidth(g, 3);
                    continue;
                }
                GraphicsUtil.switchToWidth(g, wireBundle.isBus() ? 4 : 3);
                g.drawLine(s.getX(), s.getY(), t.getX(), t.getY());
            }
            for (Location loc : this.points.getAllLocations()) {
                WireBundle wireBundle;
                if (this.points.getComponentCount(loc) <= 2) continue;
                int icount = 0;
                for (Component component : this.points.getComponents(loc)) {
                    if (hidden.contains(component)) continue;
                    ++icount;
                }
                if (icount <= 2 || (wireBundle = cmap.getBundleAt(loc)) == null) continue;
                if (!wireBundle.isValid()) {
                    g.setColor(Value.widthErrorColor);
                } else if (showState) {
                    g.setColor(!isValid ? Value.nilColor : CircuitWires.getBusValue(state, loc).getColor());
                } else {
                    g.setColor(Color.BLACK);
                }
                int n2 = highlighted.containsLocation(loc) ? (wireBundle.isBus() ? 5 : 4) : (wireBundle.isBus() ? 4 : 3);
                n2 = (int)((double)n2 * 1.35);
                g.fillOval(loc.getX() - n2, loc.getY() - n2, n2 * 2, n2 * 2);
            }
        }
    }

    private Connectivity getConnectivity() {
        Connectivity map = this.masterConnectivity;
        if (map != null) {
            return map;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            Connectivity ret = new Connectivity();
            try {
                this.computeConnectivity(ret);
                this.masterConnectivity = ret;
            }
            catch (Exception t) {
                ret.invalidate();
                logger.error(t.getLocalizedMessage());
            }
            return ret;
        }
        try {
            ConnectivityGetter awtThread = new ConnectivityGetter();
            SwingUtilities.invokeAndWait(awtThread);
            return awtThread.result;
        }
        catch (Exception t) {
            logger.error(t.getLocalizedMessage());
            Connectivity ret = new Connectivity();
            ret.invalidate();
            return ret;
        }
    }

    Iterator<? extends Component> getComponents() {
        return IteratorUtil.createJoinedIterator(this.splitters.iterator(), this.wires.iterator());
    }

    BitWidth getWidth(Location q) {
        BitWidth det = this.points.getWidth(q);
        if (det != BitWidth.UNKNOWN) {
            return det;
        }
        Connectivity cmap = this.getConnectivity();
        if (!cmap.isValid()) {
            return BitWidth.UNKNOWN;
        }
        WireBundle qb = cmap.getBundleAt(q);
        if (qb != null && qb.isValid()) {
            return qb.getWidth();
        }
        return BitWidth.UNKNOWN;
    }

    Set<WidthIncompatibilityData> getWidthIncompatibilityData() {
        return this.getConnectivity().getWidthIncompatibilityData();
    }

    Bounds getWireBounds() {
        Bounds bds = this.bounds;
        if (bds == Bounds.EMPTY_BOUNDS) {
            bds = this.recomputeBounds();
        }
        return bds;
    }

    WireBundle getWireBundle(Location query) {
        Connectivity cmap = this.getConnectivity();
        return cmap.getBundleAt(query);
    }

    Set<Wire> getWires() {
        return this.wires;
    }

    WireSet getWireSet(Wire start) {
        WireBundle wireBundle = this.getWireBundle(start.e0);
        if (wireBundle == null) {
            return WireSet.EMPTY;
        }
        HashSet<Wire> wires = new HashSet<Wire>();
        for (Location loc : wireBundle.xpoints) {
            wires.addAll(this.points.getWires(loc));
        }
        return new WireSet(wires);
    }

    void propagate(CircuitState circState, ArrayList<Propagator.SimulatorEvent> dirtyPoints) {
        ValuedBus vb;
        int i;
        Connectivity map = this.getConnectivity();
        ArrayList dirtyThreads = new ArrayList();
        State s = circState.getWireData();
        if (s == null || s.connectivity != map) {
            s = new State(map, s);
            circState.setWireData(s);
            circState.clearValuesByWire();
            circState.markComponentsDirty(map.allComponents);
        }
        int npoints = dirtyPoints.size();
        block0: for (int k = 0; k < npoints; ++k) {
            Propagator.SimulatorEvent ev = dirtyPoints.get(k);
            Location p = ev.loc;
            Component cause = ev.cause;
            Value val = ev.val;
            ValuedBus vb2 = s.busAt.get(p);
            if (vb2 == null || vb2.width <= 0) continue;
            for (BusConnection bc : vb2.connections) {
                Value old;
                if (!bc.location.equals(p) || !bc.component.equals(cause) || Value.equal(old = bc.drivenValue, val)) continue;
                bc.drivenValue = val;
                s.markDirty(vb2);
                for (ValuedBus dep : vb2.dependentBuses) {
                    s.markDirty(dep);
                }
                continue block0;
            }
        }
        if (s.numDirty <= 0) {
            return;
        }
        for (i = 0; i < s.numDirty; ++i) {
            vb = s.buses[i];
            vb.localDrivenValue = vb.width <= 0 ? Value.NIL : Value.combineLikeWidths(vb.width, vb.connections);
        }
        for (i = 0; i < s.numDirty; ++i) {
            Value old = vb.busVal;
            vb = s.buses[i];
            Value val = vb.recalculate();
            if (Value.equal(old, val)) continue;
            circState.setValueByWire(val, vb.locations, vb.connections);
        }
        s.numDirty = 0;
    }

    private Bounds recomputeBounds() {
        Iterator<Wire> it = this.wires.iterator();
        if (!it.hasNext()) {
            this.bounds = Bounds.EMPTY_BOUNDS;
            return Bounds.EMPTY_BOUNDS;
        }
        Wire w = it.next();
        int xmin = w.e0.getX();
        int ymin = w.e0.getY();
        int xmax = w.e1.getX();
        int ymax = w.e1.getY();
        while (it.hasNext()) {
            int y1;
            int y0;
            int x1;
            w = it.next();
            int x0 = w.e0.getX();
            if (x0 < xmin) {
                xmin = x0;
            }
            if ((x1 = w.e1.getX()) > xmax) {
                xmax = x1;
            }
            if ((y0 = w.e0.getY()) < ymin) {
                ymin = y0;
            }
            if ((y1 = w.e1.getY()) <= ymax) continue;
            ymax = y1;
        }
        this.bounds = Bounds.create(xmin, ymin, xmax - xmin + 1, ymax - ymin + 1);
        return this.bounds;
    }

    void remove(Component comp) {
        if (comp instanceof Wire) {
            Wire wire = (Wire)comp;
            this.removeWire(wire);
        } else if (comp instanceof Splitter) {
            this.splitters.remove(comp);
        } else {
            ComponentFactory factory = comp.getFactory();
            if (factory instanceof Tunnel) {
                this.tunnels.remove(comp);
                comp.getAttributeSet().removeAttributeListener(this.tunnelListener);
            } else if (factory instanceof PullResistor) {
                this.pulls.remove(comp);
                comp.getAttributeSet().removeAttributeListener(this.tunnelListener);
            } else {
                this.components.remove(comp);
            }
        }
        this.points.remove(comp);
        this.voidConnectivity();
    }

    void remove(Component comp, EndData end) {
        this.points.remove(comp, end);
        this.voidConnectivity();
    }

    private void removeWire(Wire w) {
        Bounds smaller;
        if (!this.wires.remove(w)) {
            return;
        }
        if (!(this.bounds == Bounds.EMPTY_BOUNDS || (smaller = this.bounds.expand(-2)).contains(w.e0) && smaller.contains(w.e1))) {
            this.bounds = Bounds.EMPTY_BOUNDS;
        }
    }

    void replace(Component comp, EndData oldEnd, EndData newEnd) {
        this.points.remove(comp, oldEnd);
        this.points.add(comp, newEnd);
        this.voidConnectivity();
    }

    private void voidConnectivity() {
        this.masterConnectivity = null;
    }

    static class State {
        private Connectivity connectivity;
        HashMap<Location, ValuedBus> busAt = new HashMap();
        ValuedBus[] buses;
        int numDirty;
        static final ValuedBus[] EMPTY_DEPENDENCIES = new ValuedBus[0];

        State(Connectivity cm, State prev) {
            this.connectivity = cm;
            HashMap<WireBundle, ValuedBus> allBuses = new HashMap<WireBundle, ValuedBus>();
            HashMap<ValuedBus, WireBundle> srcBuses = new HashMap<ValuedBus, WireBundle>();
            this.buses = new ValuedBus[this.connectivity.bundles.size()];
            int idx = 0;
            for (WireBundle wb : this.connectivity.bundles) {
                ValuedBus vb;
                this.buses[vb.idx] = vb = new ValuedBus(idx++, wb, this.connectivity);
                for (Location loc : wb.xpoints) {
                    ValuedBus old = this.busAt.put(loc, vb);
                    if (old == null) continue;
                    throw new IllegalStateException("oops, two wires occupy same location");
                }
                allBuses.put(wb, vb);
                srcBuses.put(vb, wb);
            }
            HashMap<WireThread, ValuedThread> allThreads = new HashMap<WireThread, ValuedThread>();
            for (ValuedBus vb : this.buses) {
                vb.makeThreads(((WireBundle)srcBuses.get((Object)vb)).threads, allBuses, allThreads);
            }
            if (prev != null) {
                for (ValuedBus vb : this.buses) {
                    for (BusConnection bc : vb.connections) {
                        if (bc.isSink) continue;
                        bc.drivenValue = prev.getDrivenValue(bc.component, bc.location);
                    }
                }
            }
            for (ValuedBus vb : this.buses) {
                if (vb.width <= 0) continue;
                if (vb.threads == null) {
                    vb.dependentBuses = EMPTY_DEPENDENCIES;
                    continue;
                }
                HashSet<ValuedBus> deps = new HashSet<ValuedBus>();
                for (ValuedThread t : vb.threads) {
                    for (ValuedBus dep : t.bus) {
                        if (dep == vb) continue;
                        deps.add(dep);
                    }
                }
                int size = deps.size();
                vb.dependentBuses = deps.toArray(new ValuedBus[size]);
            }
            this.numDirty = this.buses.length;
        }

        Value getDrivenValue(Component c, Location loc) {
            ValuedBus vb = this.busAt.get(loc);
            if (vb == null) {
                return null;
            }
            for (BusConnection bc : vb.connections) {
                if (!bc.component.equals(c) || !bc.location.equals(loc)) continue;
                return bc.drivenValue;
            }
            return null;
        }

        void markClean(ValuedBus vb) {
            if (!vb.dirty) {
                throw new IllegalStateException("can't clean element that is not dirty");
            }
            if (vb.idx > this.numDirty - 1) {
                throw new IllegalStateException("bad position for dirty element");
            }
            if (vb.idx < this.numDirty - 1) {
                ValuedBus other = this.buses[this.numDirty - 1];
                other.idx = vb.idx;
                this.buses[other.idx] = other;
                vb.idx = this.numDirty - 1;
                this.buses[vb.idx] = vb;
            }
            vb.dirty = false;
            --this.numDirty;
        }

        void markDirty(ValuedBus vb) {
            if (vb.dirty) {
                return;
            }
            if (vb.idx < this.numDirty) {
                throw new IllegalStateException("bad position for clean element");
            }
            vb.localDrivenValue = null;
            vb.busVal = null;
            if (vb.idx > this.numDirty) {
                ValuedBus other = this.buses[this.numDirty];
                other.idx = vb.idx;
                this.buses[other.idx] = other;
                vb.idx = this.numDirty;
                this.buses[vb.idx] = vb;
            }
            if (vb.threads != null) {
                for (ValuedThread vt : vb.threads) {
                    vt.threadVal = null;
                }
            }
            vb.dirty = true;
            ++this.numDirty;
        }
    }

    private static class Connectivity {
        HashSet<WireBundle> bundles = new HashSet();
        HashMap<Location, WireBundle> pointBundles = new HashMap();
        ArrayList<Location> allLocations = new ArrayList();
        ArrayList<Component> allComponents = new ArrayList();
        HashMap<Location, ArrayList<Component>> componentsAtLocations = new HashMap();
        volatile boolean isValid = true;
        HashSet<WidthIncompatibilityData> incompatibilityData = null;

        private Connectivity() {
        }

        void addWidthIncompatibilityData(WidthIncompatibilityData e) {
            if (this.incompatibilityData == null) {
                this.incompatibilityData = new HashSet();
            }
            this.incompatibilityData.add(e);
        }

        WireBundle createBundleAt(Location p) {
            WireBundle ret = this.pointBundles.get(p);
            if (ret == null) {
                ret = new WireBundle(p);
                this.pointBundles.put(p, ret);
                this.bundles.add(ret);
            }
            return ret;
        }

        void setBundleAt(Location p, WireBundle b) {
            this.pointBundles.put(p, b);
        }

        WireBundle getBundleAt(Location p) {
            return this.pointBundles.get(p);
        }

        Set<Location> getBundlePoints() {
            return this.pointBundles.keySet();
        }

        Set<WireBundle> getBundles() {
            return this.bundles;
        }

        HashSet<WidthIncompatibilityData> getWidthIncompatibilityData() {
            return this.incompatibilityData;
        }

        void invalidate() {
            this.isValid = false;
        }

        boolean isValid() {
            return this.isValid;
        }
    }

    private class TunnelListener
    implements AttributeListener {
        private TunnelListener() {
        }

        @Override
        public void attributeListChanged(AttributeEvent e) {
        }

        @Override
        public void attributeValueChanged(AttributeEvent e) {
            Attribute<?> attr = e.getAttribute();
            if (attr == StdAttr.LABEL || attr == PullResistor.ATTR_PULL_TYPE) {
                CircuitWires.this.voidConnectivity();
            }
        }
    }

    static class SplitterData {
        final WireBundle[] endBundle;

        SplitterData(int fanOut) {
            this.endBundle = new WireBundle[fanOut + 1];
        }
    }

    static class ValuedBus {
        int idx;
        int width;
        ValuedThread[] threads;
        BusConnection[] connections;
        Location[] locations;
        Value localDrivenValue;
        Value busVal;
        boolean dirty;
        ValuedBus[] dependentBuses;
        Value pullVal;

        ValuedBus(int i, WireBundle wb, Connectivity cmap) {
            this.idx = i;
            this.filterComponents(cmap, wb.xpoints);
            this.width = wb.threads == null ? -1 : wb.getWidth().getWidth();
            this.pullVal = wb.getPullValue();
            this.dirty = true;
        }

        void filterComponents(Connectivity cmap, Location[] xpoints) {
            ArrayList<Location> locs = new ArrayList<Location>();
            ArrayList<BusConnection> conns = new ArrayList<BusConnection>();
            for (Location point : xpoints) {
                ArrayList<Component> allComponents = cmap.componentsAtLocations.get(point);
                if (allComponents == null) continue;
                locs.add(point);
                for (Component comp : allComponents) {
                    conns.add(new BusConnection(comp, point));
                }
            }
            int size = locs.size();
            this.locations = size == xpoints.length ? xpoints : locs.toArray(new Location[size]);
            this.connections = conns.toArray(new BusConnection[conns.size()]);
        }

        void makeThreads(WireThread[] wbthreads, HashMap<WireBundle, ValuedBus> allBuses, HashMap<WireThread, ValuedThread> allThreads) {
            if (this.width <= 0) {
                return;
            }
            boolean degenerate = true;
            for (WireThread t : wbthreads) {
                if (t.steps <= 1) continue;
                degenerate = false;
                break;
            }
            if (degenerate) {
                return;
            }
            this.threads = new ValuedThread[this.width];
            for (int i = 0; i < this.width; ++i) {
                WireThread t = wbthreads[i];
                this.threads[i] = allThreads.get(t);
                if (this.threads[i] != null) continue;
                this.threads[i] = new ValuedThread(t, allBuses);
                allThreads.put(t, this.threads[i]);
            }
        }

        Value recalculate() {
            if (this.width <= 0) {
                this.busVal = Value.NIL;
                this.dirty = false;
                return this.busVal;
            }
            if (this.dependentBuses.length == 0) {
                this.busVal = this.localDrivenValue;
                if (this.pullVal != null) {
                    this.busVal = this.busVal.pullEachBitTowards(this.pullVal);
                }
                this.dirty = false;
                return this.busVal;
            }
            if (this.width == 1) {
                this.busVal = this.threads[0].threadValue();
                this.dirty = false;
                return this.busVal;
            }
            long error = 0L;
            long unknown = 0L;
            long value = 0L;
            for (int i = 0; i < this.width; ++i) {
                long mask = 1L << i;
                Value tv = this.threads[i].threadValue();
                if (tv == Value.TRUE) {
                    value |= mask;
                    continue;
                }
                if (tv == Value.FALSE) continue;
                if (tv == Value.UNKNOWN) {
                    unknown |= mask;
                    continue;
                }
                error |= mask;
            }
            this.busVal = Value.create_unsafe(this.width, error, unknown, value);
            this.dirty = false;
            return this.busVal;
        }
    }

    private class ConnectivityGetter
    implements Runnable {
        Connectivity result;

        private ConnectivityGetter() {
        }

        @Override
        public void run() {
            this.result = CircuitWires.this.getConnectivity();
        }
    }

    public static class BusConnection {
        public final Component component;
        public final Location location;
        public final boolean isSink;
        public final boolean isBidirectional;
        public Value drivenValue;

        BusConnection(Component comp, Location loc) {
            this.component = comp;
            this.location = loc;
            EndData e = comp.getEnd(loc);
            this.isSink = e.getType() == 1 || comp.getFactory() instanceof Pin;
            this.isBidirectional = e.getType() == 3;
            this.drivenValue = null;
        }

        public String toString() {
            return String.format("component %s at %s is %sdirectional %s val %s", this.component, this.location, this.isBidirectional ? "bi" : "uni", this.isSink ? "sink" : "source", this.drivenValue);
        }
    }

    static class ValuedThread {
        int steps;
        ValuedBus[] bus;
        int[] position;
        boolean pullUp;
        boolean pullDown;
        boolean pullError;
        Value threadVal;

        ValuedThread(WireThread t, HashMap<WireBundle, ValuedBus> allBuses) {
            this.steps = t.steps;
            this.position = t.position;
            this.bus = new ValuedBus[this.steps];
            for (int i = 0; i < this.steps; ++i) {
                WireBundle b = t.bundle[i];
                this.bus[i] = allBuses.get(b);
                Value pullHere = b.getPullValue();
                this.pullUp |= pullHere == Value.TRUE;
                this.pullDown |= pullHere == Value.FALSE;
                this.pullError |= pullHere == Value.ERROR;
            }
            if (this.pullUp && this.pullDown) {
                this.pullDown = false;
                this.pullUp = false;
                this.pullError = true;
            }
        }

        Value threadValue() {
            if (this.threadVal != null) {
                return this.threadVal;
            }
            this.threadVal = Value.UNKNOWN;
            for (int i = 0; i < this.steps; ++i) {
                ValuedBus vb = this.bus[i];
                int pos = this.position[i];
                Value v = vb.localDrivenValue;
                if (v == Value.NIL) continue;
                this.threadVal = this.threadVal.combine(v.get(pos));
            }
            if (this.threadVal == Value.UNKNOWN) {
                if (this.pullUp) {
                    this.threadVal = Value.TRUE;
                } else if (this.pullDown) {
                    this.threadVal = Value.FALSE;
                } else if (this.pullError) {
                    this.threadVal = Value.ERROR;
                }
            }
            return this.threadVal;
        }
    }
}

