/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.comp.Component;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplacementMap {
    static final Logger logger = LoggerFactory.getLogger(ReplacementMap.class);
    private boolean frozen;
    private final HashMap<Component, HashSet<Component>> map;
    private final HashMap<Component, HashSet<Component>> inverse;

    public ReplacementMap() {
        this(new HashMap<Component, HashSet<Component>>(), new HashMap<Component, HashSet<Component>>());
    }

    public ReplacementMap(Component oldComp, Component newComp) {
        this(new HashMap<Component, HashSet<Component>>(), new HashMap<Component, HashSet<Component>>());
        HashSet<Component> oldSet = new HashSet<Component>(3);
        oldSet.add(oldComp);
        HashSet<Component> newSet = new HashSet<Component>(3);
        newSet.add(newComp);
        this.map.put(oldComp, newSet);
        this.inverse.put(newComp, oldSet);
    }

    private ReplacementMap(HashMap<Component, HashSet<Component>> map, HashMap<Component, HashSet<Component>> inverse) {
        this.map = map;
        this.inverse = inverse;
    }

    public void add(Component comp) {
        if (this.frozen) {
            throw new IllegalStateException("cannot change map after frozen");
        }
        this.inverse.put(comp, new HashSet(3));
    }

    void append(ReplacementMap next) {
        for (Map.Entry<Component, HashSet<Component>> e : next.map.entrySet()) {
            Component b = e.getKey();
            HashSet<Component> cs = e.getValue();
            HashSet<Component> as = this.inverse.remove(b);
            if (as == null) {
                as = new HashSet(3);
                as.add(b);
            }
            for (Component a : as) {
                HashSet aDst = this.map.computeIfAbsent(a, k -> new HashSet(cs.size()));
                aDst.remove(b);
                aDst.addAll(cs);
            }
            for (Component c : cs) {
                HashSet<Component> cSrc = this.inverse.get(c);
                if (cSrc == null) {
                    cSrc = new HashSet(as.size());
                    this.inverse.put(c, cSrc);
                }
                cSrc.addAll(as);
            }
        }
        for (Map.Entry<Component, HashSet<Component>> e : next.inverse.entrySet()) {
            Component c = e.getKey();
            if (this.inverse.containsKey(c)) continue;
            HashSet<Component> bs = e.getValue();
            if (!bs.isEmpty()) {
                logger.error("Internal error: component replaced but not represented");
            }
            this.inverse.put(c, new HashSet(3));
        }
    }

    void freeze() {
        this.frozen = true;
    }

    public Collection<? extends Component> getAdditions() {
        return this.inverse.keySet();
    }

    public Collection<Component> getReplacementsFor(Component a) {
        return this.map.get(a);
    }

    public Collection<Component> getReplacedBy(Component b) {
        return this.inverse.get(b);
    }

    ReplacementMap getInverseMap() {
        return new ReplacementMap(this.inverse, this.map);
    }

    public Collection<? extends Component> getRemovals() {
        return this.map.keySet();
    }

    public boolean isEmpty() {
        return this.map.isEmpty() && this.inverse.isEmpty();
    }

    public void print(PrintStream out) {
        boolean found = false;
        for (Component component : this.getRemovals()) {
            if (!found) {
                out.println("  removals:");
            }
            found = true;
            out.println("    " + component.toString());
            for (Component b : this.map.get(component)) {
                out.println("     `--> " + b.toString());
            }
        }
        if (!found) {
            out.println("  removals: none");
        }
        found = false;
        for (Component component : this.getAdditions()) {
            if (!found) {
                out.println("  additions:");
            }
            found = true;
            out.println("    " + component.toString());
            for (Component a : this.inverse.get(component)) {
                out.println("     ^-- " + a.toString());
            }
        }
        if (!found) {
            out.println("  additions: none");
        }
    }

    public void put(Component a, Collection<? extends Component> bs) {
        if (this.frozen) {
            throw new IllegalStateException("cannot change map after frozen");
        }
        HashSet oldBs = this.map.computeIfAbsent(a, k -> new HashSet(bs.size()));
        oldBs.addAll(bs);
        for (Component component : bs) {
            HashSet oldAs = this.inverse.computeIfAbsent(component, k -> new HashSet(3));
            oldAs.add(a);
        }
    }

    public void remove(Component a) {
        if (this.frozen) {
            throw new IllegalStateException("cannot change map after frozen");
        }
        this.map.put(a, new HashSet(3));
    }

    public void replace(Component a, Component b) {
        this.put(a, Collections.singleton(b));
    }

    public void reset() {
        this.map.clear();
        this.inverse.clear();
    }

    public String toString() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (PrintStream p = new PrintStream((OutputStream)out, true, StandardCharsets.UTF_8);){
            this.print(p);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out.toString(StandardCharsets.UTF_8);
    }
}

