/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.comp;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.comp.AbstractComponent;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.comp.ComponentEvent;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.comp.ComponentListener;
import com.cburch.logisim.comp.EndData;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.util.EventSourceWeakSupport;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class ManagedComponent
extends AbstractComponent {
    private final EventSourceWeakSupport<ComponentListener> listeners = new EventSourceWeakSupport();
    private final Location loc;
    private AttributeSet attrs;
    private final ArrayList<EndData> ends;
    private final List<EndData> endsView;
    private Bounds bounds = null;

    public ManagedComponent(Location loc, AttributeSet attrs, int num_ends) {
        this.loc = loc;
        this.attrs = attrs;
        this.ends = new ArrayList(num_ends);
        this.endsView = Collections.unmodifiableList(this.ends);
    }

    @Override
    public void addComponentListener(ComponentListener l) {
        this.listeners.add(l);
    }

    public void clearManager() {
        for (EndData end : this.ends) {
            this.fireEndChanged(new ComponentEvent(this, end, null));
        }
        this.ends.clear();
        this.bounds = null;
    }

    @Override
    public void expose(ComponentDrawContext context) {
        Bounds bds = this.getBounds();
        Component dest = context.getDestination();
        if (bds != null) {
            dest.repaint(bds.getX() - 5, bds.getY() - 5, bds.getWidth() + 10, bds.getHeight() + 10);
        }
    }

    protected void fireComponentInvalidated(ComponentEvent e) {
        for (ComponentListener l : this.listeners) {
            l.componentInvalidated(e);
        }
    }

    protected void fireEndChanged(ComponentEvent e) {
        ComponentEvent copy = null;
        for (ComponentListener l : this.listeners) {
            if (copy == null) {
                copy = new ComponentEvent(e.getSource(), Collections.singletonList(e.getOldData()), Collections.singletonList(e.getData()));
            }
            l.endChanged(copy);
        }
    }

    protected void fireEndsChanged(List<EndData> oldEnds, List<EndData> newEnds) {
        ComponentEvent e = null;
        for (ComponentListener l : this.listeners) {
            if (e == null) {
                e = new ComponentEvent(this, oldEnds, newEnds);
            }
            l.endChanged(e);
        }
    }

    @Override
    public AttributeSet getAttributeSet() {
        return this.attrs;
    }

    @Override
    public Bounds getBounds() {
        if (this.bounds == null) {
            Location loc = this.getLocation();
            Bounds offBounds = this.getFactory().getOffsetBounds(this.getAttributeSet());
            this.bounds = offBounds.translate(loc.getX(), loc.getY());
        }
        return this.bounds;
    }

    public int getEndCount() {
        return this.ends.size();
    }

    public Location getEndLocation(int i) {
        return this.getEnd(i).getLocation();
    }

    @Override
    public List<EndData> getEnds() {
        return this.endsView;
    }

    @Override
    public abstract ComponentFactory getFactory();

    @Override
    public Object getFeature(Object key) {
        return null;
    }

    @Override
    public Location getLocation() {
        return this.loc;
    }

    @Override
    public abstract void propagate(CircuitState var1);

    protected void recomputeBounds() {
        this.bounds = null;
    }

    @Override
    public void removeComponentListener(ComponentListener l) {
        this.listeners.remove(l);
    }

    public void removeEnd(int index) {
        this.ends.remove(index);
    }

    public void setAttributeSet(AttributeSet value) {
        this.attrs = value;
    }

    public void setBounds(Bounds bounds) {
        this.bounds = bounds;
    }

    public void setEnd(int i, EndData data) {
        if (i == this.ends.size()) {
            this.ends.add(data);
            this.fireEndChanged(new ComponentEvent(this, null, data));
        } else {
            EndData old = this.ends.get(i);
            if (old == null || !old.equals(data)) {
                this.ends.set(i, data);
                this.fireEndChanged(new ComponentEvent(this, old, data));
            }
        }
    }

    public void setEnd(int i, Location end, BitWidth width, int type) {
        this.setEnd(i, new EndData(end, width, type));
    }

    public void setEnd(int i, Location end, BitWidth width, int type, boolean exclusive) {
        this.setEnd(i, new EndData(end, width, type, exclusive));
    }

    public void setEnds(EndData[] newEnds) {
        int i;
        ArrayList<EndData> oldEnds = this.ends;
        int minLen = Math.min(oldEnds.size(), newEnds.length);
        ArrayList<EndData> changesOld = new ArrayList<EndData>();
        ArrayList<EndData> changesNew = new ArrayList<EndData>();
        for (i = 0; i < minLen; ++i) {
            EndData old = oldEnds.get(i);
            if (newEnds[i] == null || newEnds[i].equals(old)) continue;
            changesOld.add(old);
            changesNew.add(newEnds[i]);
            oldEnds.set(i, newEnds[i]);
        }
        for (i = oldEnds.size() - 1; i >= minLen; --i) {
            changesOld.add(oldEnds.remove(i));
            changesNew.add(null);
        }
        for (i = minLen; i < newEnds.length; ++i) {
            oldEnds.add(newEnds[i]);
            changesOld.add(null);
            changesNew.add(newEnds[i]);
        }
        this.fireEndsChanged(changesOld, changesNew);
    }
}

