/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.data;

import com.cburch.logisim.data.AbstractAttributeSet;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class AttributeSets {
    public static final AttributeSet EMPTY = new AttributeSet(){

        @Override
        public Object clone() {
            return this;
        }

        @Override
        public boolean containsAttribute(Attribute<?> attr) {
            return false;
        }

        @Override
        public Attribute<?> getAttribute(String name) {
            return null;
        }

        @Override
        public List<Attribute<?>> getAttributes() {
            return Collections.emptyList();
        }

        @Override
        public <V> V getValue(Attribute<V> attr) {
            return null;
        }

        @Override
        public boolean isReadOnly(Attribute<?> attr) {
            return true;
        }

        @Override
        public boolean isToSave(Attribute<?> attr) {
            return attr.isToSave();
        }

        @Override
        public void setReadOnly(Attribute<?> attr, boolean value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <V> void setValue(Attribute<V> attr, V value) {
        }
    };

    private AttributeSets() {
    }

    public static void copy(AttributeSet src, AttributeSet dst) {
        if (src == null || src.getAttributes() == null) {
            return;
        }
        Iterator<Attribute<?>> iterator = src.getAttributes().iterator();
        while (iterator.hasNext()) {
            Attribute<?> attr;
            Attribute<?> attrObj = attr = iterator.next();
            Object value = src.getValue(attr);
            dst.setValue(attrObj, value);
        }
    }

    public static AttributeSet fixedSet(Attribute<?>[] attrs, Object[] initValues) {
        if (attrs.length > 1) {
            return new FixedSet(attrs, initValues);
        }
        if (attrs.length == 1) {
            return new SingletonSet(attrs[0], initValues[0]);
        }
        return EMPTY;
    }

    static class FixedSet
    extends AbstractAttributeSet {
        private List<Attribute<?>> attrs;
        private Object[] values;
        private int readOnly = 0;

        FixedSet(Attribute<?>[] attrs, Object[] initValues) {
            if (attrs.length != initValues.length) {
                throw new IllegalArgumentException("attribute and value arrays must have same length");
            }
            if (attrs.length > 32) {
                throw new IllegalArgumentException("cannot handle more than 32 attributes");
            }
            this.attrs = Arrays.asList(attrs);
            this.values = (Object[])initValues.clone();
        }

        @Override
        protected void copyInto(AbstractAttributeSet destSet) {
            FixedSet dest = (FixedSet)destSet;
            dest.attrs = this.attrs;
            dest.values = (Object[])this.values.clone();
            dest.readOnly = this.readOnly;
        }

        @Override
        public List<Attribute<?>> getAttributes() {
            return this.attrs;
        }

        @Override
        public <V> V getValue(Attribute<V> attr) {
            int index = this.attrs.indexOf(attr);
            if (index < 0) {
                return null;
            }
            Object ret = this.values[index];
            return (V)ret;
        }

        @Override
        public boolean isReadOnly(Attribute<?> attr) {
            int index = this.attrs.indexOf(attr);
            return index < 0 ? true : this.isReadOnly(index);
        }

        private boolean isReadOnly(int index) {
            return (this.readOnly >> index & 1) == 1;
        }

        @Override
        public void setReadOnly(Attribute<?> attr, boolean value) {
            int index = this.attrs.indexOf(attr);
            if (index < 0) {
                throw new IllegalArgumentException("attribute " + attr.getName() + " absent");
            }
            this.readOnly = value ? (this.readOnly |= 1 << index) : (this.readOnly &= ~(1 << index));
        }

        @Override
        public <V> void setValue(Attribute<V> attr, V value) {
            int index = this.attrs.indexOf(attr);
            if (index < 0) {
                throw new IllegalArgumentException("attribute " + attr.getName() + " absent");
            }
            if (this.isReadOnly(index)) {
                throw new IllegalArgumentException("read only");
            }
            Object oldvalue = this.values[index];
            this.values[index] = value;
            this.fireAttributeValueChanged(attr, value, oldvalue);
        }
    }

    private static class SingletonSet
    extends AbstractAttributeSet {
        private List<Attribute<?>> attrs = new ArrayList(1);
        private Object value;
        private boolean readOnly = false;

        SingletonSet(Attribute<?> attr, Object initValue) {
            this.attrs.add(attr);
            this.value = initValue;
        }

        @Override
        protected void copyInto(AbstractAttributeSet destSet) {
            SingletonSet dest = (SingletonSet)destSet;
            dest.attrs = this.attrs;
            dest.value = this.value;
            dest.readOnly = this.readOnly;
        }

        @Override
        public List<Attribute<?>> getAttributes() {
            return this.attrs;
        }

        @Override
        public <V> V getValue(Attribute<V> attr) {
            int index = this.attrs.indexOf(attr);
            Object ret = index >= 0 ? this.value : null;
            return (V)ret;
        }

        @Override
        public boolean isReadOnly(Attribute<?> attr) {
            return this.readOnly;
        }

        @Override
        public void setReadOnly(Attribute<?> attr, boolean value) {
            int index = this.attrs.indexOf(attr);
            if (index < 0) {
                throw new IllegalArgumentException("attribute " + attr.getName() + " absent");
            }
            this.readOnly = value;
        }

        @Override
        public <V> void setValue(Attribute<V> attr, V value) {
            int index = this.attrs.indexOf(attr);
            if (index < 0) {
                throw new IllegalArgumentException("attribute " + attr.getName() + " absent");
            }
            if (this.readOnly) {
                throw new IllegalArgumentException("read only");
            }
            Object oldvalue = this.value;
            this.value = value;
            this.fireAttributeValueChanged(attr, value, oldvalue);
        }
    }
}

