/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.file;

import com.cburch.logisim.data.AttributeDefaultProvider;
import com.cburch.logisim.data.AttributeSets;
import com.cburch.logisim.file.LoadedLibrary;
import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.tools.AddTool;
import com.cburch.logisim.tools.SelectTool;
import com.cburch.logisim.tools.Tool;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MouseMappings {
    private final List<MouseMappingsListener> listeners = new ArrayList<MouseMappingsListener>();
    private final HashMap<Integer, Tool> map = new HashMap();
    private int cacheMods;
    private Tool cacheTool;

    public void addMouseMappingsListener(MouseMappingsListener l) {
        this.listeners.add(l);
    }

    public boolean containsSelectTool() {
        for (Tool tool : this.map.values()) {
            if (!(tool instanceof SelectTool)) continue;
            return true;
        }
        return false;
    }

    public void copyFrom(MouseMappings other, LogisimFile file) {
        if (this == other) {
            return;
        }
        this.cacheMods = -1;
        this.map.clear();
        for (Integer mods : other.map.keySet()) {
            Tool srcTool = other.map.get(mods);
            Tool dstTool = file.findTool(srcTool);
            if (dstTool == null) continue;
            dstTool = dstTool.cloneTool();
            AttributeSets.copy(srcTool.getAttributeSet(), dstTool.getAttributeSet());
            this.map.put(mods, dstTool);
        }
        this.fireMouseMappingsChanged();
    }

    private void fireMouseMappingsChanged() {
        for (MouseMappingsListener l : this.listeners) {
            l.mouseMappingsChanged();
        }
    }

    public Set<Integer> getMappedModifiers() {
        return this.map.keySet();
    }

    public Map<Integer, Tool> getMappings() {
        return this.map;
    }

    public Tool getToolFor(int mods) {
        if (mods == this.cacheMods) {
            return this.cacheTool;
        }
        Tool ret = this.map.get(mods);
        this.cacheMods = mods;
        this.cacheTool = ret;
        return ret;
    }

    public Tool getToolFor(Integer mods) {
        if (mods == this.cacheMods) {
            return this.cacheTool;
        }
        Tool ret = this.map.get(mods);
        this.cacheMods = mods;
        this.cacheTool = ret;
        return ret;
    }

    public Tool getToolFor(MouseEvent e) {
        return this.getToolFor(e.getModifiersEx());
    }

    public void removeMouseMappingsListener(MouseMappingsListener l) {
        this.listeners.add(l);
    }

    void replaceAll(Map<Tool, Tool> toolMap) {
        boolean changed = false;
        for (Map.Entry<Integer, Tool> entry : this.map.entrySet()) {
            AttributeDefaultProvider attributeDefaultProvider;
            Integer key = entry.getKey();
            Tool tool = entry.getValue();
            if (tool instanceof AddTool) {
                AddTool addTool = (AddTool)tool;
                attributeDefaultProvider = addTool.getFactory();
            } else {
                attributeDefaultProvider = tool;
            }
            Tool searchFor = attributeDefaultProvider;
            changed |= this.replaceInMap(toolMap, tool, searchFor, key);
        }
        if (changed) {
            this.fireMouseMappingsChanged();
        }
    }

    private boolean replaceInMap(Map<Tool, Tool> toolMap, Tool tool, Object searchFor, Integer key) {
        boolean changed = false;
        if (toolMap.containsKey(searchFor)) {
            changed = true;
            Tool newTool = toolMap.get(searchFor);
            if (newTool == null) {
                this.map.remove(searchFor);
            } else {
                Tool clone = newTool.cloneTool();
                LoadedLibrary.copyAttributes(clone.getAttributeSet(), tool.getAttributeSet());
                this.map.put(key, clone);
            }
        }
        return changed;
    }

    public void setToolFor(int mods, Tool tool) {
        if (mods == this.cacheMods) {
            this.cacheMods = -1;
        }
        if (tool == null) {
            Tool old = this.map.remove(mods);
            if (old != null) {
                this.fireMouseMappingsChanged();
            }
        } else {
            Tool old = this.map.put(mods, tool);
            if (old != tool) {
                this.fireMouseMappingsChanged();
            }
        }
    }

    public void setToolFor(Integer mods, Tool tool) {
        if (mods == this.cacheMods) {
            this.cacheMods = -1;
        }
        if (tool == null) {
            Tool old = this.map.remove(mods);
            if (old != null) {
                this.fireMouseMappingsChanged();
            }
        } else {
            Tool old = this.map.put(mods, tool);
            if (old != tool) {
                this.fireMouseMappingsChanged();
            }
        }
    }

    public void setToolFor(MouseEvent e, Tool tool) {
        this.setToolFor(e.getModifiersEx(), tool);
    }

    public boolean usesToolFromSource(Tool query) {
        for (Tool tool : this.map.values()) {
            if (!tool.sharesSource(query)) continue;
            return true;
        }
        return false;
    }

    public static interface MouseMappingsListener {
        public void mouseMappingsChanged();
    }
}

