/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.file;

import com.cburch.logisim.data.AttributeListener;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.AttributeSets;
import com.cburch.logisim.file.LoadedLibrary;
import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.tools.Tool;
import com.cburch.logisim.util.EventSourceWeakSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class ToolbarData {
    private final EventSourceWeakSupport<ToolbarListener> listeners = new EventSourceWeakSupport();
    private final EventSourceWeakSupport<AttributeListener> toolListeners = new EventSourceWeakSupport();
    private final ArrayList<Tool> contents = new ArrayList();

    private void addAttributeListeners(Tool tool) {
        for (AttributeListener l : this.toolListeners) {
            AttributeSet attrs = tool.getAttributeSet();
            if (attrs == null) continue;
            attrs.addAttributeListener(l);
        }
    }

    public void addSeparator() {
        this.contents.add(null);
        this.fireToolbarChanged();
    }

    public void addSeparator(int pos) {
        this.contents.add(pos, null);
        this.fireToolbarChanged();
    }

    public void addTool(int pos, Tool tool) {
        this.contents.add(pos, tool);
        this.addAttributeListeners(tool);
        this.fireToolbarChanged();
    }

    public void addTool(Tool tool) {
        this.contents.add(tool);
        this.addAttributeListeners(tool);
        this.fireToolbarChanged();
    }

    public void addToolAttributeListener(AttributeListener l) {
        for (Tool tool : this.contents) {
            AttributeSet attrs;
            if (tool == null || (attrs = tool.getAttributeSet()) == null) continue;
            attrs.addAttributeListener(l);
        }
        this.toolListeners.add(l);
    }

    public void addToolbarListener(ToolbarListener l) {
        this.listeners.add(l);
    }

    public void copyFrom(ToolbarData other, LogisimFile file) {
        if (this == other) {
            return;
        }
        for (Tool tool : this.contents) {
            if (tool == null) continue;
            this.removeAttributeListeners(tool);
        }
        this.contents.clear();
        for (Tool srcTool : other.contents) {
            if (srcTool == null) {
                this.addSeparator();
                continue;
            }
            Tool toolCopy = file.findTool(srcTool);
            if (toolCopy == null) continue;
            Tool dstTool = toolCopy.cloneTool();
            AttributeSets.copy(srcTool.getAttributeSet(), dstTool.getAttributeSet());
            this.addTool(dstTool);
            this.addAttributeListeners(toolCopy);
        }
        this.fireToolbarChanged();
    }

    public void fireToolbarChanged() {
        for (ToolbarListener l : this.listeners) {
            l.toolbarChanged();
        }
    }

    public Object get(int index) {
        return this.contents.get(index);
    }

    public List<Tool> getContents() {
        return this.contents;
    }

    public Tool getFirstTool() {
        for (Tool tool : this.contents) {
            if (tool == null) continue;
            return tool;
        }
        return null;
    }

    public Object move(int from, int to) {
        Tool moved = this.contents.remove(from);
        this.contents.add(to, moved);
        this.fireToolbarChanged();
        return moved;
    }

    public Object remove(int pos) {
        Tool ret = this.contents.remove(pos);
        if (ret instanceof Tool) {
            Tool tool = ret;
            this.removeAttributeListeners(tool);
        }
        this.fireToolbarChanged();
        return ret;
    }

    private void removeAttributeListeners(Tool tool) {
        for (AttributeListener l : this.toolListeners) {
            AttributeSet attrs = tool.getAttributeSet();
            if (attrs == null) continue;
            attrs.removeAttributeListener(l);
        }
    }

    public void removeToolAttributeListener(AttributeListener l) {
        for (Tool tool : this.contents) {
            AttributeSet attrs;
            if (tool == null || (attrs = tool.getAttributeSet()) == null) continue;
            attrs.removeAttributeListener(l);
        }
        this.toolListeners.remove(l);
    }

    public void removeToolbarListener(ToolbarListener l) {
        this.listeners.remove(l);
    }

    void replaceAll(Map<Tool, Tool> toolMap) {
        boolean changed = false;
        ListIterator<Tool> it = this.contents.listIterator();
        while (it.hasNext()) {
            Tool old = it.next();
            if (!toolMap.containsKey(old)) continue;
            changed = true;
            this.removeAttributeListeners(old);
            Tool newTool = toolMap.get(old);
            if (newTool == null) {
                it.remove();
                continue;
            }
            Tool addedTool = newTool.cloneTool();
            this.addAttributeListeners(addedTool);
            LoadedLibrary.copyAttributes(addedTool.getAttributeSet(), old.getAttributeSet());
            it.set(addedTool);
        }
        if (changed) {
            this.fireToolbarChanged();
        }
    }

    public int size() {
        return this.contents.size();
    }

    boolean usesToolFromSource(Tool query) {
        for (Tool tool : this.contents) {
            if (tool == null || !tool.sharesSource(query)) continue;
            return true;
        }
        return false;
    }

    public static interface ToolbarListener {
        public void toolbarChanged();
    }
}

