/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.data;

import java.util.ArrayList;
import java.util.List;

public class ComponentMapInformationContainer {
    private int nrOfInputBubbles;
    private int nrOfInOutBubbles;
    private int nrOfOutputBubbles;
    private List<String> inputBubbleLabels;
    private List<String> inOutBubbleLabels;
    private List<String> outputBubbleLabels;

    public ComponentMapInformationContainer(int inports, int outports, int inoutports, List<String> inportLabels, List<String> outportLabels, List<String> inoutportLabels) {
        this.nrOfInputBubbles = inports;
        this.nrOfOutputBubbles = outports;
        this.nrOfInOutBubbles = inoutports;
        this.inputBubbleLabels = inportLabels;
        this.outputBubbleLabels = outportLabels;
        this.inOutBubbleLabels = inoutportLabels;
    }

    public ComponentMapInformationContainer(int inports, int outports, int inoutport) {
        this.nrOfInputBubbles = inports;
        this.nrOfOutputBubbles = outports;
        this.nrOfInOutBubbles = inoutport;
        this.inputBubbleLabels = null;
        this.outputBubbleLabels = null;
        this.inOutBubbleLabels = null;
    }

    public ComponentMapInformationContainer clone() {
        ComponentMapInformationContainer myClone = new ComponentMapInformationContainer(this.nrOfInputBubbles, this.nrOfOutputBubbles, this.nrOfInOutBubbles, this.inputBubbleLabels == null ? null : (List)((ArrayList)this.inputBubbleLabels).clone(), this.outputBubbleLabels == null ? null : (List)((ArrayList)this.outputBubbleLabels).clone(), this.inOutBubbleLabels == null ? null : (List)((ArrayList)this.inOutBubbleLabels).clone());
        return myClone;
    }

    public String getInOutportLabel(int inOutNr) {
        if (this.inOutBubbleLabels == null) {
            return Integer.toString(inOutNr);
        }
        if (this.inOutBubbleLabels.size() <= inOutNr) {
            return Integer.toString(inOutNr);
        }
        return this.inOutBubbleLabels.get(inOutNr);
    }

    public String getInPortLabel(int inputNr) {
        if (this.inputBubbleLabels == null) {
            return Integer.toString(inputNr);
        }
        if (this.inputBubbleLabels.size() <= inputNr) {
            return Integer.toString(inputNr);
        }
        return this.inputBubbleLabels.get(inputNr);
    }

    public int getNrOfInOutPorts() {
        return this.nrOfInOutBubbles;
    }

    public int getNrOfInPorts() {
        return this.nrOfInputBubbles;
    }

    public int getNrOfOutPorts() {
        return this.nrOfOutputBubbles;
    }

    public String getOutPortLabel(int outputNr) {
        if (this.outputBubbleLabels == null) {
            return Integer.toString(outputNr);
        }
        if (this.outputBubbleLabels.size() <= outputNr) {
            return Integer.toString(outputNr);
        }
        return this.outputBubbleLabels.get(outputNr);
    }

    public void setNrOfInOutports(int count, List<String> labels) {
        this.nrOfInOutBubbles = count;
        this.inOutBubbleLabels = labels;
    }

    public void setNrOfInports(int count, List<String> labels) {
        this.nrOfInputBubbles = count;
        this.inputBubbleLabels = labels;
    }

    public void setNrOfOutports(int count, List<String> labels) {
        this.nrOfOutputBubbles = count;
        this.outputBubbleLabels = labels;
    }
}

