/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.data;

import com.cburch.logisim.fpga.data.IoStandards;
import com.cburch.logisim.fpga.data.PullBehaviors;
import com.cburch.logisim.fpga.settings.VendorSoftware;
import com.cburch.logisim.util.StringUtil;
import java.util.Iterator;
import java.util.List;

public class FpgaClass {
    private long clockFrequency = 0L;
    private String clockPinLocation = null;
    private char clockPullBehavior = '\u0000';
    private char clockIOStandard = '\u0000';
    private String technology = null;
    private String part = null;
    private String Package = null;
    private String speedGrade = null;
    private char vendor = '\u0000';
    private char unusedPinsBehavior = '\u0000';
    private boolean fpgaDefined = false;
    private boolean usbTmcDownload = false;
    private int jtagPos = 1;
    private String flashName = null;
    private int flashPos = 2;
    private boolean flashDefined = false;

    public static char getId(String identifier) {
        char result = '\u0000';
        List<String> thelist = VendorSoftware.getVendorStrings();
        Iterator<String> iter = thelist.iterator();
        result = '\u0000';
        while (iter.hasNext()) {
            if (iter.next().equalsIgnoreCase(identifier)) {
                return result;
            }
            result = (char)(result + '\u0001');
        }
        return '\u00ff';
    }

    public void clear() {
        this.clockFrequency = 0L;
        this.clockPinLocation = null;
        this.clockPullBehavior = '\u0000';
        this.clockIOStandard = '\u0000';
        this.technology = null;
        this.part = null;
        this.Package = null;
        this.speedGrade = null;
        this.vendor = '\u0000';
        this.fpgaDefined = false;
        this.unusedPinsBehavior = '\u0000';
        this.usbTmcDownload = false;
        this.jtagPos = 1;
        this.flashName = null;
        this.flashPos = 2;
        this.flashDefined = false;
    }

    public boolean isFpgaInfoPresent() {
        return this.fpgaDefined;
    }

    public long getClockFrequency() {
        return this.clockFrequency;
    }

    public String getClockPinLocation() {
        return this.clockPinLocation;
    }

    public char getClockPull() {
        return this.clockPullBehavior;
    }

    public char getClockStandard() {
        return this.clockIOStandard;
    }

    public String getPackage() {
        return this.Package;
    }

    public String getPart() {
        return this.part;
    }

    public String getSpeedGrade() {
        return this.speedGrade;
    }

    public String getTechnology() {
        return this.technology;
    }

    public char getUnusedPinsBehavior() {
        return this.unusedPinsBehavior;
    }

    public char getVendor() {
        return this.vendor;
    }

    public int getFpgaJTAGChainPosition() {
        return this.jtagPos;
    }

    public void set(long frequency, String pin, String pull, String standard, String tech, String device, String box, String speed, String vend, String unused, boolean usbTmc, String jtagPPos, String flashName, String flashPos) {
        this.clockFrequency = frequency;
        this.clockPinLocation = pin;
        this.clockPullBehavior = PullBehaviors.getId(pull);
        this.clockIOStandard = IoStandards.getId(standard);
        this.technology = tech;
        this.part = device;
        this.Package = box;
        this.speedGrade = speed;
        this.vendor = FpgaClass.getId(vend);
        this.fpgaDefined = true;
        this.unusedPinsBehavior = PullBehaviors.getId(unused);
        this.usbTmcDownload = usbTmc;
        this.jtagPos = Integer.parseInt(jtagPPos);
        this.flashName = flashName;
        this.flashPos = Integer.parseInt(flashPos);
        this.flashDefined = StringUtil.isNotEmpty(flashName) && this.flashPos != 0;
    }

    public Boolean isUsbTmcDownloadRequired() {
        return this.usbTmcDownload;
    }

    public String getFlashName() {
        return this.flashName;
    }

    public int getFlashJTAGChainPosition() {
        return this.flashPos;
    }

    public boolean isFlashDefined() {
        return this.flashDefined;
    }
}

