/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.gui;

import com.cburch.logisim.fpga.designrulecheck.SimpleDrcContainer;
import com.cburch.logisim.fpga.gui.FpgaReportTabbedPane;
import javax.swing.JProgressBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reporter {
    public static final Reporter report = new Reporter();
    private static final Logger logger = LoggerFactory.getLogger(Reporter.class);
    private FpgaReportTabbedPane myCommander = null;
    private JProgressBar progress = null;

    public JProgressBar getProgressBar() {
        return this.progress;
    }

    public void setGuiLogger(FpgaReportTabbedPane gui) {
        this.myCommander = gui;
    }

    public void setProgressBar(JProgressBar progressBar) {
        this.progress = progressBar;
    }

    public void addErrorIncrement(String message) {
        if (this.myCommander == null) {
            logger.error(message);
        } else {
            this.myCommander.addErrors(new SimpleDrcContainer(message, 1, true));
        }
    }

    public void addError(Object message) {
        if (this.myCommander == null) {
            if (message instanceof String) {
                String msg = (String)message;
                logger.error(msg);
            }
        } else {
            this.myCommander.addErrors(message instanceof String ? new SimpleDrcContainer(message, 1) : message);
        }
    }

    public void addFatalErrorFmt(String fmt, Object ... args) {
        this.addFatalError(String.format(fmt, args));
    }

    public void addFatalError(String message) {
        if (this.myCommander == null) {
            logger.error(message);
        } else {
            this.myCommander.addErrors(new SimpleDrcContainer(message, 3));
        }
    }

    public void addSevereError(String message) {
        if (this.myCommander == null) {
            logger.error(message);
        } else {
            this.myCommander.addErrors(new SimpleDrcContainer(message, 2));
        }
    }

    public void addInfo(String message) {
        if (this.myCommander == null) {
            logger.info(message);
        } else {
            this.myCommander.addInfo(message);
        }
    }

    public void addSevereWarning(String message) {
        if (this.myCommander == null) {
            logger.warn(message);
        } else {
            this.myCommander.addWarning(new SimpleDrcContainer(message, 2));
        }
    }

    public void addWarningIncrement(String message) {
        if (this.myCommander == null) {
            logger.warn(message);
        } else {
            this.myCommander.addWarning(new SimpleDrcContainer(message, 1, true));
        }
    }

    public void addWarning(Object message) {
        if (this.myCommander == null) {
            if (message instanceof String) {
                String msg = (String)message;
                logger.warn(msg);
            }
        } else {
            this.myCommander.addWarning(message instanceof String ? new SimpleDrcContainer(message, 1) : message);
        }
    }

    public void clearConsole() {
        if (this.myCommander != null) {
            this.myCommander.clearConsole();
        }
    }

    public void print(String message) {
        if (this.myCommander == null) {
            logger.info(message);
        } else {
            this.myCommander.addConsole(message);
        }
    }
}

