/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.gui;

import com.cburch.logisim.prefs.AppPreferences;
import java.awt.Dimension;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;

public class ZoomSlider
extends JSlider {
    private int zoomMin;
    private int zoomMax;

    public int getMaxZoom() {
        return this.zoomMax;
    }

    public int getMinZoom() {
        return this.zoomMin;
    }

    public ZoomSlider(int orientation, int min, int max, int value) {
        this.setup(orientation, min, max, value);
    }

    public ZoomSlider() {
        this.setup(0, 100, 200, 100);
    }

    private void setup(int orientation, int min, int max, int value) {
        this.zoomMin = min;
        this.zoomMax = max;
        int midValue = min + (max - min >> 1);
        super.setOrientation(orientation);
        super.setMinimum(min);
        super.setMaximum(max);
        super.setValue(value);
        Dimension orig = super.getSize();
        orig.height = AppPreferences.getScaled(orig.height);
        orig.width = AppPreferences.getScaled(orig.width);
        super.setSize(orig);
        this.setMajorTickSpacing(50);
        this.setMinorTickSpacing(10);
        this.setPaintTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        JLabel label = new JLabel(this.getId(min));
        label.setFont(AppPreferences.getScaledFont(label.getFont()));
        labelTable.put(min, label);
        label = new JLabel(this.getId(midValue));
        label.setFont(AppPreferences.getScaledFont(label.getFont()));
        labelTable.put(midValue, label);
        label = new JLabel(this.getId(max));
        label.setFont(AppPreferences.getScaledFont(label.getFont()));
        labelTable.put(max, label);
        this.setLabelTable(labelTable);
        this.setPaintLabels(true);
    }

    private String getId(int value) {
        int hun = value / 100;
        int tens = value % 100 / 10;
        return String.format("%d.%dx", hun, tens);
    }
}

