/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.appear;

import com.cburch.draw.actions.ModelAddAction;
import com.cburch.draw.actions.ModelReorderAction;
import com.cburch.draw.canvas.ActionDispatcher;
import com.cburch.draw.canvas.Canvas;
import com.cburch.draw.canvas.CanvasTool;
import com.cburch.draw.model.CanvasModel;
import com.cburch.draw.model.CanvasModelEvent;
import com.cburch.draw.model.CanvasModelListener;
import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.model.ReorderRequest;
import com.cburch.draw.undo.UndoAction;
import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.appear.AppearanceElement;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.gui.appear.AppearanceEditPopup;
import com.cburch.logisim.gui.appear.AppearanceSelection;
import com.cburch.logisim.gui.appear.CanvasActionAdapter;
import com.cburch.logisim.gui.appear.LayoutPopupManager;
import com.cburch.logisim.gui.generic.CanvasPane;
import com.cburch.logisim.gui.generic.CanvasPaneContents;
import com.cburch.logisim.gui.generic.GridPainter;
import com.cburch.logisim.proj.Project;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;

public class AppearanceCanvas
extends Canvas
implements CanvasPaneContents,
ActionDispatcher {
    private static final long serialVersionUID = 1L;
    private static final int BOUNDS_BUFFER = 70;
    private static final int THRESH_SIZE_UPDATE = 10;
    private final CanvasTool selectTool;
    private final Listener listener;
    private final GridPainter grid;
    private Project proj;
    private CircuitState circuitState;
    private CanvasPane canvasPane;
    private Bounds oldPreferredSize;
    private LayoutPopupManager popupManager;

    public AppearanceCanvas(CanvasTool selectTool) {
        this.selectTool = selectTool;
        this.grid = new GridPainter(this);
        this.listener = new Listener();
        this.oldPreferredSize = null;
        this.setSelection(new AppearanceSelection());
        this.setTool(selectTool);
        CanvasModel model = super.getModel();
        if (model != null) {
            model.addCanvasModelListener(this.listener);
        }
        this.grid.addPropertyChangeListener("zoom", this.listener);
    }

    static int getMaxIndex(CanvasModel model) {
        List<CanvasObject> objects = model.getObjectsFromBottom();
        for (int i = objects.size() - 1; i >= 0; --i) {
            if (objects.get(i) instanceof AppearanceElement) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void center() {
    }

    private void computeSize(boolean immediate) {
        Bounds old;
        Dimension dim;
        this.hidePopup();
        CircuitState circState = this.circuitState;
        Bounds bounds = circState == null ? Bounds.create(0, 0, 50, 50) : circState.getCircuit().getAppearance().getAbsoluteBounds();
        int width = bounds.getX() + bounds.getWidth() + 70;
        int height = bounds.getY() + bounds.getHeight() + 70;
        Dimension dimension = dim = this.canvasPane == null ? new Dimension(width, height) : this.canvasPane.supportPreferredSize(width, height);
        if (!immediate && (old = this.oldPreferredSize) != null && Math.abs(old.getWidth() - dim.width) < 10 && Math.abs(old.getHeight() - dim.height) < 10) {
            return;
        }
        this.oldPreferredSize = Bounds.create(0, 0, dim.width, dim.height);
        this.setPreferredSize(dim);
        this.revalidate();
    }

    @Override
    public void doAction(UndoAction canvasAction) {
        int max;
        ModelAddAction addAction;
        int cur;
        Circuit circuit = this.circuitState.getCircuit();
        if (!this.proj.getLogisimFile().contains(circuit)) {
            return;
        }
        if (canvasAction instanceof ModelReorderAction) {
            ModelReorderAction reorder = (ModelReorderAction)canvasAction;
            int max2 = AppearanceCanvas.getMaxIndex(this.getModel());
            List<ReorderRequest> requests = reorder.getReorderRequests();
            ArrayList<ReorderRequest> mod = new ArrayList<ReorderRequest>(requests.size());
            boolean changed = false;
            boolean movedToMax = false;
            for (ReorderRequest singleRequest : requests) {
                CanvasObject obj = singleRequest.getObject();
                if (obj instanceof AppearanceElement) {
                    changed = true;
                    continue;
                }
                if (singleRequest.getToIndex() > max2) {
                    int from = singleRequest.getFromIndex();
                    changed = true;
                    movedToMax = true;
                    if (from == max2 && !movedToMax) continue;
                    mod.add(new ReorderRequest(obj, from, max2));
                    continue;
                }
                if (singleRequest.getToIndex() == max2) {
                    movedToMax = true;
                }
                mod.add(singleRequest);
            }
            if (changed) {
                if (mod.isEmpty()) {
                    return;
                }
                canvasAction = new ModelReorderAction(this.getModel(), mod);
            }
        }
        if (canvasAction instanceof ModelAddAction && (cur = (addAction = (ModelAddAction)canvasAction).getDestinationIndex()) > (max = AppearanceCanvas.getMaxIndex(this.getModel()))) {
            canvasAction = new ModelAddAction(this.getModel(), addAction.getObjects(), max + 1);
        }
        this.proj.doAction(new CanvasActionAdapter(circuit, canvasAction));
    }

    Circuit getCircuit() {
        return this.circuitState.getCircuit();
    }

    CircuitState getCircuitState() {
        return this.circuitState;
    }

    GridPainter getGridPainter() {
        return this.grid;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    Project getProject() {
        return this.proj;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.canvasPane.supportScrollableBlockIncrement(visibleRect, orientation, direction);
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.canvasPane.supportScrollableUnitIncrement(visibleRect, orientation, direction);
    }

    @Override
    public double getZoomFactor() {
        return this.grid.getZoomFactor();
    }

    private void hidePopup() {
        LayoutPopupManager man = this.popupManager;
        if (man != null) {
            man.hideCurrentPopup();
        }
    }

    @Override
    protected void paintBackground(Graphics g) {
        super.paintBackground(g);
        this.grid.paintGrid(g);
    }

    @Override
    protected void paintForeground(Graphics g) {
        double zoom = this.grid.getZoomFactor();
        Graphics gfxScaled = g.create();
        if (zoom != 1.0 && zoom != 0.0 && gfxScaled instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)gfxScaled;
            g2d.scale(zoom, zoom);
        }
        super.paintForeground(gfxScaled);
        gfxScaled.dispose();
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        this.repairEvent(e, this.grid.getZoomFactor());
        super.processMouseEvent(e);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        this.repairEvent(e, this.grid.getZoomFactor());
        super.processMouseMotionEvent(e);
    }

    @Override
    public void recomputeSize() {
        this.computeSize(true);
        this.repaint();
    }

    @Override
    public void repaintCanvasCoords(int x, int y, int width, int height) {
        double zoom = this.grid.getZoomFactor();
        if (zoom != 1.0) {
            x = (int)((double)x * zoom - 1.0);
            y = (int)((double)y * zoom - 1.0);
            width = (int)((double)width * zoom + 4.0);
            height = (int)((double)height * zoom + 4.0);
        }
        super.repaintCanvasCoords(x, y, width, height);
    }

    private void repairEvent(MouseEvent e, double zoom) {
        if (zoom != 1.0) {
            int oldx = e.getX();
            int oldy = e.getY();
            int newx = (int)Math.round((double)e.getX() / zoom);
            int newy = (int)Math.round((double)e.getY() / zoom);
            e.translatePoint(newx - oldx, newy - oldy);
        }
    }

    @Override
    public void setCanvasPane(CanvasPane value) {
        this.canvasPane = value;
        this.computeSize(true);
        this.popupManager = new LayoutPopupManager(value, this);
    }

    public void setCircuit(Project proj, CircuitState circuitState) {
        this.proj = proj;
        this.circuitState = circuitState;
        Circuit circuit = circuitState.getCircuit();
        this.setModel(circuit.getAppearance().getCustomAppearanceDrawing(), this);
    }

    @Override
    public void setModel(CanvasModel value, ActionDispatcher dispatcher) {
        CanvasModel oldModel = super.getModel();
        if (oldModel != null) {
            oldModel.removeCanvasModelListener(this.listener);
        }
        super.setModel(value, dispatcher);
        if (value != null) {
            value.addCanvasModelListener(this.listener);
        }
    }

    @Override
    public void setTool(CanvasTool value) {
        this.hidePopup();
        super.setTool(value);
    }

    @Override
    public JPopupMenu showPopupMenu(MouseEvent e, CanvasObject clicked) {
        double zoom = this.grid.getZoomFactor();
        int x = (int)Math.round((double)e.getX() * zoom);
        int y = (int)Math.round((double)e.getY() * zoom);
        if (clicked != null && this.getSelection().isSelected(clicked)) {
            AppearanceEditPopup popup = new AppearanceEditPopup(this);
            popup.show(this, x, y);
            return popup;
        }
        return null;
    }

    @Override
    public int snapX(int x) {
        return x < 0 ? -((-x + 5) / 10 * 10) : (x + 5) / 10 * 10;
    }

    @Override
    public int snapY(int y) {
        return y < 0 ? -((-y + 5) / 10 * 10) : (y + 5) / 10 * 10;
    }

    @Override
    public void toolGestureComplete(CanvasTool tool, CanvasObject created) {
        if (tool == this.getTool() && tool != this.selectTool) {
            this.setTool(this.selectTool);
            if (created != null) {
                this.getSelection().clearSelected();
                this.getSelection().setSelected(created, true);
            }
        }
    }

    private class Listener
    implements CanvasModelListener,
    PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void modelChanged(CanvasModelEvent event) {
            AppearanceCanvas.this.computeSize(false);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CanvasTool t;
            String prop = evt.getPropertyName();
            if (prop.equals("zoom") && (t = AppearanceCanvas.this.getTool()) != null) {
                t.zoomFactorChanged(AppearanceCanvas.this);
            }
        }
    }
}

