/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.generic;

import com.cburch.logisim.gui.generic.ZoomModel;
import com.cburch.logisim.prefs.AppPreferences;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.MemoryImageSource;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;

public class GridPainter
implements PropertyChangeListener {
    public static final String ZOOM_PROPERTY = "zoom";
    public static final String SHOW_GRID_PROPERTY = "showgrid";
    private final Component destination;
    private final PropertyChangeSupport support;
    private final int gridSize = 10;
    private Listener listener;
    private ZoomModel zoomModel;
    private boolean showGrid = true;
    private double zoomFactor = 1.0;
    private Image gridImage;
    private int gridImageWidth;

    public GridPainter(Component destination) {
        this.destination = destination;
        this.support = new PropertyChangeSupport(this);
        this.createGridImage(10, this.zoomFactor);
        AppPreferences.GRID_BG_COLOR.addPropertyChangeListener(this);
        AppPreferences.GRID_DOT_COLOR.addPropertyChangeListener(this);
        AppPreferences.GRID_ZOOMED_DOT_COLOR.addPropertyChangeListener(this);
    }

    public void addPropertyChangeListener(String prop, PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(prop, listener);
    }

    public boolean getShowGrid() {
        return this.showGrid;
    }

    public void setShowGrid(boolean value) {
        if (this.showGrid != value) {
            this.showGrid = value;
            this.support.firePropertyChange(SHOW_GRID_PROPERTY, !value, value);
        }
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(double value) {
        double oldValue = this.zoomFactor;
        if (oldValue != value) {
            this.zoomFactor = value;
            this.createGridImage(10, value);
            this.support.firePropertyChange(ZOOM_PROPERTY, oldValue, value);
        }
    }

    public ZoomModel getZoomModel() {
        return this.zoomModel;
    }

    public void setZoomModel(ZoomModel model) {
        ZoomModel old = this.zoomModel;
        if (model != old) {
            if (this.listener == null) {
                this.listener = new Listener();
            }
            if (old != null) {
                old.removePropertyChangeListener(ZOOM_PROPERTY, this.listener);
                old.removePropertyChangeListener("grid", this.listener);
            }
            this.zoomModel = model;
            if (model != null) {
                model.addPropertyChangeListener(ZOOM_PROPERTY, this.listener);
                model.addPropertyChangeListener("grid", this.listener);
            }
            this.setShowGrid(model.getShowGrid());
            this.setZoomFactor(model.getZoomFactor());
            this.destination.repaint();
        }
    }

    public void paintGrid(Graphics g) {
        if (!this.showGrid) {
            return;
        }
        Rectangle clip = g.getClipBounds();
        int x0 = clip.x / this.gridImageWidth * this.gridImageWidth;
        int y0 = clip.y / this.gridImageWidth * this.gridImageWidth;
        for (int x = 0; x < clip.width + this.gridImageWidth; x += this.gridImageWidth) {
            for (int y = 0; y < clip.height + this.gridImageWidth; y += this.gridImageWidth) {
                g.drawImage(this.gridImage, x0 + x, y0 + y, this.destination);
            }
        }
    }

    public void removePropertyChangeListener(String prop, PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(prop, listener);
    }

    private void createGridImage(int size, double f) {
        double ww = f * (double)size * 5.0;
        while (2.0 * ww < 150.0) {
            ww *= 2.0;
        }
        int w = (int)Math.round(ww);
        int[] pix = new int[w * w];
        Arrays.fill(pix, AppPreferences.GRID_BG_COLOR.get());
        if (f == 1.0) {
            int lineStep = size * w;
            for (int j = 0; j < pix.length; j += lineStep) {
                for (int i = 0; i < w; i += size) {
                    pix[i + j] = AppPreferences.GRID_DOT_COLOR.get();
                }
            }
        } else {
            int y;
            int off0 = 0;
            int off1 = 1;
            if (f >= 2.0) {
                int num = (int)(f + 0.001);
                off0 = -(num / 2);
                off1 = off0 + num;
            }
            Integer dotColor = f <= 0.5 ? AppPreferences.GRID_ZOOMED_DOT_COLOR.get() : AppPreferences.GRID_DOT_COLOR.get();
            int j = 0;
            while ((y = (int)Math.round(f * (double)j)) + off0 < w) {
                for (int yo = y + off0; yo < y + off1; ++yo) {
                    int x;
                    if (yo < 0 || yo >= w) continue;
                    int base = yo * w;
                    int i = 0;
                    while ((x = (int)Math.round(f * (double)i)) + off0 < w) {
                        for (int xo = x + off0; xo < x + off1; ++xo) {
                            if (xo < 0 || xo >= w) continue;
                            pix[base + xo] = dotColor;
                        }
                        i += size;
                    }
                }
                j += size;
            }
            if (f <= 0.5) {
                int y2;
                int size5 = size * 5;
                int j2 = 0;
                while ((y2 = (int)Math.round(f * (double)j2)) < w) {
                    int x;
                    y2 *= w;
                    int i = 0;
                    while ((x = (int)Math.round(f * (double)i)) < w) {
                        pix[y2 + x] = AppPreferences.GRID_DOT_COLOR.get();
                        i += size5;
                    }
                    j2 += size5;
                }
            }
        }
        this.gridImage = this.destination.createImage(new MemoryImageSource(w, w, pix, 0, w));
        this.gridImageWidth = w;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (AppPreferences.GRID_BG_COLOR.isSource(event) || AppPreferences.GRID_DOT_COLOR.isSource(event) || AppPreferences.GRID_ZOOMED_DOT_COLOR.isSource(event)) {
            this.createGridImage(10, this.zoomFactor);
        }
    }

    private class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            String prop = event.getPropertyName();
            Object val = event.getNewValue();
            if (prop.equals(GridPainter.ZOOM_PROPERTY)) {
                GridPainter.this.setZoomFactor((Double)val);
                GridPainter.this.destination.repaint();
            } else if (prop.equals("grid")) {
                GridPainter.this.setShowGrid((Boolean)val);
                GridPainter.this.destination.repaint();
            }
        }
    }
}

