/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.generic;

import com.cburch.contracts.BaseMouseListenerContract;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.generic.CanvasPane;
import com.cburch.logisim.gui.generic.ZoomModel;
import com.cburch.logisim.gui.icons.ZoomIcon;
import com.cburch.logisim.gui.main.Canvas;
import com.cburch.logisim.prefs.AppPreferences;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;

public class ZoomControl
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final ZoomLabel label;
    private final JSlider slider;
    private final GridIcon grid;
    private final Canvas canvas;
    private final JButton plus;
    private final JButton minus;
    public final AutoZoomButton zoomButton;
    public final JPanel zoomContainer;
    public final PredefinedZoomButton predefinedZoom1;
    public final PredefinedZoomButton predefinedZoom2;
    public final PredefinedZoomButton predefinedZoom3;
    private ZoomModel model;
    private SliderModel sliderModel;

    public ZoomControl(ZoomModel model, Canvas canvas) {
        super(new BorderLayout());
        this.model = model;
        this.canvas = canvas;
        this.label = new ZoomLabel();
        this.sliderModel = new SliderModel(model);
        this.plus = new ZoomButton(new ZoomIcon(0), false);
        this.minus = new ZoomButton(new ZoomIcon(1), true);
        this.slider = new JSlider(this.sliderModel);
        JPanel zoom = new JPanel(new BorderLayout());
        zoom.add((Component)this.minus, "West");
        zoom.add((Component)this.label, "Center");
        zoom.add((Component)this.plus, "East");
        zoom.add((Component)this.slider, "South");
        this.add((Component)zoom, "North");
        this.grid = new GridIcon();
        this.add((Component)this.grid, "East");
        this.grid.update();
        this.zoomButton = new AutoZoomButton(model);
        this.add((Component)this.zoomButton, "West");
        this.zoomContainer = new JPanel(new GridLayout());
        this.predefinedZoom1 = new PredefinedZoomButton(model, "\u00d7\u00bd", 0.5);
        this.zoomContainer.add(this.predefinedZoom1);
        this.predefinedZoom2 = new PredefinedZoomButton(model, "\u00d71", 1.0);
        this.zoomContainer.add(this.predefinedZoom2);
        this.predefinedZoom3 = new PredefinedZoomButton(model, "\u00d72", 2.0);
        this.zoomContainer.add(this.predefinedZoom3);
        this.add((Component)this.zoomContainer, "Center");
        model.addPropertyChangeListener("grid", this.grid);
        model.addPropertyChangeListener("zoom", this.sliderModel);
        model.addPropertyChangeListener("zoom", this.label);
    }

    private int nearestZoomOption() {
        List<Double> choices = this.model.getZoomOptions();
        double factor = this.model.getZoomFactor() * 100.0;
        int closest = 0;
        for (int i = 1; i < choices.size(); ++i) {
            if (!(Math.abs(choices.get(i) - factor) < Math.abs(choices.get(closest) - factor))) continue;
            closest = i;
        }
        return closest;
    }

    public String zoomString() {
        DecimalFormat df = new DecimalFormat("###.##");
        return "\u00d7" + df.format(this.model.getZoomFactor());
    }

    public void zoomIn() {
        double zoom = this.model.getZoomFactor();
        List<Double> choices = this.model.getZoomOptions();
        double factor = zoom * 100.0 * 1.001;
        for (Double choice : choices) {
            if (!(choice > factor)) continue;
            this.model.setZoomFactor(choice / 100.0);
            break;
        }
    }

    public void zoomOut() {
        double zoom = this.model.getZoomFactor();
        List<Double> choices = this.model.getZoomOptions();
        double factor = zoom * 100.0 * 0.999;
        for (int i = choices.size() - 1; i >= 0; --i) {
            if (!(choices.get(i) < factor)) continue;
            this.model.setZoomFactor(choices.get(i) / 100.0);
            break;
        }
    }

    public void zoomTo(int i) {
        List<Double> choices = this.model.getZoomOptions();
        i = Math.max(Math.min(i, choices.size() - 1), 0);
        this.model.setZoomFactor(choices.get(i) / 100.0);
    }

    public void setAutoZoomButtonEnabled(boolean val) {
        this.zoomButton.setEnabled(val);
        this.predefinedZoom1.setEnabled(val);
    }

    public void setZoomModel(ZoomModel value) {
        ZoomModel oldModel = this.model;
        if (oldModel != value) {
            if (oldModel != null) {
                oldModel.removePropertyChangeListener("grid", this.grid);
                oldModel.removePropertyChangeListener("zoom", this.sliderModel);
                oldModel.removePropertyChangeListener("zoom", this.label);
            }
            this.model = value;
            if (value == null) {
                this.slider.setEnabled(false);
                this.zoomButton.setEnabled(false);
                this.predefinedZoom1.setEnabled(false);
                this.predefinedZoom2.setEnabled(false);
                this.predefinedZoom3.setEnabled(false);
                this.label.setEnabled(false);
                this.plus.setEnabled(false);
                this.minus.setEnabled(false);
            } else {
                this.slider.setEnabled(true);
                this.zoomButton.setEnabled(true);
                this.predefinedZoom1.setEnabled(true);
                this.predefinedZoom2.setEnabled(true);
                this.predefinedZoom3.setEnabled(true);
                this.label.setEnabled(true);
                this.plus.setEnabled(true);
                this.minus.setEnabled(true);
                this.sliderModel = new SliderModel(this.model);
                this.slider.setModel(this.sliderModel);
                this.grid.update();
                this.zoomButton.setZoomModel(value);
                this.predefinedZoom1.setZoomModel(value);
                this.predefinedZoom2.setZoomModel(value);
                this.predefinedZoom3.setZoomModel(value);
                value.addPropertyChangeListener("grid", this.grid);
                value.addPropertyChangeListener("zoom", this.sliderModel);
                value.addPropertyChangeListener("zoom", this.label);
                this.label.setText(this.zoomString());
            }
        }
    }

    private class ZoomLabel
    extends JLabel
    implements PropertyChangeListener {
        private static final long serialVersionUID = 1L;

        public ZoomLabel() {
            super(ZoomControl.this.zoomString(), 0);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.update();
        }

        public void update() {
            this.setText(ZoomControl.this.zoomString());
        }
    }

    private class SliderModel
    extends DefaultBoundedRangeModel
    implements PropertyChangeListener {
        private static final long serialVersionUID = 1L;

        public SliderModel(ZoomModel model) {
            super(ZoomControl.this.nearestZoomOption(), 0, 0, model.getZoomOptions().size() - 1);
        }

        @Override
        public int getValue() {
            return ZoomControl.this.nearestZoomOption();
        }

        @Override
        public void setValue(int i) {
            ZoomControl.this.zoomTo(i);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.fireStateChanged();
        }
    }

    private class ZoomButton
    extends JButton {
        private static final long serialVersionUID = 1L;
        final boolean out;

        public ZoomButton(Icon icon, boolean left) {
            super(icon);
            this.out = left;
            this.setOpaque(false);
            this.setBackground(new Color(0, 0, 0, 0));
            this.setBorderPainted(false);
            if (left) {
                this.setMargin(new Insets(2, 1, 2, 0));
            } else {
                this.setMargin(new Insets(2, 0, 2, 1));
            }
            this.addMouseListener(new ZoomMouseListener());
            this.addActionListener(new ZoomActionListener());
            this.setFocusable(false);
        }

        protected class ZoomMouseListener
        extends MouseAdapter {
            protected ZoomMouseListener() {
            }

            @Override
            public void mouseEntered(MouseEvent ev) {
                ZoomButton.this.setBorderPainted(true);
            }

            @Override
            public void mouseExited(MouseEvent ev) {
                ZoomButton.this.setBorderPainted(false);
            }
        }

        protected class ZoomActionListener
        implements ActionListener {
            protected ZoomActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ZoomButton.this.out) {
                    ZoomControl.this.zoomOut();
                } else {
                    ZoomControl.this.zoomIn();
                }
            }
        }
    }

    private class GridIcon
    extends JComponent
    implements BaseMouseListenerContract,
    PropertyChangeListener {
        private static final long serialVersionUID = 1L;
        boolean state = true;

        public GridIcon() {
            this.addMouseListener(this);
            this.setPreferredSize(new Dimension(AppPreferences.getScaled(32), AppPreferences.getScaled(16)));
            this.setToolTipText("");
            this.setFocusable(true);
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            return Strings.S.get("zoomShowGrid");
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (ZoomControl.this.model != null) {
                ZoomControl.this.model.setShowGrid(!this.state);
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (AppPreferences.AntiAliassing.getBoolean()) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            int width = this.getWidth();
            int height = this.getHeight();
            g.setColor(this.state ? this.getBackground() : Color.BLACK);
            int three = AppPreferences.getScaled(3);
            int xdim = (width - AppPreferences.getScaled(4)) / three * three + 1;
            int ydim = (height - AppPreferences.getScaled(4)) / three * three + 1;
            int xoff = (width - xdim) / 2;
            int yoff = (height - ydim) / 2;
            for (int x = 0; x < xdim; x += three) {
                for (int y = 0; y < ydim; y += three) {
                    g.drawLine(x + xoff, y + yoff, x + xoff, y + yoff);
                }
            }
            g.setColor(Color.BLACK);
            g.drawLine(xoff, yoff, xoff + three, yoff);
            g.drawLine(xoff, yoff, xoff, yoff + three);
            g.drawLine(xoff, yoff + ydim, xoff, yoff + ydim - three);
            g.drawLine(xoff, yoff + ydim, xoff + three, yoff + ydim);
            g.drawLine(xoff + xdim, yoff, xoff + xdim - three, yoff);
            g.drawLine(xoff + xdim, yoff, xoff + xdim, yoff + three);
            g.drawLine(xoff + xdim, yoff + ydim, xoff + xdim - three, yoff + ydim);
            g.drawLine(xoff + xdim, yoff + ydim, xoff + xdim, yoff + ydim - three);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.update();
        }

        private void update() {
            boolean grid = ZoomControl.this.model.getShowGrid();
            if (grid != this.state) {
                this.state = grid;
                this.repaint();
            }
        }
    }

    public class AutoZoomButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private ZoomModel zoomModel;

        public AutoZoomButton(ZoomModel model) {
            this.zoomModel = model;
            super.setText(Strings.S.get("zoomAuto"));
            this.addActionListener(this);
        }

        public void setZoomModel(ZoomModel model) {
            this.zoomModel = model;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.zoomModel != null) {
                Bounds bounds;
                Graphics g = this.getGraphics();
                if (ZoomControl.this.canvas.getProject().getCurrentCircuit() == null) {
                    return;
                }
                Bounds bounds2 = bounds = g != null ? ZoomControl.this.canvas.getProject().getCurrentCircuit().getBounds(this.getGraphics()) : ZoomControl.this.canvas.getProject().getCurrentCircuit().getBounds();
                if (bounds.getHeight() == 0 || bounds.getWidth() == 0) {
                    return;
                }
                CanvasPane canvasPane = ZoomControl.this.canvas.getCanvasPane();
                if (canvasPane == null) {
                    return;
                }
                int padding = 50;
                double zoomFactor = this.zoomModel.getZoomFactor();
                double height = (double)(bounds.getHeight() + 100) * zoomFactor;
                double width = (double)(bounds.getWidth() + 100) * zoomFactor;
                double autozoom = zoomFactor;
                autozoom *= Math.min(canvasPane.getViewport().getSize().getWidth() / width, canvasPane.getViewport().getSize().getHeight() / height);
                double max = this.zoomModel.getZoomOptions().get(this.zoomModel.getZoomOptions().size() - 1) / 100.0;
                double min = this.zoomModel.getZoomOptions().get(0) / 100.0;
                if (autozoom > max) {
                    autozoom = max;
                }
                if (autozoom < min) {
                    autozoom = min;
                }
                if (Math.abs(autozoom - zoomFactor) >= 0.01) {
                    this.zoomModel.setZoomFactorCenter(autozoom);
                }
            }
        }
    }

    public class PredefinedZoomButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private ZoomModel zoomModel;
        final double zoomValue;

        public PredefinedZoomButton(ZoomModel model, String label, double zoomValue) {
            this.zoomModel = model;
            this.zoomValue = zoomValue;
            super.setText(label);
            this.addActionListener(this);
        }

        public void setZoomModel(ZoomModel model) {
            this.zoomModel = model;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.zoomModel != null && ZoomControl.this.canvas.getProject().getCurrentCircuit() != null) {
                this.zoomModel.setZoomFactor(this.zoomValue);
            }
        }
    }
}

