/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.hex;

import com.cburch.hex.Caret;
import com.cburch.hex.HexEditor;
import com.cburch.hex.HexModel;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.gui.hex.HexFile;
import com.cburch.logisim.std.memory.MemContents;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

class Clip
implements ClipboardOwner {
    private static final DataFlavor binaryFlavor = new DataFlavor(long[].class, "Binary data");
    private final HexEditor editor;

    Clip(HexEditor editor) {
        this.editor = editor;
    }

    public boolean canPaste() {
        Clipboard clip = this.editor.getToolkit().getSystemClipboard();
        Transferable xfer = clip.getContents(this);
        return xfer.isDataFlavorSupported(binaryFlavor);
    }

    public void copy() {
        Caret caret = this.editor.getCaret();
        long p0 = caret.getMark();
        long p1 = caret.getDot();
        if (p0 < 0L || p1 < 0L) {
            return;
        }
        if (p0 > p1) {
            long t = p0;
            p0 = p1;
            p1 = t;
        }
        long[] data = new long[(int)(++p1 - p0)];
        HexModel model = this.editor.getModel();
        for (long i = p0; i < p1; ++i) {
            data[(int)(i - p0)] = model.get(i);
        }
        Clipboard clip = this.editor.getToolkit().getSystemClipboard();
        clip.setContents(new Data(data), this);
    }

    @Override
    public void lostOwnership(Clipboard clip, Transferable transfer) {
    }

    public void paste() {
        Clipboard clip = this.editor.getToolkit().getSystemClipboard();
        Transferable xfer = clip.getContents(this);
        MemContents model = (MemContents)this.editor.getModel();
        MemContents pasted = null;
        int numWords = 0;
        if (xfer.isDataFlavorSupported(binaryFlavor)) {
            try {
                long[] data = (long[])xfer.getTransferData(binaryFlavor);
                numWords = data.length;
                int addrBits = 32 - Integer.numberOfLeadingZeros(numWords);
                pasted = MemContents.create(addrBits, model.getValueWidth(), false);
                pasted.set(0L, data);
            }
            catch (UnsupportedFlavorException | IOException e) {
                return;
            }
        }
        if (xfer.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            String buf;
            try {
                buf = (String)xfer.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException | IOException e) {
                return;
            }
            try {
                HexFile.ParseResult r = HexFile.parseFromClipboard(buf, model.getLogLength(), model.getValueWidth());
                pasted = r.model;
                numWords = r.numWords;
            }
            catch (IOException e) {
                OptionPane.showMessageDialog(this.editor.getRootPane(), e.getMessage(), Strings.S.get("hexPasteErrorTitle"), 0);
                return;
            }
        }
        OptionPane.showMessageDialog(this.editor.getRootPane(), Strings.S.get("hexPasteSupportedError"), Strings.S.get("hexPasteErrorTitle"), 0);
        return;
        Caret caret = this.editor.getCaret();
        long p0 = caret.getMark();
        long p1 = caret.getDot();
        if (p0 == p1) {
            if (p0 + (long)numWords - 1L <= model.getLastOffset()) {
                model.copyFrom(p0, pasted, 0L, numWords);
            } else {
                model.copyFrom(p0, pasted, 0L, (int)(model.getLastOffset() - p0 + 1L));
            }
        } else {
            if (p0 < 0L || p1 < 0L) {
                return;
            }
            if (p0 > p1) {
                long t = p0;
                p0 = p1;
                p1 = t;
            }
            if (++p1 - p0 > (long)numWords) {
                int action = OptionPane.showConfirmDialog(this.editor.getRootPane(), Strings.S.get("hexPasteTooSmall", numWords, p1 - p0), Strings.S.get("hexPasteErrorTitle"), 2, 3);
                if (action != 0) {
                    return;
                }
                p1 = p0 + (long)numWords;
            } else if (p1 - p0 < (long)numWords) {
                int action = OptionPane.showConfirmDialog(this.editor.getRootPane(), Strings.S.get("hexPasteTooSmall", numWords, p1 - p0), Strings.S.get("hexPasteErrorTitle"), 2, 3);
                if (action != 0) {
                    return;
                }
                numWords = (int)(p1 - p0);
            }
            model.copyFrom(p0, pasted, 0L, numWords);
        }
    }

    private static class Data
    implements Transferable {
        private final long[] data;

        Data(long[] data) {
            this.data = data;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (flavor == binaryFlavor) {
                return this.data;
            }
            if (flavor == DataFlavor.stringFlavor) {
                int bits = 1;
                for (long datum : this.data) {
                    for (long k = datum >> bits; k != 0L && bits < 32; ++bits, k >>= 1) {
                    }
                }
                int chars = (bits + 3) / 4;
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < this.data.length; ++i) {
                    if (i > 0) {
                        buf.append(i % 8 == 0 ? (char)'\n' : ' ');
                    }
                    buf.append(String.format("%0" + chars + "x", this.data[i]));
                }
                return buf.toString();
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{binaryFlavor, DataFlavor.stringFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor == binaryFlavor || flavor == DataFlavor.stringFlavor;
        }
    }
}

