/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.icons;

import com.cburch.logisim.gui.icons.BaseIcon;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;

public class DrcIcon
extends BaseIcon {
    public final boolean drawEmpty;

    public DrcIcon(boolean isDrcError) {
        this.drawEmpty = !isDrcError;
    }

    @Override
    protected void paintIcon(Graphics2D g2) {
        if (this.drawEmpty) {
            return;
        }
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, this.getIconWidth(), this.getIconHeight());
        GeneralPath p = new GeneralPath();
        p.moveTo(this.scale(15), 0.0f);
        p.quadTo(this.scale(7), this.scale(7), 0.0f, this.scale(6));
        p.lineTo(0.0f, this.scale(8));
        p.quadTo(this.scale(7), this.scale(9), this.scale(15), this.scale(2));
        p.closePath();
        g2.setColor(Color.RED.brighter().brighter());
        g2.fill(p);
        this.paintText(g2);
        p = new GeneralPath();
        p.moveTo(0.0f, this.scale(6));
        p.quadTo(this.scale(3), this.scale(14), this.scale(12), this.scale(11));
        p.lineTo(this.scale(12), this.scale(9));
        p.lineTo(this.scale(15), this.scale(12));
        p.lineTo(this.scale(12), this.scale(15));
        p.lineTo(this.scale(12), this.scale(13));
        p.quadTo(this.scale(3), this.scale(16), 0.0f, this.scale(8));
        p.closePath();
        g2.setColor(Color.RED.darker());
        g2.fill(p);
    }

    private void paintText(Graphics2D g2) {
        Font f = g2.getFont().deriveFont(this.scale((float)this.getIconWidth() / 3.0f)).deriveFont(1);
        TextLayout t = new TextLayout("DRC", f, g2.getFontRenderContext());
        g2.setColor(Color.BLUE.darker().darker());
        t.draw(g2, (float)(this.getIconWidth() / 2) - (float)t.getBounds().getCenterX(), (float)(this.getIconHeight() / 2) - (float)t.getBounds().getCenterY());
    }

    private void paintText(Graphics2D g2, String s) {
        Font f = g2.getFont().deriveFont(this.scale((float)this.getIconWidth() / (float)s.length())).deriveFont(1);
        TextLayout t = new TextLayout(s, f, g2.getFontRenderContext());
        g2.setColor(Color.RED.darker().darker());
        t.draw(g2, (float)(this.getIconWidth() / 2) - (float)t.getBounds().getCenterX(), (float)(this.getIconHeight() / 2) - (float)t.getBounds().getCenterY());
    }
}

