/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.icons;

import com.cburch.logisim.gui.icons.BaseIcon;
import com.cburch.logisim.prefs.AppPreferences;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;

public class ProjectAddIcon
extends BaseIcon {
    private static final int[] points = new int[]{2, 6, 6, 6, 6, 2, 9, 2, 9, 6, 13, 6, 13, 9, 9, 9, 9, 13, 6, 13, 6, 9, 2, 9};
    private boolean removeIcon = false;
    private boolean vhdl = false;
    private boolean deselect = false;

    public ProjectAddIcon() {
        this.vhdl = true;
    }

    public ProjectAddIcon(boolean removeSymbol) {
        this.removeIcon = removeSymbol;
    }

    public void setDeselect(boolean val) {
        this.deselect = val;
    }

    @Override
    protected void paintIcon(Graphics2D g2) {
        if (this.deselect) {
            g2.setComposite(AlphaComposite.getInstance(3, 0.3f));
        }
        if (this.vhdl) {
            g2.setColor(Color.GREEN.darker().darker());
            Font f = g2.getFont().deriveFont((float)AppPreferences.getIconSize() / 1.6f).deriveFont(1);
            TextLayout l1 = new TextLayout("VH", f, g2.getFontRenderContext());
            double top = (double)(AppPreferences.getIconSize() / 4) - l1.getBounds().getCenterY();
            double left = (double)(AppPreferences.getIconSize() / 2) - l1.getBounds().getCenterX();
            l1.draw(g2, (float)left, (float)top);
            l1 = new TextLayout("DL", f, g2.getFontRenderContext());
            top = (double)(3 * AppPreferences.getIconSize() / 4) - l1.getBounds().getCenterY();
            left = (double)(AppPreferences.getIconSize() / 2) - l1.getBounds().getCenterX();
            l1.draw(g2, (float)left, (float)top);
            g2.dispose();
            return;
        }
        if (this.removeIcon) {
            g2.setColor(Color.RED);
            g2.translate(AppPreferences.getIconSize() / 2, AppPreferences.getIconSize() / 2);
            g2.rotate(0.7853981633974483);
            g2.translate(-AppPreferences.getIconSize() / 2, -AppPreferences.getIconSize() / 2);
        } else {
            g2.setColor(Color.GREEN.darker());
        }
        GeneralPath path = new GeneralPath();
        path.moveTo(AppPreferences.getScaled(points[0]), AppPreferences.getScaled(points[1]));
        for (int i = 2; i < points.length; i += 2) {
            path.lineTo(AppPreferences.getScaled(points[i]), AppPreferences.getScaled(points[i + 1]));
        }
        path.closePath();
        g2.fill(path);
        g2.setColor(this.removeIcon ? Color.RED.darker() : Color.GREEN.darker().darker());
        g2.draw(path);
    }
}

