/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.icons;

import com.cburch.logisim.prefs.AppPreferences;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import javax.swing.Icon;

public class WarningIcon
implements Icon {
    private final int wixth;

    public WarningIcon() {
        this.wixth = AppPreferences.getIconSize();
    }

    public WarningIcon(double scale) {
        this.wixth = (int)AppPreferences.getScaled(scale * (double)AppPreferences.getIconSize());
    }

    public static int scale(int v) {
        return AppPreferences.getScaled(v);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.translate(x, y);
        int[] xpos = new int[]{0, this.wixth / 2 - 1, this.wixth - 1};
        int[] ypos = new int[]{this.wixth - 1, 0, this.wixth - 1};
        g2.setColor(Color.YELLOW.brighter().brighter());
        g2.fillPolygon(xpos, ypos, 3);
        g2.setStroke(new BasicStroke(WarningIcon.scale(1)));
        g2.setColor(Color.BLACK);
        g2.drawPolygon(xpos, ypos, 3);
        Font f = g2.getFont().deriveFont((float)this.wixth / 1.3f).deriveFont(1);
        TextLayout t = new TextLayout("!", f, g2.getFontRenderContext());
        float xc = (float)this.wixth / 2.0f - (float)t.getBounds().getCenterX();
        float yc = (float)(5 * this.wixth) / 8.0f - (float)t.getBounds().getCenterY();
        t.draw(g2, xc, yc);
        g2.dispose();
    }

    @Override
    public int getIconWidth() {
        return this.wixth;
    }

    @Override
    public int getIconHeight() {
        return this.wixth;
    }
}

