/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.main;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitAttributes;
import com.cburch.logisim.circuit.CircuitException;
import com.cburch.logisim.circuit.CircuitMutation;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.circuit.Wire;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.comp.PositionComparator;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.generic.AttrTableSetException;
import com.cburch.logisim.gui.generic.AttributeSetTableModel;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.gui.main.AttrTableCircuitModel;
import com.cburch.logisim.gui.main.Frame;
import com.cburch.logisim.gui.main.Selection;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.proj.Action;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.tools.SetAttributeAction;
import com.cburch.logisim.util.AutoLabel;
import com.cburch.logisim.vhdl.base.VhdlContent;
import java.util.List;
import java.util.TreeSet;

class AttrTableSelectionModel
extends AttributeSetTableModel
implements Selection.Listener {
    private final Project project;
    private final Frame frame;

    public AttrTableSelectionModel(Project project, Frame frame) {
        super(frame.getCanvas().getSelection().getAttributeSet());
        this.project = project;
        this.frame = frame;
        frame.getCanvas().getSelection().addListener(this);
    }

    @Override
    public void attributeValueChanged(AttributeEvent e) {
        super.attributeValueChanged(e);
        if (e.getAttribute().equals(StdAttr.LABEL)) {
            this.fireTitleChanged();
        }
    }

    @Override
    public String getTitle() {
        ComponentFactory wireFactory = null;
        ComponentFactory factory = null;
        String label = null;
        Location loc = null;
        int factoryCount = 0;
        int totalCount = 0;
        boolean variousFound = false;
        Selection selection = this.frame.getCanvas().getSelection();
        for (Component comp : selection.getComponents()) {
            ComponentFactory fact = comp.getFactory();
            if (fact.equals(factory)) {
                ++factoryCount;
            } else if (comp instanceof Wire) {
                wireFactory = fact;
                if (factory == null) {
                    ++factoryCount;
                }
            } else if (factory == null) {
                factory = fact;
                factoryCount = 1;
                label = comp.getAttributeSet().getValue(StdAttr.LABEL);
                loc = comp.getLocation();
            } else {
                variousFound = true;
            }
            if (comp instanceof Wire) continue;
            ++totalCount;
        }
        if (factory == null) {
            factory = wireFactory;
        }
        if (variousFound) {
            this.setInstance(factory);
            return Strings.S.get("selectionVarious", "" + totalCount);
        }
        if (factoryCount == 0) {
            Circuit circ = this.frame.getCanvas().getCircuit();
            if (circ != null) {
                String circName = circ.getName();
                this.setInstance(circ.getSubcircuitFactory());
                return Strings.S.get("circuitAttrTitle", circName);
            }
            VhdlContent hdl = (VhdlContent)this.frame.getCanvas().getCurrentHdl();
            String circName = hdl.getName();
            this.setInstance(null);
            return Strings.S.get("hdlAttrTitle", circName);
        }
        if (factoryCount == 1) {
            this.setInstance(factory);
            if (label != null && label.length() > 0) {
                return factory.getDisplayName() + " \"" + label + "\"";
            }
            if (loc != null) {
                return factory.getDisplayName() + " " + String.valueOf(loc);
            }
            return factory.getDisplayName();
        }
        this.setInstance(factory);
        return Strings.S.get("selectionMultiple", factory.getDisplayName(), "" + factoryCount);
    }

    @Override
    public void selectionChanged(Selection.Event event) {
        this.fireTitleChanged();
        if (!this.frame.getEditorView().equals("appearance")) {
            this.frame.setAttrTableModel(this);
        }
    }

    @Override
    public void setValueRequested(Attribute<Object> attr, Object value) throws AttrTableSetException {
        Selection selection = this.frame.getCanvas().getSelection();
        Circuit circuit = this.frame.getCanvas().getCircuit();
        if (circuit != null && selection.isEmpty()) {
            AttrTableCircuitModel circuitModel = new AttrTableCircuitModel(this.project, circuit);
            circuitModel.setValueRequested(attr, value);
        } else {
            SetAttributeAction act = new SetAttributeAction(circuit, Strings.S.getter("selectionAttributeAction"));
            AutoLabel labeler = null;
            if (attr.equals(StdAttr.LABEL)) {
                labeler = new AutoLabel((String)value, circuit);
            }
            TreeSet<Component> comps = new TreeSet<Component>(new PositionComparator());
            comps.addAll(selection.getComponents());
            for (Component comp : comps) {
                List<Attribute<?>> mayBeChangedList;
                if (comp instanceof Wire) continue;
                ComponentFactory componentFactory = comp.getFactory();
                if (componentFactory instanceof SubcircuitFactory) {
                    SubcircuitFactory fac = (SubcircuitFactory)componentFactory;
                    if (attr.equals(CircuitAttributes.NAMED_CIRCUIT_BOX_FIXED_SIZE) || attr.equals(CircuitAttributes.NAME_ATTR)) {
                        try {
                            CircuitMutation mutation = new CircuitMutation(fac.getSubcircuit());
                            mutation.setForCircuit(attr, value);
                            Action action = mutation.toAction(null);
                            this.project.doAction(action);
                        }
                        catch (CircuitException ex) {
                            OptionPane.showMessageDialog(this.project.getFrame(), ex.getMessage());
                        }
                        return;
                    }
                }
                if (attr.equals(StdAttr.LABEL)) {
                    if (labeler.hasNext(circuit)) {
                        if (comps.size() > 1) {
                            act.set(comp, attr, labeler.getNext(circuit, comp.getFactory()));
                            continue;
                        }
                        if (this.getAttributeSet().getValue(StdAttr.LABEL).equals(value)) {
                            return;
                        }
                        act.set(comp, attr, labeler.getCurrent(circuit, comp.getFactory()));
                        continue;
                    }
                    act.set(comp, attr, "");
                    continue;
                }
                AttributeSet compAttrSet = comp.getAttributeSet();
                if (compAttrSet != null && (mayBeChangedList = compAttrSet.attributesMayAlsoBeChanged(attr, value)) != null) {
                    for (Attribute<?> mayChangeAttr : mayBeChangedList) {
                        act.set(comp, mayChangeAttr, compAttrSet.getValue(mayChangeAttr));
                    }
                }
                act.set(comp, attr, value);
            }
            this.project.doAction(act);
        }
    }
}

