/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.main;

import com.cburch.draw.toolbar.ToolbarItem;
import com.cburch.logisim.gui.menu.LogisimMenuItem;
import com.cburch.logisim.gui.menu.MenuListener;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.util.IconsUtil;
import com.cburch.logisim.util.StringGetter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;

public class LogisimToolbarItem
implements ToolbarItem {
    private final MenuListener menu;
    private final LogisimMenuItem action;
    private Icon icon;
    private StringGetter toolTip;

    public LogisimToolbarItem(MenuListener menu, String iconName, LogisimMenuItem action, StringGetter toolTip) {
        this.menu = menu;
        this.icon = IconsUtil.getIcon(iconName);
        this.action = action;
        this.toolTip = toolTip;
    }

    public LogisimToolbarItem(MenuListener menu, Icon icon, LogisimMenuItem action, StringGetter toolTip) {
        this.menu = menu;
        this.icon = icon;
        this.action = action;
        this.toolTip = toolTip;
    }

    public void doAction() {
        if (this.menu != null && this.menu.isEnabled(this.action)) {
            this.menu.doAction(this.action);
        }
    }

    @Override
    public Dimension getDimension(Object orientation) {
        if (this.icon == null) {
            return new Dimension(AppPreferences.getScaled(16), AppPreferences.getScaled(16));
        }
        int w = this.icon.getIconWidth();
        int h = this.icon.getIconHeight();
        return new Dimension(w, h + 2);
    }

    @Override
    public String getToolTip() {
        return this.toolTip != null ? this.toolTip.toString() : null;
    }

    public void setToolTip(StringGetter toolTip) {
        this.toolTip = toolTip;
    }

    @Override
    public boolean isSelectable() {
        return this.menu != null && this.menu.isEnabled(this.action);
    }

    @Override
    public void paintIcon(Component destination, Graphics gfx) {
        if (!this.isSelectable() && gfx instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)gfx;
            g2d.setComposite(AlphaComposite.getInstance(3, 0.3f));
        }
        if (this.icon == null) {
            int simple = AppPreferences.getScaled(16) >> 2;
            gfx.setColor(new Color(255, 128, 128));
            gfx.fillRect(simple, simple, 2 * simple, 2 * simple);
            gfx.setColor(Color.BLACK);
            gfx.drawLine(simple, simple, 3 * simple, 3 * simple);
            gfx.drawLine(simple, 3 * simple, 3 * simple, simple);
            gfx.drawRect(simple, simple, 2 * simple, 2 * simple);
        } else {
            this.icon.paintIcon(destination, gfx, 0, 1);
        }
    }

    public void setIcon(String iconName) {
        this.icon = IconsUtil.getIcon(iconName);
    }
}

