/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.main;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitEvent;
import com.cburch.logisim.circuit.CircuitListener;
import com.cburch.logisim.circuit.ReplacementMap;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.gui.main.Canvas;
import com.cburch.logisim.gui.main.SelectionAttributes;
import com.cburch.logisim.gui.main.SelectionBase;
import com.cburch.logisim.gui.main.SelectionSave;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.proj.Action;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.proj.ProjectEvent;
import com.cburch.logisim.proj.ProjectListener;
import com.cburch.logisim.tools.CustomHandles;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Selection
extends SelectionBase {
    static final Logger logger = LoggerFactory.getLogger(Selection.class);
    private final MyListener myListener = new MyListener();
    private final boolean isVisible = true;
    private final SelectionAttributes attrs;

    public Selection(Project proj, Canvas canvas) {
        super(proj);
        this.attrs = new SelectionAttributes(canvas, this);
        proj.addProjectListener(this.myListener);
        proj.addCircuitListener(this.myListener);
    }

    public boolean contains(Component comp) {
        return this.unionSet.contains(comp);
    }

    public void draw(ComponentDrawContext context, Set<Component> hidden) {
        Graphics g = context.getGraphics();
        for (Component c : this.lifted) {
            if (hidden.contains(c)) continue;
            Location loc = c.getLocation();
            Graphics gfxNew = g.create();
            context.setGraphics(gfxNew);
            c.getFactory().drawGhost(context, new Color(AppPreferences.COMPONENT_GHOST_COLOR.get()), loc.getX(), loc.getY(), c.getAttributeSet());
            gfxNew.dispose();
        }
        for (Component comp : this.unionSet) {
            if (this.suppressHandles.contains(comp) || hidden.contains(comp)) continue;
            Graphics gfxNew = g.create();
            context.setGraphics(gfxNew);
            CustomHandles handler = (CustomHandles)comp.getFeature(CustomHandles.class);
            if (handler == null) {
                context.drawHandles(comp);
            } else {
                handler.drawHandles(context);
            }
            gfxNew.dispose();
        }
        context.setGraphics(g);
    }

    public void drawGhostsShifted(ComponentDrawContext context, int dx, int dy) {
        if (this.shouldSnap()) {
            dx = Canvas.snapXToGrid(dx);
            dy = Canvas.snapYToGrid(dy);
        }
        Graphics g = context.getGraphics();
        for (Component comp : this.unionSet) {
            AttributeSet attrs = comp.getAttributeSet();
            Location loc = comp.getLocation();
            int x = loc.getX() + dx;
            int y = loc.getY() + dy;
            context.setGraphics(g.create());
            comp.getFactory().drawGhost(context, new Color(AppPreferences.COMPONENT_GHOST_COLOR.get()), x, y, attrs);
            context.getGraphics().dispose();
        }
        context.setGraphics(g);
    }

    public boolean equals(Object other) {
        boolean bl;
        if (other instanceof Selection) {
            Selection otherSelection = (Selection)other;
            bl = this.selected.equals(otherSelection.selected) && this.lifted.equals(otherSelection.lifted);
        } else {
            bl = false;
        }
        return bl;
    }

    public Collection<Component> getAnchoredComponents() {
        return this.selected;
    }

    public AttributeSet getAttributeSet() {
        return this.attrs;
    }

    public Set<Component> getComponents() {
        return this.unionSet;
    }

    public Collection<Component> getComponentsContaining(Location query) {
        HashSet<Component> ret = new HashSet<Component>();
        for (Component comp : this.unionSet) {
            if (!comp.contains(query)) continue;
            ret.add(comp);
        }
        return ret;
    }

    public Collection<Component> getComponentsContaining(Location query, Graphics g) {
        HashSet<Component> ret = new HashSet<Component>();
        for (Component comp : this.unionSet) {
            if (!comp.contains(query, g)) continue;
            ret.add(comp);
        }
        return ret;
    }

    public Collection<Component> getComponentsWithin(Bounds bds) {
        HashSet<Component> ret = new HashSet<Component>();
        for (Component comp : this.unionSet) {
            if (!bds.contains(comp.getBounds())) continue;
            ret.add(comp);
        }
        return ret;
    }

    public Collection<Component> getComponentsWithin(Bounds bds, Graphics g) {
        HashSet<Component> ret = new HashSet<Component>();
        for (Component comp : this.unionSet) {
            if (!bds.contains(comp.getBounds(g))) continue;
            ret.add(comp);
        }
        return ret;
    }

    public Collection<Component> getFloatingComponents() {
        return this.lifted;
    }

    public boolean isEmpty() {
        return this.selected.isEmpty() && this.lifted.isEmpty();
    }

    @Override
    public void print() {
        logger.error("isVisible: {}", (Object)true);
        super.print();
    }

    private class MyListener
    implements ProjectListener,
    CircuitListener {
        private final WeakHashMap<Action, SelectionSave> savedSelections = new WeakHashMap();

        MyListener() {
        }

        @Override
        public void circuitChanged(CircuitEvent event) {
            if (event.getAction() == 6) {
                Circuit circuit = event.getCircuit();
                ReplacementMap repl = event.getResult().getReplacementMap(circuit);
                boolean change = false;
                ArrayList<Component> oldAnchored = new ArrayList<Component>(Selection.this.getComponents());
                for (Component comp : oldAnchored) {
                    Collection<Component> replacedBy = repl.getReplacementsFor(comp);
                    if (replacedBy == null) continue;
                    change = true;
                    Selection.this.selected.remove(comp);
                    Selection.this.lifted.remove(comp);
                    for (Component add : replacedBy) {
                        if (circuit.contains(add)) {
                            Selection.this.selected.add(add);
                            continue;
                        }
                        Selection.this.lifted.add(add);
                    }
                }
                if (change) {
                    Selection.this.fireSelectionChanged();
                }
            }
        }

        @Override
        public void projectChanged(ProjectEvent event) {
            int type = event.getAction();
            if (type == 5) {
                SelectionSave save = SelectionSave.create(Selection.this);
                this.savedSelections.put((Action)event.getData(), save);
            } else if (type == 6) {
                SelectionSave save = this.savedSelections.get(event.getData());
                if (save != null && save.isSame(Selection.this)) {
                    this.savedSelections.remove(event.getData());
                }
            } else if (type == 7) {
                SelectionSave save = this.savedSelections.get(event.getOldData());
                this.savedSelections.put((Action)event.getData(), save);
            } else if (type == 9) {
                Circuit circ = event.getProject().getCurrentCircuit();
                Action act = (Action)event.getData();
                SelectionSave save = this.savedSelections.get(act);
                if (save != null) {
                    Selection.this.lifted.clear();
                    Selection.this.selected.clear();
                    for (int i = 0; i < 2; ++i) {
                        Component[] cs = i == 0 ? save.getFloatingComponents() : save.getAnchoredComponents();
                        if (cs == null) continue;
                        for (Component c : cs) {
                            if (circ.contains(c)) {
                                Selection.this.selected.add(c);
                                continue;
                            }
                            Selection.this.lifted.add(c);
                        }
                    }
                    Selection.this.fireSelectionChanged();
                }
            }
        }
    }

    public static interface Listener {
        public void selectionChanged(Event var1);
    }

    public static class Event {
        final Object source;

        Event(Object source) {
            this.source = source;
        }

        public Object getSource() {
            return this.source;
        }
    }
}

