/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.main;

import com.cburch.contracts.BaseMouseListenerContract;
import com.cburch.draw.toolbar.Toolbar;
import com.cburch.logisim.gui.main.SimulationToolbarModel;
import com.cburch.logisim.gui.main.SimulationTreeCircuitNode;
import com.cburch.logisim.gui.main.SimulationTreeModel;
import com.cburch.logisim.gui.main.SimulationTreeRenderer;
import com.cburch.logisim.gui.menu.MenuListener;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.proj.ProjectEvent;
import com.cburch.logisim.proj.ProjectListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

class SimulationExplorer
extends JPanel
implements ProjectListener,
BaseMouseListenerContract {
    private static final long serialVersionUID = 1L;
    private final Project project;
    private final SimulationTreeModel model;
    private final JTree tree;

    SimulationExplorer(Project proj, MenuListener menu) {
        super(new BorderLayout());
        this.project = proj;
        SimulationToolbarModel toolbarModel = new SimulationToolbarModel(proj, menu);
        Toolbar toolbar = new Toolbar(toolbarModel);
        this.add((Component)toolbar, "North");
        this.model = new SimulationTreeModel(proj.getRootCircuitStates());
        this.model.setCurrentView(this.project.getCircuitState());
        this.tree = new ScaledTree(this.model);
        this.tree.setCellRenderer(new SimulationTreeRenderer());
        this.tree.addMouseListener(this);
        this.tree.setToggleClickCount(3);
        this.add((Component)new JScrollPane(this.tree), "Center");
        proj.addProjectListener(this);
    }

    private void checkForPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            // empty if block
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Object last;
        TreePath path;
        if (e.getClickCount() == 2 && (path = this.tree.getPathForLocation(e.getX(), e.getY())) != null && (last = path.getLastPathComponent()) instanceof SimulationTreeCircuitNode) {
            SimulationTreeCircuitNode node = (SimulationTreeCircuitNode)last;
            this.project.setCircuitState(node.getCircuitState());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.requestFocus();
        this.checkForPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.checkForPopup(e);
    }

    @Override
    public void projectChanged(ProjectEvent event) {
        int action = event.getAction();
        if (action == 4) {
            this.model.updateSimulationList(this.project.getRootCircuitStates());
            this.model.setCurrentView(this.project.getCircuitState());
            TreePath path = this.model.mapToPath(this.project.getCircuitState());
            if (path != null) {
                this.tree.scrollPathToVisible(path);
            }
        }
    }

    private static class ScaledTree
    extends JTree {
        public ScaledTree(TreeModel model) {
            super(model);
        }
    }
}

