/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.main;

import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.gui.generic.ProjectExplorer;
import com.cburch.logisim.gui.main.SimulationTreeModel;
import com.cburch.logisim.gui.main.SimulationTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class SimulationTreeRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component ret = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        SimulationTreeModel model = (SimulationTreeModel)tree.getModel();
        if (ret instanceof JLabel) {
            SimulationTreeNode node;
            ComponentFactory factory;
            JLabel label = (JLabel)ret;
            if (value instanceof SimulationTreeNode && (factory = (node = (SimulationTreeNode)value).getComponentFactory()) != null) {
                label.setIcon(new RendererIcon(factory, node.isCurrentView(model)));
            }
        }
        return ret;
    }

    private static class RendererIcon
    implements Icon {
        private final ComponentFactory factory;
        private final boolean isCurrentView;

        RendererIcon(ComponentFactory factory, boolean isCurrentView) {
            this.factory = factory;
            this.isCurrentView = isCurrentView;
        }

        @Override
        public int getIconHeight() {
            return 20;
        }

        @Override
        public int getIconWidth() {
            return 20;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            ComponentDrawContext context = new ComponentDrawContext(c, null, null, g, g);
            this.factory.paintIcon(context, x, y, this.factory.createAttributeSet());
            if (this.isCurrentView) {
                int tx = x + 13;
                int ty = y + 13;
                int[] xp = new int[]{tx - 1, x + 18, x + 20, tx + 1};
                int[] yp = new int[]{ty + 1, y + 20, y + 18, ty - 1};
                g.setColor(ProjectExplorer.MAGNIFYING_INTERIOR);
                g.fillOval(x + 5, y + 5, 10, 10);
                g.setColor(Color.BLACK);
                g.drawOval(x + 5, y + 5, 10, 10);
                g.fillPolygon(xp, yp, xp.length);
            }
        }
    }
}

