/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.opts;

import com.cburch.logisim.file.ToolbarData;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.generic.ProjectExplorer;
import com.cburch.logisim.gui.generic.ProjectExplorerToolNode;
import com.cburch.logisim.gui.opts.OptionsFrame;
import com.cburch.logisim.gui.opts.OptionsPanel;
import com.cburch.logisim.gui.opts.ToolbarActions;
import com.cburch.logisim.gui.opts.ToolbarList;
import com.cburch.logisim.tools.Tool;
import com.cburch.logisim.util.TableLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class ToolbarOptions
extends OptionsPanel {
    private static final long serialVersionUID = 1L;
    private final Listener listener = new Listener();
    private final ProjectExplorer explorer = new ProjectExplorer(this.getProject(), true);
    private final JButton addTool = new JButton();
    private final JButton addSeparator = new JButton();
    private final JButton moveUp = new JButton();
    private final JButton moveDown = new JButton();
    private final JButton remove = new JButton();
    private final ToolbarList list = new ToolbarList(this.getOptions().getToolbarData());

    public ToolbarOptions(OptionsFrame window) {
        super(window);
        TableLayout middleLayout = new TableLayout(1);
        JPanel middle = new JPanel(middleLayout);
        middle.add(this.addTool);
        middle.add(this.addSeparator);
        middle.add(this.moveUp);
        middle.add(this.moveDown);
        middle.add(this.remove);
        middleLayout.setRowWeight(4, 1.0);
        this.explorer.setListener(this.listener);
        this.addTool.addActionListener(this.listener);
        this.addSeparator.addActionListener(this.listener);
        this.moveUp.addActionListener(this.listener);
        this.moveDown.addActionListener(this.listener);
        this.remove.addActionListener(this.listener);
        this.list.addListSelectionListener(this.listener);
        this.listener.computeEnabled();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gridbag);
        JScrollPane explorerPane = new JScrollPane(this.explorer, 22, 30);
        JScrollPane listPane = new JScrollPane(this.list, 22, 30);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gridbag.setConstraints(explorerPane, gbc);
        this.add(explorerPane);
        gbc.fill = 3;
        gbc.anchor = 11;
        gbc.weightx = 0.0;
        gridbag.setConstraints(middle, gbc);
        this.add(middle);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gridbag.setConstraints(listPane, gbc);
        this.add(listPane);
    }

    @Override
    public String getHelpText() {
        return Strings.S.get("toolbarHelp");
    }

    @Override
    public String getTitle() {
        return Strings.S.get("toolbarTitle");
    }

    @Override
    public void localeChanged() {
        this.addTool.setText(Strings.S.get("toolbarAddTool"));
        this.addSeparator.setText(Strings.S.get("toolbarAddSeparator"));
        this.moveUp.setText(Strings.S.get("toolbarMoveUp"));
        this.moveDown.setText(Strings.S.get("toolbarMoveDown"));
        this.remove.setText(Strings.S.get("toolbarRemove"));
        this.list.localeChanged();
    }

    private class Listener
    implements ProjectExplorer.Listener,
    ActionListener,
    ListSelectionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int index;
            Object src = event.getSource();
            if (src == ToolbarOptions.this.addTool) {
                this.doAddTool(ToolbarOptions.this.explorer.getSelectedTool().cloneTool());
            } else if (src == ToolbarOptions.this.addSeparator) {
                ToolbarOptions.this.getOptions().getToolbarData().addSeparator();
            } else if (src == ToolbarOptions.this.moveUp) {
                this.doMove(-1);
            } else if (src == ToolbarOptions.this.moveDown) {
                this.doMove(1);
            } else if (src == ToolbarOptions.this.remove && (index = ToolbarOptions.this.list.getSelectedIndex()) >= 0) {
                ToolbarOptions.this.getProject().doAction(ToolbarActions.removeTool(ToolbarOptions.this.getOptions().getToolbarData(), index));
                ToolbarOptions.this.list.clearSelection();
            }
        }

        private void computeEnabled() {
            int index = ToolbarOptions.this.list.getSelectedIndex();
            ToolbarOptions.this.addTool.setEnabled(ToolbarOptions.this.explorer.getSelectedTool() != null);
            ToolbarOptions.this.moveUp.setEnabled(index > 0);
            ToolbarOptions.this.moveDown.setEnabled(index >= 0 && index < ToolbarOptions.this.list.getModel().getSize() - 1);
            ToolbarOptions.this.remove.setEnabled(index >= 0);
        }

        private void doAddTool(Tool tool) {
            if (tool != null) {
                ToolbarOptions.this.getProject().doAction(ToolbarActions.addTool(ToolbarOptions.this.getOptions().getToolbarData(), tool));
            }
        }

        private void doMove(int delta) {
            int oldIndex = ToolbarOptions.this.list.getSelectedIndex();
            int newIndex = oldIndex + delta;
            ToolbarData data = ToolbarOptions.this.getOptions().getToolbarData();
            if (oldIndex >= 0 && newIndex >= 0 && newIndex < data.size()) {
                ToolbarOptions.this.getProject().doAction(ToolbarActions.moveTool(data, oldIndex, newIndex));
                ToolbarOptions.this.list.setSelectedIndex(newIndex);
            }
        }

        @Override
        public void doubleClicked(ProjectExplorer.Event event) {
            Object target = event.getTarget();
            if (target instanceof ProjectExplorerToolNode) {
                ProjectExplorerToolNode toolNode = (ProjectExplorerToolNode)target;
                this.doAddTool((Tool)toolNode.getValue());
            }
        }

        @Override
        public JPopupMenu menuRequested(ProjectExplorer.Event event) {
            return null;
        }

        @Override
        public void selectionChanged(ProjectExplorer.Event event) {
            this.computeEnabled();
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            this.computeEnabled();
        }
    }
}

