/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.prefs;

import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.prefs.OptionsPanel;
import com.cburch.logisim.gui.prefs.PreferencesFrame;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.prefs.PrefMonitorBoolean;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AutosaveOptions
extends OptionsPanel {
    private static final long serialVersionUID = 1L;
    private final MyListener myListener = new MyListener();
    private final JCheckBox enableAutosaves;
    private final JLabel autosaveIntervalText = new JLabel();
    private final JTextField autosaveInterval = new JTextField();

    public AutosaveOptions(PreferencesFrame window) {
        super(window);
        this.enableAutosaves = ((PrefMonitorBoolean)AppPreferences.AUTOSAVE_ENABLED).getCheckBox();
        this.autosaveInterval.addActionListener(this.myListener);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gridbag.setConstraints(this, gbc);
        this.setLayout(gridbag);
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 21;
        this.add((Component)this.enableAutosaves, gbc);
        gbc.gridy = 1;
        JPanel panel = new JPanel();
        panel.add(this.autosaveIntervalText);
        panel.add(this.autosaveInterval);
        this.add((Component)panel, gbc);
        this.myListener.computeEnable();
        this.myListener.setContent();
        AppPreferences.addPropertyChangeListener("autosaveEnabled", this.myListener);
    }

    @Override
    public String getHelpText() {
        return Strings.S.get("autosaveHelp");
    }

    @Override
    public String getTitle() {
        return Strings.S.get("autosaveTitle");
    }

    @Override
    public void localeChanged() {
        this.enableAutosaves.setText(Strings.S.get("autosaveEnabled"));
        this.autosaveIntervalText.setText(Strings.S.get("autosaveInterval"));
    }

    private class MyListener
    implements ActionListener,
    PropertyChangeListener {
        private MyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("autosaveEnabled")) {
                this.computeEnable();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int val = -1;
            try {
                val = Integer.parseInt(AutosaveOptions.this.autosaveInterval.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (val <= 0 || val > 10000) {
                this.setContent();
            } else {
                AppPreferences.AUTOSAVE_INTERVAL.set(val);
            }
        }

        private void computeEnable() {
            boolean enable = AppPreferences.AUTOSAVE_ENABLED.getBoolean();
            AutosaveOptions.this.autosaveIntervalText.setEnabled(enable);
            AutosaveOptions.this.autosaveInterval.setEnabled(enable);
        }

        private void setContent() {
            AutosaveOptions.this.autosaveInterval.setText(AppPreferences.AUTOSAVE_INTERVAL.get().toString());
        }
    }
}

