/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.start;

import com.cburch.logisim.gui.prefs.PreferencesFrame;
import com.cburch.logisim.gui.start.About;
import com.cburch.logisim.gui.start.Startup;
import com.cburch.logisim.proj.ProjectActions;
import com.cburch.logisim.util.MacCompatibility;
import java.awt.Desktop;
import java.io.File;

class MacOsAdapter {
    private static boolean listenersAdded = false;

    MacOsAdapter() {
    }

    public static void addListeners() {
        if (listenersAdded || !MacCompatibility.isRunningOnMac()) {
            return;
        }
        if (Desktop.isDesktopSupported()) {
            listenersAdded = true;
            Desktop dt = Desktop.getDesktop();
            try {
                dt.setAboutHandler(e -> About.showAboutDialog(null));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                dt.setQuitHandler((e, response) -> {
                    ProjectActions.doQuit();
                    response.cancelQuit();
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                dt.setPreferencesHandler(e -> PreferencesFrame.showPreferences());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                dt.setPrintFileHandler(e -> {
                    for (File f : e.getFiles()) {
                        Startup.doPrint(f);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                dt.setOpenFileHandler(e -> {
                    for (File f : e.getFiles()) {
                        Startup.doOpen(f);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

