/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.prefs;

import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.prefs.ConvertEvent;
import com.cburch.logisim.prefs.ConvertEventListener;
import com.cburch.logisim.prefs.PrefMonitorBoolean;
import com.cburch.logisim.std.wiring.ProbeAttributes;
import java.util.ArrayList;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.Preferences;

public class PrefMonitorBooleanConvert
extends PrefMonitorBoolean {
    private final ArrayList<ConvertEventListener> myListeners = new ArrayList();

    public PrefMonitorBooleanConvert(String name, boolean dflt) {
        super(name, dflt);
    }

    public void addConvertListener(ConvertEventListener l) {
        if (!this.myListeners.contains(l)) {
            this.myListeners.add(l);
        }
    }

    public void removeConvertListener(ConvertEventListener l) {
        this.myListeners.remove(l);
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent event) {
        String name;
        Preferences prefs = event.getNode();
        String prop = event.getKey();
        if (prop.equals(name = this.getIdentifier())) {
            boolean oldValue = this.value;
            boolean newValue = prefs.getBoolean(name, this.dflt);
            if (newValue != oldValue) {
                this.value = newValue;
                AppPreferences.firePropertyChange(name, oldValue, newValue);
                if (!this.myListeners.isEmpty()) {
                    ConvertEvent e = new ConvertEvent(newValue ? ProbeAttributes.APPEAR_EVOLUTION_NEW : StdAttr.APPEAR_CLASSIC);
                    Object[] options = new Object[]{Strings.S.get("OptionYes"), Strings.S.get("OptionNo")};
                    int ret = OptionPane.showOptionDialog(null, Strings.S.get("OptionConvertAllPinsProbes", e.getValue().getDisplayGetter().toString()), Strings.S.get("OptionConvertAll"), 0, 3, null, options, options[0]);
                    if (ret == 0) {
                        this.fireConvertAction(e);
                    }
                }
            }
        }
    }

    private void fireConvertAction(ConvertEvent e) {
        for (ConvertEventListener l : this.myListeners) {
            l.attributeValueChanged(e);
        }
    }
}

