/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.proj;

import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.proj.Strings;
import com.cburch.logisim.util.StringUtil;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class ProjectBundleReadme
extends JDialog
implements ActionListener {
    public static final String README_FILE_NAME = "README.md";
    private JButton closeButton = new JButton();
    private JButton writeButton = new JButton();
    private JTextField projectName = new JTextField(20);
    private JTextField projectAuthor = new JTextField(20);
    private JTextField projectKeywords = new JTextField(20);
    private JEditorPane projectDescription = new JEditorPane();
    private ReadmeInfo projectReadmeInfo;
    private final com.cburch.logisim.gui.main.Frame parrent;

    public ProjectBundleReadme(Project project, String projName) {
        super((Frame)project.getFrame(), Strings.S.get("projBundleReadmeWindow"));
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(true);
        this.setVisible(false);
        this.closeButton.addActionListener(this);
        this.writeButton.addActionListener(this);
        this.projectName.setText(projName);
        this.parrent = project.getFrame();
    }

    public void showReadme(InputStream file) throws IOException {
        StringBuilder lines = new StringBuilder();
        int kar = 0;
        do {
            if ((kar = file.read()) < 0) continue;
            lines.append((char)kar);
        } while (kar >= 0);
        MutableDataSet options = new MutableDataSet();
        Parser parser = Parser.builder(options).build();
        HtmlRenderer renderer = HtmlRenderer.builder(options).build();
        Document readme = parser.parse(lines.toString());
        String text = renderer.render(readme);
        JEditorPane dialog = new JEditorPane("text/html", text);
        dialog.setEditable(false);
        dialog.setCaretPosition(0);
        JScrollPane scroller = new JScrollPane(dialog);
        this.setLayout(new BorderLayout());
        this.add((Component)scroller, "Center");
        this.closeButton.setText(Strings.S.get("projCloseReadme"));
        this.add((Component)this.closeButton, "South");
        this.pack();
        this.setLocationRelativeTo(this.parrent);
        this.setVisible(true);
    }

    public ReadmeInfo getReadmeInfo() {
        this.setLayout(new GridBagLayout());
        this.setResizable(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.add((Component)new JLabel(Strings.S.get("projName")), gbc);
        gbc.gridx = 1;
        this.add((Component)this.projectName, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)new JLabel(Strings.S.get("projAuthor")), gbc);
        gbc.gridx = 1;
        this.add((Component)this.projectAuthor, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)new JLabel(Strings.S.get("projKeywords")), gbc);
        gbc.gridx = 1;
        this.add((Component)this.projectKeywords, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        this.add((Component)new JLabel(Strings.S.get("projDescription"), 0), gbc);
        ++gbc.gridy;
        JScrollPane scroller = new JScrollPane(this.projectDescription);
        scroller.setPreferredSize(new Dimension(AppPreferences.getScaled(500), AppPreferences.getScaled(300)));
        this.add((Component)scroller, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        this.closeButton.setText(Strings.S.get("projCancel"));
        gbc.gridx = 1;
        this.add((Component)this.closeButton, gbc);
        this.writeButton.setText(Strings.S.get("projWriteReadme"));
        gbc.gridx = 0;
        this.add((Component)this.writeButton, gbc);
        this.pack();
        this.setLocationRelativeTo(this.parrent);
        this.setVisible(true);
        return this.projectReadmeInfo;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.closeButton.equals(e.getSource())) {
            this.setVisible(false);
            this.dispose();
        } else if (this.writeButton.equals(e.getSource())) {
            this.projectReadmeInfo = new ReadmeInfo(this, this.projectName.getText(), this.projectAuthor.getText(), this.projectKeywords.getText(), this.projectDescription.getText());
            this.setVisible(false);
            this.dispose();
        }
    }

    public static void writeReadmeFile(ZipOutputStream zipfile, ReadmeInfo info) {
        if (zipfile == null || StringUtil.isNullOrEmpty(info.projectAuthor) && StringUtil.isNullOrEmpty(info.projectDescription) && StringUtil.isNullOrEmpty(info.projectKeywords)) {
            return;
        }
        try {
            String projDescription;
            String[] keywords;
            String projKeywords;
            String[] authors;
            String projAuthor;
            String seperator = "---\n\n";
            boolean wroteheader1 = false;
            zipfile.putNextEntry(new ZipEntry(README_FILE_NAME));
            zipfile.write(Strings.S.get("projHeader").concat("\n\n").getBytes());
            String projName = info.projectName;
            if (StringUtil.isNotEmpty(projName)) {
                zipfile.write(Strings.S.get("projHeader1").concat("\n\n").getBytes());
                wroteheader1 = true;
                zipfile.write(Strings.S.fmt("projIntro", projName).concat("\n\n").getBytes());
            }
            if (StringUtil.isNotEmpty(projAuthor = info.projectAuthor) && (authors = projAuthor.split(",")).length > 0) {
                if (!wroteheader1) {
                    zipfile.write(Strings.S.get("projHeader1").concat("\n\n").getBytes());
                    wroteheader1 = true;
                }
                zipfile.write(Strings.S.get("projAuthor").getBytes());
                for (int authorId = 0; authorId < authors.length; ++authorId) {
                    if (authorId > 0) {
                        String authSep = authorId == authors.length - 1 ? (authors.length == 2 ? " and " : ", and ") : ", ";
                        zipfile.write(authSep.getBytes());
                    }
                    zipfile.write(String.format("`%s`", authors[authorId]).getBytes());
                }
                zipfile.write("\n\n".getBytes());
            }
            if (StringUtil.isNotEmpty(projKeywords = info.projectKeywords) && (keywords = projKeywords.split(",")).length > 0) {
                if (!wroteheader1) {
                    zipfile.write(Strings.S.get("projHeader1").concat("\n\n").getBytes());
                    wroteheader1 = true;
                } else {
                    zipfile.write("---\n\n".getBytes());
                }
                for (int keywordId = 0; keywordId < keywords.length; ++keywordId) {
                    if (keywordId > 0) {
                        zipfile.write(", ".getBytes());
                    }
                    zipfile.write(String.format("`%s`", keywords[keywordId]).getBytes());
                }
                zipfile.write("\n\n".getBytes());
            }
            if (StringUtil.isNotEmpty(projDescription = info.projectDescription)) {
                zipfile.write(Strings.S.get("projHeader2").concat("\n\n").getBytes());
                zipfile.write(projDescription.getBytes());
                zipfile.write("\n".getBytes());
            }
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
            LocalDateTime now = LocalDateTime.now();
            zipfile.write(Strings.S.get("projHeader3").concat("\n\n").getBytes());
            zipfile.write(Strings.S.fmt("projGenerateInfo", "Logisim-evolution v4.0.0", "https://github.com/logisim-evolution/", dtf.format(now)).concat("\n\n").getBytes());
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }

    public class ReadmeInfo {
        private String projectName;
        private String projectAuthor;
        private String projectKeywords;
        private String projectDescription;

        public ReadmeInfo(ProjectBundleReadme this$0, String name, String author, String keyword, String description) {
            this.projectName = name;
            this.projectAuthor = author;
            this.projectKeywords = keyword;
            this.projectDescription = description;
        }
    }
}

