/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.bus;

import com.cburch.logisim.data.AbstractAttributeSet;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.data.SocBusInfo;
import com.cburch.logisim.util.StringUtil;
import java.awt.Font;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class SocBusAttributes
extends AbstractAttributeSet {
    public static final Attribute<BitWidth> NrOfTracesAttr = Attributes.forBitWidth("TraceSize", Strings.S.getter("SocBusTraceSize"));
    public static final Attribute<SocBusInfo> SOC_BUS_ID = new SocBusIdAttribute();
    public static final Attribute<Boolean> SOC_TRACE_VISIBLE = Attributes.forBoolean("TraceVisible", Strings.S.getter("SocBusTraceVisible"));
    private static final List<Attribute<?>> ATTRIBUTES = Arrays.asList(NrOfTracesAttr, SOC_TRACE_VISIBLE, StdAttr.LABEL, StdAttr.LABEL_FONT, StdAttr.LABEL_VISIBILITY, SOC_BUS_ID);
    private Font labelfont = StdAttr.DEFAULT_LABEL_FONT;
    private Boolean labelVisible = true;
    private BitWidth traceSize = BitWidth.create(5);
    private String label = "";
    private SocBusInfo id = new SocBusInfo(null);
    private Boolean traceVisible = true;

    @Override
    protected void copyInto(AbstractAttributeSet dest) {
        SocBusAttributes d = (SocBusAttributes)dest;
        d.labelfont = this.labelfont;
        d.labelVisible = this.labelVisible;
        d.traceSize = this.traceSize;
        d.label = this.label;
        d.traceVisible = this.traceVisible;
        d.id = new SocBusInfo(null);
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return ATTRIBUTES;
    }

    @Override
    public <V> V getValue(Attribute<V> attr) {
        if (attr == NrOfTracesAttr) {
            return (V)this.traceSize;
        }
        if (attr == StdAttr.LABEL) {
            return (V)this.label;
        }
        if (attr == StdAttr.LABEL_FONT) {
            return (V)this.labelfont;
        }
        if (attr == StdAttr.LABEL_VISIBILITY) {
            return (V)this.labelVisible;
        }
        if (attr == SOC_BUS_ID) {
            if (StringUtil.isNullOrEmpty(this.id.getBusId())) {
                Date date = new Date();
                String[] names = this.toString().split("@");
                this.id.setBusId(String.format("0x%016X%s", date.getTime(), names[names.length - 1]));
            }
            return (V)this.id;
        }
        if (attr == SOC_TRACE_VISIBLE) {
            return (V)this.traceVisible;
        }
        return null;
    }

    @Override
    public boolean isReadOnly(Attribute<?> attr) {
        return attr == SOC_BUS_ID;
    }

    @Override
    public <V> void setValue(Attribute<V> attr, V value) {
        V oldValue = this.getValue(attr);
        if (attr == NrOfTracesAttr) {
            BitWidth v = (BitWidth)value;
            if (!this.traceSize.equals(v)) {
                this.traceSize = v;
                this.fireAttributeValueChanged(attr, value, oldValue);
            }
            return;
        }
        if (attr == StdAttr.LABEL) {
            String v = (String)value;
            if (!this.label.equals(v)) {
                this.label = v;
                this.fireAttributeValueChanged(attr, value, oldValue);
            }
            return;
        }
        if (attr == StdAttr.LABEL_FONT) {
            Font f = (Font)value;
            if (!this.labelfont.equals(f)) {
                this.labelfont = f;
                this.fireAttributeValueChanged(attr, value, oldValue);
            }
            return;
        }
        if (attr == StdAttr.LABEL_VISIBILITY) {
            Boolean v = (Boolean)value;
            if (this.labelVisible.equals(v)) {
                this.labelVisible = v;
                this.fireAttributeValueChanged(attr, value, oldValue);
            }
            return;
        }
        if (attr == SOC_BUS_ID) {
            this.id.setBusId(((SocBusInfo)value).getBusId());
            return;
        }
        if (attr == SOC_TRACE_VISIBLE) {
            Boolean v = (Boolean)value;
            if (this.traceVisible.equals(v)) {
                this.traceVisible = v;
                this.fireAttributeValueChanged(attr, value, oldValue);
            }
            return;
        }
    }

    public static class SocBusIdAttribute
    extends Attribute<SocBusInfo> {
        public SocBusIdAttribute() {
            super("SocBusIdentifier", null);
        }

        @Override
        public SocBusInfo parse(String value) {
            return new SocBusInfo(value);
        }

        @Override
        public boolean isHidden() {
            return true;
        }

        @Override
        public String toStandardString(SocBusInfo value) {
            return value.getBusId();
        }
    }
}

