/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.file;

import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.file.ElfHeader;
import com.cburch.logisim.soc.file.SectionHeader;
import com.cburch.logisim.soc.file.SymbolTable;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class ElfSectionHeader {
    public static final int STN_UNDEF = 0;
    private static final int SUCCESS = 0;
    private static final int SECTION_HEADER_NOT_FOUND_ERROR = 1;
    private static final int SECTION_HEADER_READ_ERROR = 2;
    private static final int SECTION_HEADER_SIZE_ERROR = 3;
    private static final int SECTION_STRING_TABLE_INDEX_ERROR = 4;
    private static final int SECTION_STRING_TABLE_WRONG_TYPE = 5;
    private static final int SECTION_STRING_TABLE_NOT_FOUND_ERROR = 6;
    private static final int SECTION_STRING_TABLE_READ_ERROR = 7;
    private static final int SYMBOL_TABLE_MULTIPLE_TABLES_NOT_SUPPORT = 8;
    private static final int SYMBOL_TABLE_MULTIPLE_STRING_TABLES_NOT_SUPPORT = 9;
    private static final int SYMBOL_TABLE_NOT_FOUND_ERROR = 10;
    private static final int SYMBOL_TABLE_READ_ERROR = 11;
    private int status = 0;
    private ArrayList<SectionHeader> headers;

    public ElfSectionHeader() {
        this.headers = new ArrayList();
    }

    public ElfSectionHeader(FileInputStream file, ElfHeader elfHeader) {
        try {
            file.skip(ElfHeader.getLongValue(elfHeader.getValue(22)));
        }
        catch (IOException e) {
            this.status = 1;
            return;
        }
        int nrOfHeaders = ElfHeader.getIntValue(elfHeader.getValue(28));
        int HeaderSize = ElfHeader.getIntValue(elfHeader.getValue(27));
        long BlockSize = nrOfHeaders * HeaderSize;
        byte[] buffer = new byte[(int)BlockSize];
        int nrRead = 0;
        try {
            nrRead = file.read(buffer);
        }
        catch (IOException e) {
            this.status = 2;
            return;
        }
        if ((long)nrRead != BlockSize) {
            this.status = 3;
            return;
        }
        int index = 0;
        this.headers = new ArrayList();
        for (int i = 0; i < nrOfHeaders; ++i) {
            this.headers.add(new SectionHeader(buffer, elfHeader.is32Bit(), elfHeader.isLittleEndian(), index));
            index += HeaderSize;
        }
    }

    private String getString(byte[] buffer, int index) {
        StringBuilder s = new StringBuilder();
        int idx = index;
        while (idx < buffer.length && buffer[idx] != 0) {
            s.append((char)buffer[idx++]);
        }
        return s.toString();
    }

    public boolean readSectionNames(FileInputStream file, ElfHeader elfHeader) {
        int idx = (Integer)elfHeader.getValue(29);
        if (idx == 0) {
            return true;
        }
        if (idx < 0 || idx >= this.headers.size()) {
            this.status = 4;
            return false;
        }
        SectionHeader h = this.headers.get(idx);
        if ((Integer)h.getValue(1) != 3) {
            this.status = 5;
        }
        int size = ElfHeader.getIntValue(h.getValue(5));
        try {
            file.skip(ElfHeader.getLongValue(h.getValue(4)));
        }
        catch (IOException e) {
            this.status = 6;
            return false;
        }
        byte[] buffer = new byte[size];
        int nrRead = 0;
        try {
            nrRead = file.read(buffer);
        }
        catch (IOException e) {
            this.status = 7;
            return false;
        }
        if (nrRead != size) {
            this.status = 7;
            return false;
        }
        for (SectionHeader head : this.headers) {
            head.setName(this.getString(buffer, (Integer)head.getValue(0)));
        }
        return true;
    }

    public boolean readSymbolTable(FileInputStream file, ElfHeader elfHeader) {
        SectionHeader strtab = null;
        SectionHeader shstrtab = null;
        int symtabidx = (Integer)elfHeader.getValue(29);
        for (int i = 0; i < this.headers.size(); ++i) {
            if (i == symtabidx) continue;
            SectionHeader sh = this.headers.get(i);
            if ((Integer)sh.getValue(1) == 2) {
                if (shstrtab != null) {
                    this.status = 8;
                    return false;
                }
                shstrtab = sh;
            }
            if ((Integer)sh.getValue(1) != 3) continue;
            if (strtab != null) {
                this.status = 9;
                return false;
            }
            strtab = sh;
        }
        if (shstrtab == null) {
            return true;
        }
        int symTableOffset = ElfHeader.getIntValue(shstrtab.getValue(4));
        int symTableSize = ElfHeader.getIntValue(shstrtab.getValue(5));
        int strTableOffset = strtab == null ? 1 : ElfHeader.getIntValue(strtab.getValue(4));
        int strTableSize = strtab == null ? 1 : ElfHeader.getIntValue(strtab.getValue(5));
        byte[] symBuffer = new byte[symTableSize];
        byte[] strBuffer = new byte[strTableSize];
        try {
            file.skip(Math.min(symTableOffset, strTableOffset));
        }
        catch (IOException e) {
            this.status = 10;
            return false;
        }
        int nrRead = 0;
        try {
            nrRead = file.read(symTableOffset < strTableOffset ? symBuffer : strBuffer);
        }
        catch (IOException e) {
            this.status = 11;
            return false;
        }
        if (nrRead != (symTableOffset < strTableOffset ? symTableSize : strTableSize)) {
            this.status = 11;
            return false;
        }
        int fileOffset = Math.min(symTableOffset, strTableOffset) + nrRead;
        int toskip = Math.max(symTableOffset, strTableOffset) - fileOffset;
        try {
            file.skip(toskip);
        }
        catch (IOException e) {
            this.status = 10;
            return false;
        }
        try {
            nrRead = file.read(symTableOffset > strTableOffset ? symBuffer : strBuffer);
        }
        catch (IOException e) {
            this.status = 11;
            return false;
        }
        if (nrRead != (symTableOffset > strTableOffset ? symTableSize : strTableSize)) {
            this.status = 11;
            return false;
        }
        if (symTableSize % 16 != 0) {
            this.status = 11;
            return false;
        }
        int index = 0;
        while (index < symTableSize) {
            int headerIndex;
            SymbolTable st = new SymbolTable(symBuffer, elfHeader.isLittleEndian(), index);
            index += 16;
            if (strtab != null) {
                st.setName(this.getString(strBuffer, st.getValue(0)));
            }
            if ((headerIndex = st.getValue(5).intValue()) == 0 || headerIndex >= this.headers.size()) continue;
            this.headers.get(headerIndex).addSymbol(st);
        }
        return true;
    }

    public boolean isValid() {
        return this.status == 0;
    }

    public String getErrorString() {
        return switch (this.status) {
            case 0 -> Strings.S.get("ElfSectHeadSuccess");
            case 1 -> Strings.S.get("ElfSectHeadNotFound");
            case 2 -> Strings.S.get("ElfSectHeadReadError");
            case 3 -> Strings.S.get("ElfSectHeadSizeError");
            case 4 -> Strings.S.get("ElfSectHeadStingIdxError");
            case 5 -> Strings.S.get("ElfSectHeadStingTypeError");
            case 6 -> Strings.S.get("ElfSectHeadStingNotFound");
            case 7 -> Strings.S.get("ElfSectHeadStingReadError");
            case 8 -> Strings.S.get("ElfSectHeadMultiSymtabError");
            case 9 -> Strings.S.get("ElfSectHeadMultiStringtabError");
            case 10 -> Strings.S.get("ElfSymTableNotFound");
            case 11 -> Strings.S.get("ElfSymTableReadError");
            default -> "BUG: This should never happen in ElfSectionHeader";
        };
    }

    public int getNrOfHeaders() {
        return this.headers.size();
    }

    public void addHeader(SectionHeader hdr) {
        this.headers.add(hdr);
    }

    public int indexOf(SectionHeader hdr) {
        return this.headers.indexOf(hdr);
    }

    public void clear() {
        this.headers.clear();
    }

    public SectionHeader getHeader(int index) {
        if (index < 0 || index >= this.headers.size()) {
            return null;
        }
        return this.headers.get(index);
    }

    public ArrayList<SectionHeader> getHeaders() {
        return this.headers;
    }
}

