/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.gui;

import com.cburch.contracts.BaseKeyListenerContract;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.gui.icons.BreakpointIcon;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.data.SocProcessorInterface;
import com.cburch.logisim.soc.file.ElfProgramHeader;
import com.cburch.logisim.soc.file.ElfSectionHeader;
import com.cburch.logisim.soc.util.AssemblerInterface;
import com.cburch.logisim.util.LocaleListener;
import com.cburch.logisim.util.LocaleManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.GutterIconInfo;
import org.fife.ui.rtextarea.RTextScrollPane;

public class BreakpointPanel
extends JPanel
implements CaretListener,
LocaleListener,
ActionListener,
BaseKeyListenerContract {
    private static final long serialVersionUID = 1L;
    private final RSyntaxTextArea asmWindow = new RSyntaxTextArea(20, 60);
    private final RTextScrollPane debugScrollPane;
    private final JLabel lineIndicator;
    private final HashMap<Integer, Integer> debugLines;
    private final JButton addBreakPoint;
    private final JButton removeBreakPoint;
    private int oldCaretPos;
    private int currentLine;
    private int maxLines;

    public BreakpointPanel(String highLiter) {
        this.asmWindow.setSyntaxEditingStyle(highLiter);
        this.asmWindow.setEditable(false);
        this.asmWindow.setPopupMenu(null);
        this.asmWindow.addCaretListener(this);
        this.asmWindow.addKeyListener(this);
        this.debugScrollPane = new RTextScrollPane(this.asmWindow);
        this.debugScrollPane.setLineNumbersEnabled(false);
        this.debugScrollPane.setIconRowHeaderEnabled(true);
        this.debugScrollPane.getGutter().setBookmarkIcon(new BreakpointIcon());
        this.debugScrollPane.getGutter().setBookmarkingEnabled(true);
        JPanel info = new JPanel();
        info.setLayout(new BorderLayout());
        this.lineIndicator = new JLabel();
        this.lineIndicator.setHorizontalAlignment(0);
        this.addBreakPoint = new JButton();
        this.addBreakPoint.addActionListener(this);
        this.removeBreakPoint = new JButton();
        this.removeBreakPoint.addActionListener(this);
        info.add((Component)this.addBreakPoint, "West");
        info.add((Component)this.lineIndicator, "Center");
        info.add((Component)this.removeBreakPoint, "East");
        this.setLayout(new BorderLayout());
        this.add((Component)info, "North");
        this.add(this.debugScrollPane);
        this.oldCaretPos = -1;
        this.debugLines = new HashMap();
        this.localeChanged();
        LocaleManager.addLocaleListener(this);
    }

    public void loadProgram(CircuitState state, SocProcessorInterface pIf, ElfProgramHeader progInfo, ElfSectionHeader sectInfo, AssemblerInterface assembler) {
        this.debugLines.clear();
        this.debugScrollPane.getGutter().removeAllTrackingIcons();
        this.asmWindow.setText(assembler.getProgram(state, pIf, progInfo, sectInfo, this.debugLines));
        this.asmWindow.setCaretPosition(0);
    }

    public void gotoLine(int line) {
        int curetPos;
        Element root = this.asmWindow.getDocument().getDefaultRootElement();
        for (curetPos = 0; root.getElementIndex(curetPos) != line && curetPos < root.getEndOffset(); ++curetPos) {
        }
        this.asmWindow.setCaretPosition(curetPos);
    }

    public Map<Integer, Integer> getBreakPoints() {
        HashMap<Integer, Integer> breakPoints = new HashMap<Integer, Integer>();
        for (int i : this.getBreakpointLines()) {
            breakPoints.put(this.debugLines.get(i), i);
        }
        return breakPoints;
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        int caretPos = e.getDot();
        if (caretPos != this.oldCaretPos) {
            this.oldCaretPos = caretPos;
            Element root = this.asmWindow.getDocument().getDefaultRootElement();
            this.currentLine = root.getElementIndex(caretPos) + 1;
            this.maxLines = root.getElementCount();
            this.localeChanged();
            ArrayList<Integer> dlines = this.getBreakpointLines();
            if (!this.debugLines.containsKey(this.currentLine)) {
                this.addBreakPoint.setEnabled(false);
                this.removeBreakPoint.setEnabled(false);
            } else if (dlines.contains(this.currentLine)) {
                this.removeBreakPoint.setEnabled(true);
                this.addBreakPoint.setEnabled(false);
            } else {
                this.removeBreakPoint.setEnabled(false);
                this.addBreakPoint.setEnabled(true);
            }
        }
    }

    @Override
    public void localeChanged() {
        this.lineIndicator.setText(Strings.S.get("RV32imAsmLineIndicator", this.currentLine, this.maxLines));
        this.addBreakPoint.setText(Strings.S.get("RV32imSetBreakpoint"));
        this.removeBreakPoint.setText(Strings.S.get("RV32imRemoveBreakPoint"));
    }

    private ArrayList<Integer> getBreakpointLines() {
        ArrayList<Integer> lines = new ArrayList<Integer>();
        GutterIconInfo[] bookmarks = this.debugScrollPane.getGutter().getBookmarks();
        Element root = this.asmWindow.getDocument().getDefaultRootElement();
        for (GutterIconInfo bookmark : bookmarks) {
            int pos = bookmark.getMarkedOffset();
            int line = root.getElementIndex(pos) + 1;
            if (this.debugLines.containsKey(line)) {
                lines.add(line);
                continue;
            }
            try {
                this.debugScrollPane.getGutter().toggleBookmark(line - 1);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return lines;
    }

    private void updateBreakpoint() {
        if (this.getBreakpointLines().contains(this.currentLine)) {
            try {
                this.debugScrollPane.getGutter().toggleBookmark(this.currentLine - 1);
            }
            catch (BadLocationException e) {
                return;
            }
            this.addBreakPoint.setEnabled(true);
            this.removeBreakPoint.setEnabled(false);
        } else {
            try {
                this.debugScrollPane.getGutter().toggleBookmark(this.currentLine - 1);
            }
            catch (BadLocationException e) {
                return;
            }
            this.addBreakPoint.setEnabled(false);
            this.removeBreakPoint.setEnabled(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addBreakPoint || e.getSource() == this.removeBreakPoint) {
            this.updateBreakpoint();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyChar() == 'b' && this.debugLines.containsKey(this.currentLine)) {
            this.updateBreakpoint();
        }
    }
}

