/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.jtaguart;

import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceComponent;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.soc.data.SocBusInfo;
import com.cburch.logisim.soc.data.SocBusSlaveInterface;
import com.cburch.logisim.soc.data.SocBusSlaveListener;
import com.cburch.logisim.soc.data.SocBusTransaction;
import com.cburch.logisim.soc.data.SocSupport;
import com.cburch.logisim.soc.jtaguart.JtagUartAttributes;
import com.cburch.logisim.soc.pio.PioState;
import com.cburch.logisim.util.StringUtil;
import java.util.ArrayList;
import java.util.LinkedList;

public class JtagUartState
implements SocBusSlaveInterface {
    private String label = "";
    private final SocBusInfo attachedBus = new SocBusInfo("");
    private Integer startAddress = 0;
    private AttributeOption writeFifoSize = JtagUartAttributes.OPT_64;
    private Integer writeIrqThreshold = 8;
    private AttributeOption readFifoSize = JtagUartAttributes.OPT_64;
    private Integer readIrqThreshold = 8;
    private final ArrayList<SocBusSlaveListener> listeners = new ArrayList();

    public String getLabel() {
        return this.label;
    }

    public SocBusInfo getAttachedBus() {
        return this.attachedBus;
    }

    @Override
    public Integer getStartAddress() {
        return this.startAddress;
    }

    public AttributeOption getWriteFifoSize() {
        return this.writeFifoSize;
    }

    public Integer getWriteIrqThreshold() {
        return this.writeIrqThreshold;
    }

    public AttributeOption getReadFifoSize() {
        return this.readFifoSize;
    }

    public Integer getReadIrqThreshold() {
        return this.readIrqThreshold;
    }

    public boolean setLabel(String l) {
        if (l.equals(this.label)) {
            return false;
        }
        this.label = l;
        this.fireNameChanged();
        return true;
    }

    public boolean setAttachedBus(SocBusInfo atb) {
        if (this.attachedBus.getBusId().equals(atb.getBusId())) {
            return false;
        }
        this.attachedBus.setBusId(atb.getBusId());
        return true;
    }

    public boolean setStartAddress(int addr) {
        if (addr == this.startAddress) {
            return false;
        }
        this.startAddress = addr;
        this.firememMapChanged();
        return true;
    }

    public boolean setWriteFifoSize(AttributeOption wfs) {
        if (this.writeFifoSize.equals(wfs)) {
            return false;
        }
        this.writeFifoSize = wfs;
        return true;
    }

    public boolean setWriteIrqThreshold(Integer val) {
        if (this.writeIrqThreshold == val) {
            return false;
        }
        this.writeIrqThreshold = val;
        return true;
    }

    public boolean setReadFifoSize(AttributeOption rfs) {
        if (this.readFifoSize.equals(rfs)) {
            return false;
        }
        this.readFifoSize = rfs;
        return true;
    }

    public boolean setReadIrqThreshold(Integer val) {
        if (this.readIrqThreshold == val) {
            return false;
        }
        this.readIrqThreshold = val;
        return true;
    }

    public void copyInto(JtagUartState d) {
        d.label = this.label;
        d.attachedBus.setBusId(this.attachedBus.getBusId());
        d.startAddress = this.startAddress;
        d.writeFifoSize = this.writeFifoSize;
        d.readFifoSize = this.readFifoSize;
        d.writeIrqThreshold = this.writeIrqThreshold;
        d.readIrqThreshold = this.readIrqThreshold;
    }

    public void handleOperations(InstanceState state) {
        Value curReset = state.getPortValue(1);
        Value curClock = state.getPortValue(0);
        JtagUartFifoState instState = (JtagUartFifoState)state.getData();
        if (instState == null) {
            instState = new JtagUartFifoState();
            state.setData(instState);
        }
        instState.setReset(curReset);
        if (instState.doReset) {
            state.setPort(3, Value.FALSE, 5);
            state.setPort(4, Value.TRUE, 5);
            state.setPort(7, Value.createKnown(7, 0L), 5);
            state.setPort(8, Value.FALSE, 5);
            state.setPort(9, Value.TRUE, 5);
            state.setPort(2, Value.FALSE, 5);
            instState.reset();
        }
        if (instState.endReset) {
            state.setPort(3, Value.FALSE, 5);
            state.setPort(4, Value.FALSE, 5);
            state.setPort(7, Value.createKnown(7, 0L), 5);
            state.setPort(8, Value.FALSE, 5);
            state.setPort(9, Value.FALSE, 5);
            state.setPort(2, Value.FALSE, 5);
        }
        if (curReset == Value.TRUE) {
            return;
        }
        if (instState.risingEdge(curClock)) {
            state.setPort(2, instState.isIrqPending() ? Value.TRUE : Value.FALSE, 5);
            if (instState.isWriteFifoEmpty()) {
                state.setPort(8, Value.FALSE, 5);
            } else {
                int val = instState.popWriteFifo();
                instState.setAcBit();
                state.setPort(8, Value.TRUE, 5);
                state.setPort(7, Value.createKnown(7, (long)val), 5);
            }
            if (state.getPortValue(5) == Value.TRUE && state.getPortValue(3) == Value.FALSE) {
                instState.setAcBit();
                instState.pushReadFifo((int)state.getPortValue(6).toLongValue());
                state.setPort(3, Value.TRUE, 5);
            } else {
                state.setPort(3, Value.FALSE, 5);
            }
        }
    }

    @Override
    public boolean canHandleTransaction(SocBusTransaction trans) {
        long addr = SocSupport.convUnsignedInt(trans.getAddress());
        long start = SocSupport.convUnsignedInt(this.startAddress);
        long end = start + 8L;
        return addr >= start && addr < end;
    }

    @Override
    public void handleTransaction(SocBusTransaction trans) {
        if (!this.canHandleTransaction(trans)) {
            return;
        }
        trans.setTransactionResponder(this.attachedBus.getComponent());
        long addr = SocSupport.convUnsignedInt(trans.getAddress());
        long start = SocSupport.convUnsignedInt(this.startAddress);
        if (trans.getAccessType() != 3) {
            trans.setError(7);
            return;
        }
        JtagUartFifoState state = (JtagUartFifoState)this.attachedBus.getSocSimulationManager().getdata(this.attachedBus.getComponent());
        long index = addr - start;
        if (index == 0L) {
            if (trans.isReadTransaction()) {
                trans.setReadData(state.readDataRegister());
            }
            if (trans.isWriteTransaction()) {
                state.writeDataRegister(trans.getWriteData());
            }
            return;
        }
        if (index == 4L) {
            if (trans.isReadTransaction()) {
                trans.setReadData(state.readControlRegister());
            }
            if (trans.isWriteTransaction()) {
                state.writeControlRegister(trans.getWriteData());
            }
            return;
        }
        trans.setError(6);
    }

    @Override
    public Integer getMemorySize() {
        return 8;
    }

    @Override
    public String getName() {
        String name = "BUG: Unknown";
        if (this.attachedBus != null && this.attachedBus.getComponent() != null && StringUtil.isNullOrEmpty(name = this.label)) {
            Location loc = this.attachedBus.getComponent().getLocation();
            name = String.format("%s@%d,%d", this.attachedBus.getComponent().getFactory().getDisplayName(), loc.getX(), loc.getY());
        }
        return name;
    }

    @Override
    public void registerListener(SocBusSlaveListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    @Override
    public void removeListener(SocBusSlaveListener l) {
        this.listeners.remove(l);
    }

    @Override
    public InstanceComponent getComponent() {
        if (this.attachedBus == null || this.attachedBus.getComponent() == null) {
            return null;
        }
        return (InstanceComponent)this.attachedBus.getComponent();
    }

    private void fireNameChanged() {
        for (SocBusSlaveListener l : this.listeners) {
            l.labelChanged();
        }
    }

    private void firememMapChanged() {
        for (SocBusSlaveListener l : this.listeners) {
            l.memoryMapChanged();
        }
    }

    public class JtagUartFifoState
    implements InstanceData,
    Cloneable {
        private final LinkedList<Integer> WriteFifo = new LinkedList();
        private final LinkedList<Integer> ReadFifo = new LinkedList();
        private boolean readIrqEnable = false;
        private boolean writeIrqEnable = false;
        private boolean acBit = false;
        private Value lastReset = Value.UNKNOWN;
        private Value lastClock = Value.UNKNOWN;
        private boolean doReset = false;
        private boolean endReset = false;

        public JtagUartFifoState() {
            this.reset();
        }

        public void reset() {
            this.WriteFifo.clear();
            this.ReadFifo.clear();
            this.readIrqEnable = false;
            this.writeIrqEnable = false;
            this.acBit = false;
        }

        public void setReset(Value reset) {
            this.doReset = this.lastReset == Value.FALSE && reset == Value.TRUE;
            this.endReset = this.lastReset == Value.UNKNOWN || this.lastReset == Value.TRUE && reset == Value.FALSE;
            this.lastReset = reset;
        }

        public boolean risingEdge(Value clock) {
            Value last = this.lastClock;
            this.lastClock = clock;
            return last == Value.FALSE && clock == Value.TRUE;
        }

        @Override
        public PioState.PioRegState clone() {
            try {
                return (PioState.PioRegState)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public void writeDataRegister(int value) {
            int wdata = value & 0xFF;
            if (this.WriteFifo.size() >= this.getSize(JtagUartState.this.writeFifoSize)) {
                return;
            }
            this.WriteFifo.add(wdata);
        }

        public Integer readDataRegister() {
            int result = 0;
            if (this.ReadFifo.isEmpty()) {
                return 0;
            }
            result = this.ReadFifo.getFirst() & 0xFF;
            this.ReadFifo.removeFirst();
            result |= 0x8000;
            return result |= (this.ReadFifo.size() & 0xFFFF) << 16;
        }

        public void writeControlRegister(int value) {
            this.readIrqEnable = (value & 1) != 0;
            boolean bl = this.writeIrqEnable = (value & 2) != 0;
            if ((value & 0x400) != 0) {
                this.acBit = false;
            }
        }

        public Integer readControlRegister() {
            int result = 0;
            if (this.readIrqEnable) {
                result |= 1;
            }
            if (this.writeIrqEnable) {
                result |= 2;
            }
            if (this.readIrqPending()) {
                result |= 0x100;
            }
            if (this.writeIrqPending()) {
                result |= 0x200;
            }
            if (this.acBit) {
                result |= 0x400;
            }
            int avail = this.getSize(JtagUartState.this.writeFifoSize) - this.WriteFifo.size();
            return result |= (avail & 0xFFFF) << 16;
        }

        private boolean readIrqPending() {
            if (!this.readIrqEnable) {
                return false;
            }
            int readFifoEmptySpaces = this.getSize(JtagUartState.this.readFifoSize) - this.ReadFifo.size();
            return readFifoEmptySpaces <= JtagUartState.this.readIrqThreshold;
        }

        private boolean writeIrqPending() {
            if (!this.writeIrqEnable) {
                return false;
            }
            return this.WriteFifo.size() <= JtagUartState.this.writeIrqThreshold;
        }

        public boolean isIrqPending() {
            return this.readIrqPending() || this.writeIrqPending();
        }

        public boolean isWriteFifoEmpty() {
            return this.WriteFifo.isEmpty();
        }

        public void setAcBit() {
            this.acBit = true;
        }

        public int popWriteFifo() {
            if (this.WriteFifo.isEmpty()) {
                return -1;
            }
            int val = this.WriteFifo.getFirst();
            this.WriteFifo.removeFirst();
            return val;
        }

        public void pushReadFifo(Integer val) {
            if (this.ReadFifo.size() >= this.getSize(JtagUartState.this.readFifoSize)) {
                return;
            }
            this.ReadFifo.add(val);
        }

        private int getSize(AttributeOption opt) {
            if (opt.equals(JtagUartAttributes.OPT_8)) {
                return 8;
            }
            if (opt.equals(JtagUartAttributes.OPT_16)) {
                return 16;
            }
            if (opt.equals(JtagUartAttributes.OPT_32)) {
                return 32;
            }
            if (opt.equals(JtagUartAttributes.OPT_64)) {
                return 64;
            }
            if (opt.equals(JtagUartAttributes.OPT_128)) {
                return 128;
            }
            if (opt.equals(JtagUartAttributes.OPT_256)) {
                return 256;
            }
            if (opt.equals(JtagUartAttributes.OPT_512)) {
                return 512;
            }
            if (opt.equals(JtagUartAttributes.OPT_1024)) {
                return 1024;
            }
            if (opt.equals(JtagUartAttributes.OPT_2048)) {
                return 2048;
            }
            if (opt.equals(JtagUartAttributes.OPT_4096)) {
                return 4096;
            }
            if (opt.equals(JtagUartAttributes.OPT_8192)) {
                return 8192;
            }
            if (opt.equals(JtagUartAttributes.OPT_16384)) {
                return 16384;
            }
            if (opt.equals(JtagUartAttributes.OPT_32768)) {
                return 32768;
            }
            return -1;
        }
    }
}

