/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.nios2;

import com.cburch.contracts.BaseWindowListenerContract;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.ComponentDataGuiProvider;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceComponent;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceStateImpl;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.data.SocBusInfo;
import com.cburch.logisim.soc.data.SocBusTransaction;
import com.cburch.logisim.soc.data.SocProcessorInterface;
import com.cburch.logisim.soc.data.SocSupport;
import com.cburch.logisim.soc.data.SocUpMenuProvider;
import com.cburch.logisim.soc.data.SocUpSimulationState;
import com.cburch.logisim.soc.data.SocUpSimulationStateListener;
import com.cburch.logisim.soc.data.SocUpStateInterface;
import com.cburch.logisim.soc.data.TraceInfo;
import com.cburch.logisim.soc.file.ElfProgramHeader;
import com.cburch.logisim.soc.file.ElfSectionHeader;
import com.cburch.logisim.soc.gui.BreakpointPanel;
import com.cburch.logisim.soc.gui.CpuDrawSupport;
import com.cburch.logisim.soc.nios2.Nios2Assembler;
import com.cburch.logisim.soc.nios2.Nios2Attributes;
import com.cburch.logisim.soc.nios2.Nios2CustomInstructions;
import com.cburch.logisim.soc.util.AssemblerExecutionInterface;
import com.cburch.logisim.soc.util.AssemblerInterface;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JPanel;
import org.fife.ui.rsyntaxtextarea.AbstractTokenMakerFactory;
import org.fife.ui.rsyntaxtextarea.TokenMakerFactory;

public class Nios2State
implements SocUpSimulationStateListener,
SocProcessorInterface {
    private int resetVector = 0;
    private int exceptionVector = 20;
    private int breakVector = 48;
    private int nrOfIrqs = 0;
    private String label = "";
    private final SocBusInfo attachedBus = new SocBusInfo("");
    public static final AssemblerInterface ASSEMBLER = new Nios2Assembler();
    public static final String[] registerABINames = new String[]{"zero", "at", "r2", "r3", "r4", "r5", "r6", "r7", "r8", "r9", "r10", "r11", "r12", "r13", "r14", "r15", "r16", "r17", "r18", "r19", "r20", "r21", "r22", "r23", "et", "bt", "gp", "sp", "fp", "ea", "sstat", "ra"};

    public static int getRegisterIndex(String name) {
        int index;
        String regName = name.toLowerCase();
        for (int i = 0; i < registerABINames.length; ++i) {
            if (!registerABINames[i].equals(regName)) continue;
            return i;
        }
        if (regName.startsWith("r") && regName.length() < 4) {
            try {
                index = Integer.parseUnsignedInt(regName.substring(1));
            }
            catch (NumberFormatException e) {
                index = -1;
            }
            return index;
        }
        if (regName.startsWith("ctl") && regName.length() < 6) {
            try {
                index = Integer.parseUnsignedInt(regName.substring(3));
            }
            catch (NumberFormatException e) {
                index = -1;
            }
            return index;
        }
        if (regName.startsWith("c") && regName.length() < 4) {
            try {
                index = Integer.parseUnsignedInt(regName.substring(1));
            }
            catch (NumberFormatException e) {
                index = -1;
            }
            return index;
        }
        return -1;
    }

    public static boolean isCustomRegister(String name) {
        String regName = name.toLowerCase();
        return regName.startsWith("c") && regName.length() < 4 && !regName.startsWith("ctl");
    }

    public static boolean isControlRegister(String name) {
        String regName = name.toLowerCase();
        return regName.startsWith("ctl") && regName.length() < 6;
    }

    public void copyInto(Nios2State dest) {
        dest.resetVector = this.resetVector;
        dest.exceptionVector = this.exceptionVector;
        dest.breakVector = this.breakVector;
        dest.nrOfIrqs = this.nrOfIrqs;
        dest.label = this.label;
        dest.attachedBus.setBusId(this.attachedBus.getBusId());
    }

    public String getName() {
        String name = this.label;
        if (StringUtil.isNullOrEmpty(name)) {
            Location loc = this.attachedBus.getComponent().getLocation();
            name = String.format("%s@%d,%d", this.attachedBus.getComponent().getFactory().getDisplayName(), loc.getX(), loc.getY());
        }
        return name;
    }

    public boolean setResetVector(int value) {
        if (this.resetVector == value) {
            return false;
        }
        this.resetVector = value;
        return true;
    }

    public Integer getResetVector() {
        return this.resetVector;
    }

    public boolean setExceptionVector(int value) {
        if (this.exceptionVector == value) {
            return false;
        }
        this.exceptionVector = value;
        return true;
    }

    public Integer getExceptionVector() {
        return this.exceptionVector;
    }

    public boolean setBreakVector(int value) {
        if (this.breakVector == value) {
            return false;
        }
        this.breakVector = value;
        return true;
    }

    public Integer getBreakVector() {
        return this.breakVector;
    }

    public boolean setNrOfIrqs(int value) {
        if (this.nrOfIrqs == value) {
            return false;
        }
        this.nrOfIrqs = value;
        return true;
    }

    public Integer getNrOfIrqs() {
        return this.nrOfIrqs;
    }

    public boolean setLabel(String value) {
        if (this.label.equals(value)) {
            return false;
        }
        this.label = value;
        return true;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean setAttachedBus(SocBusInfo value) {
        if (this.attachedBus.getBusId().equals(value.getBusId())) {
            return false;
        }
        this.attachedBus.setBusId(value.getBusId());
        return true;
    }

    public SocBusInfo getAttachedBus() {
        return this.attachedBus;
    }

    public ProcessorState getNewState(Instance inst) {
        return new ProcessorState(inst);
    }

    public void paint(int x, int y, Graphics2D g2, Instance inst, boolean visible, InstanceData pstate) {
        Graphics2D gfx = (Graphics2D)g2.create();
        gfx.translate(x + CpuDrawSupport.upStateBounds.getX(), y + CpuDrawSupport.upStateBounds.getY());
        ProcessorState state = (ProcessorState)pstate;
        if (visible && state != null) {
            state.draw(gfx, false);
        } else {
            gfx.setColor(Color.LIGHT_GRAY);
            gfx.fillRect(0, 0, CpuDrawSupport.upStateBounds.getWidth(), CpuDrawSupport.upStateBounds.getHeight());
            gfx.setColor(Color.BLACK);
            GraphicsUtil.drawCenteredText(gfx, Strings.S.get("SocHiddenForFasterSimulation"), CpuDrawSupport.upStateBounds.getWidth() / 2, CpuDrawSupport.upStateBounds.getHeight() / 2);
        }
        gfx.dispose();
        if (state != null) {
            state.simState.paint(g2, x, y, CpuDrawSupport.simStateBounds);
        }
    }

    @Override
    public void simulationStateChanged() {
        if (this.attachedBus != null && this.attachedBus.getComponent() != null) {
            ((InstanceComponent)this.attachedBus.getComponent()).getInstance().fireInvalidated();
        }
    }

    @Override
    public void setEntryPointandReset(CircuitState state, long entryPoint, ElfProgramHeader progInfo, ElfSectionHeader sectInfo) {
        InstanceComponent comp;
        int entry = (int)entryPoint;
        if (this.attachedBus != null && this.attachedBus.getComponent() != null && (comp = (InstanceComponent)this.attachedBus.getComponent()).getInstance() != null) {
            ProcessorState pstate = (ProcessorState)comp.getInstance().getData(state);
            if (pstate != null) {
                pstate.reset(state, entry, progInfo, sectInfo);
            }
            comp.getInstance().fireInvalidated();
        }
    }

    @Override
    public void insertTransaction(SocBusTransaction trans, boolean hidden, CircuitState cState) {
        if (hidden) {
            trans.setAsHiddenTransaction();
        }
        if (cState == null) {
            InstanceComponent comp = (InstanceComponent)this.attachedBus.getComponent();
            if (comp == null) {
                return;
            }
            InstanceStateImpl state = comp.getInstanceStateImpl();
            if (state == null) {
                return;
            }
            cState = state.getProject().getCircuitState();
        }
        this.attachedBus.getSocSimulationManager().initializeTransaction(trans, this.attachedBus.getBusId(), cState);
    }

    @Override
    public int getEntryPoint(CircuitState cState) {
        InstanceComponent comp;
        if (cState != null && (comp = (InstanceComponent)this.attachedBus.getComponent()) != null) {
            return ((ProcessorState)cState.getData(comp)).getEntryPoint();
        }
        return 0;
    }

    public class ProcessorState
    extends JPanel
    implements InstanceData,
    Cloneable,
    ComponentDataGuiProvider,
    BaseWindowListenerContract,
    SocUpStateInterface {
        private static final int STATUS_RSIE = 0x800000;
        private static final int STATUS_PIE = 1;
        private static final long serialVersionUID = 1L;
        private final int[] registers = new int[32];
        private final Boolean[] registers_valid = new Boolean[32];
        private int pc;
        private int status;
        private int estatus;
        private int bstatus;
        private int ienable;
        private int ipending;
        private int lastRegisterWritten = -1;
        private final LinkedList<TraceInfo> instrTrace = new LinkedList();
        private Value lastClock = Value.createUnknown(BitWidth.ONE);
        private final SocUpSimulationState simState = new SocUpSimulationState();
        private final Instance myInstance;
        private boolean visible;
        private Integer entryPoint;
        private boolean programLoaded;
        private final BreakpointPanel bPanel;

        public ProcessorState(Instance inst) {
            this.myInstance = inst;
            this.setSize(AppPreferences.getScaled(CpuDrawSupport.upStateBounds.getWidth()), AppPreferences.getScaled(CpuDrawSupport.upStateBounds.getHeight()));
            SocUpMenuProvider.SOCUPMENUPROVIDER.registerCpuState(this, inst);
            this.visible = false;
            this.entryPoint = null;
            this.programLoaded = false;
            AbstractTokenMakerFactory atmf = (AbstractTokenMakerFactory)TokenMakerFactory.getDefaultInstance();
            atmf.putMapping(ASSEMBLER.getHighlightStringIdentifier(), "com.cburch.logisim.soc.nios2.Nios2SyntaxHighlighter");
            this.bPanel = new BreakpointPanel(ASSEMBLER.getHighlightStringIdentifier());
            this.reset();
        }

        @Override
        public void paint(Graphics g) {
            this.draw((Graphics2D)g, true);
        }

        public void reset() {
            this.reset(null, null, null, null);
        }

        public Instance getInstance() {
            return this.myInstance;
        }

        public void reset(CircuitState state, Integer entry, ElfProgramHeader progInfo, ElfSectionHeader sectInfo) {
            if (entry != null) {
                this.entryPoint = entry;
            }
            if (progInfo != null || sectInfo != null) {
                this.programLoaded = true;
                this.bPanel.loadProgram(state, this.getProcessorInterface(), progInfo, sectInfo, ASSEMBLER);
            }
            this.pc = this.entryPoint != null ? this.entryPoint : Nios2State.this.resetVector;
            for (int i = 0; i < 31; ++i) {
                this.registers_valid[i] = false;
            }
            this.lastRegisterWritten = -1;
            this.status = 0x800000;
            this.estatus = 0;
            this.bstatus = 0;
            this.ienable = 0;
            this.ipending = 0;
            this.instrTrace.clear();
            if (this.visible) {
                this.repaint();
            }
            this.simState.reset();
        }

        public int getEntryPoint() {
            return this.entryPoint;
        }

        @Override
        public boolean programLoaded() {
            return this.programLoaded;
        }

        @Override
        public JPanel getAsmWindow() {
            return this.bPanel;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int value) {
            this.status = value & 1;
            this.status |= 0x800000;
        }

        public int getIenable() {
            return this.ienable;
        }

        public void setIenable(int value) {
            if (this.ienable != value) {
                this.ienable = value;
                this.repaint();
            }
        }

        public int getIpending() {
            return this.ipending;
        }

        public void setIpending(int value) {
            if (this.ipending != value) {
                this.ipending = value;
                this.repaint();
            }
        }

        public int getControlRegister(int index) {
            return switch (index) {
                case 0 -> this.status;
                case 1 -> this.estatus;
                case 2 -> this.bstatus;
                case 3 -> this.ienable;
                case 4 -> this.ipending;
                default -> 0;
            };
        }

        public void setControlRegister(int index, int value) {
            switch (index) {
                case 0: {
                    this.setStatus(value);
                    break;
                }
                case 1: {
                    this.estatus = value;
                    break;
                }
                case 2: {
                    this.bstatus = value;
                    break;
                }
                case 3: {
                    this.ienable = value;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported index value: " + index);
                }
            }
        }

        public void setClock(Value clock, CircuitState cState) {
            if (this.lastClock == Value.FALSE && clock == Value.TRUE) {
                this.execute(cState);
            }
            this.lastClock = clock;
        }

        @Override
        public int getProgramCounter() {
            return this.pc;
        }

        @Override
        public SocUpSimulationState getSimState() {
            return this.simState;
        }

        @Override
        public void simButtonPressed() {
            this.simState.buttonPressed();
        }

        public void setProgramCounter(int value) {
            this.pc = value;
        }

        public int getRegisterValue(int index) {
            if (index == 0 || index > 31) {
                return 0;
            }
            return this.registers[index - 1];
        }

        @Override
        public String getRegisterValueHex(int index) {
            return this.isRegisterValid(index) != false ? String.format("0x%08X", this.getRegisterValue(index)) : "??????????";
        }

        public Boolean isRegisterValid(int index) {
            if (index == 0) {
                return true;
            }
            if (index > 31) {
                return false;
            }
            return this.registers_valid[index - 1];
        }

        public void writeRegister(int index, int value) {
            this.lastRegisterWritten = -1;
            if (index != 0 && index <= 31) {
                this.registers_valid[index - 1] = true;
                this.registers[index - 1] = value;
                this.lastRegisterWritten = index;
            }
        }

        public void interrupt() {
            this.estatus = this.status;
            this.status &= 0xFFFFFFFE;
            this.pc = Nios2State.this.exceptionVector;
            this.repaint();
        }

        public void endofInterrupt() {
            this.status = this.estatus;
            this.pc = this.getRegisterValue(29);
            this.repaint();
        }

        public void breakReq() {
            this.bstatus = this.status;
            this.status &= 0xFFFFFFFE;
            long nextPc = SocSupport.convUnsignedInt(this.pc) + 4L;
            this.writeRegister(30, SocSupport.convUnsignedLong(nextPc));
            this.pc = Nios2State.this.breakVector;
            this.repaint();
        }

        public void breakRet() {
            this.status = this.bstatus;
            this.pc = this.getRegisterValue(30);
            this.repaint();
        }

        public Component getMasterComponent() {
            return Nios2State.this.attachedBus.getComponent();
        }

        public void execute(CircuitState cState) {
            int maskedIrqs;
            Nios2CustomInstructions cust;
            AssemblerExecutionInterface assemblerExecutionInterface;
            if (!this.simState.canExecute()) {
                return;
            }
            if (ASSEMBLER.getExeUnit() != null && (assemblerExecutionInterface = ASSEMBLER.getExeUnit()) instanceof Nios2CustomInstructions && (cust = (Nios2CustomInstructions)assemblerExecutionInterface).isValid() && cust.waitingOnReady(this, cState)) {
                return;
            }
            Map<Integer, Integer> breakPoints = this.bPanel.getBreakPoints();
            if (breakPoints.containsKey(this.pc) && this.simState.breakPointReached()) {
                this.bPanel.gotoLine(breakPoints.get(this.pc) - 1);
                OptionPane.showMessageDialog(null, Strings.S.get("RV32imBreakPointReached"), SocSupport.getMasterName(cState, Nios2State.this.getName()), 1);
                return;
            }
            if ((this.status & 1) != 0 && (maskedIrqs = this.ienable & this.ipending) != 0) {
                this.writeRegister(29, this.pc);
                this.interrupt();
                this.repaint();
            }
            SocBusTransaction trans = new SocBusTransaction(1, this.pc, 0, 3, Nios2State.this.attachedBus.getComponent());
            Nios2State.this.attachedBus.getSocSimulationManager().initializeTransaction(trans, Nios2State.this.attachedBus.getBusId(), cState);
            if (trans.hasError()) {
                OptionPane.showMessageDialog(null, trans.getErrorMessage(), SocSupport.getMasterName(cState, Nios2State.this.getName()) + Strings.S.get("RV32imFetchTransaction"), 0);
                this.simState.errorInExecution();
                return;
            }
            int instruction = trans.getReadData();
            ASSEMBLER.decode(instruction);
            AssemblerExecutionInterface exe = ASSEMBLER.getExeUnit();
            this.lastRegisterWritten = -1;
            while (this.instrTrace.size() >= 21) {
                this.instrTrace.removeLast();
            }
            if (exe == null) {
                OptionPane.showMessageDialog(null, Strings.S.get("RV32imFetchInvalidInstruction"), SocSupport.getMasterName(cState, Nios2State.this.getName()) + Strings.S.get("RV32imFetchTransaction"), 0);
                this.simState.errorInExecution();
                this.instrTrace.addFirst(new TraceInfo(this.pc, instruction, Strings.S.get("RV32imFetchInvInstrAsm"), true));
                this.pc += 4;
                if (this.visible) {
                    this.repaint();
                }
                return;
            }
            TraceInfo trace = new TraceInfo(this.pc, instruction, exe.getAsmInstruction(), false);
            if (!exe.execute(this, cState)) {
                StringBuilder s = new StringBuilder();
                s.append(Strings.S.get("RV32imFetchExecutionError"));
                if (exe.getErrorMessage() != null) {
                    s.append("\n").append(exe.getErrorMessage());
                }
                OptionPane.showMessageDialog(null, s.toString(), SocSupport.getMasterName(cState, Nios2State.this.getName()) + Strings.S.get("RV32imFetchTransaction"), 0);
                this.simState.errorInExecution();
                trace.setError();
                this.instrTrace.addFirst(trace);
                if (this.visible) {
                    this.repaint();
                }
                return;
            }
            this.instrTrace.addFirst(trace);
            if (!exe.performedJump()) {
                this.pc += 4;
            }
            if (this.visible) {
                this.repaint();
            }
        }

        @Override
        public ProcessorState clone() {
            try {
                return (ProcessorState)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public void insertTransaction(SocBusTransaction trans, boolean hidden, CircuitState cState) {
            if (hidden) {
                trans.setAsHiddenTransaction();
            }
            Nios2State.this.attachedBus.getSocSimulationManager().initializeTransaction(trans, Nios2State.this.attachedBus.getBusId(), cState);
        }

        public void draw(Graphics2D g, boolean scale) {
            CpuDrawSupport.drawRegisters(g, 0, 0, scale, this);
            CpuDrawSupport.drawHexReg(g, 170, 0, scale, this.pc, Strings.S.get("Rv32imProgramCounter"), true);
            CpuDrawSupport.drawHexReg(g, 275, 0, scale, this.status, Strings.S.get("Nios2Status"), true);
            CpuDrawSupport.drawHexReg(g, 380, 0, scale, this.estatus, Strings.S.get("Nios2Estatus"), true);
            CpuDrawSupport.drawHexReg(g, 485, 0, scale, this.bstatus, Strings.S.get("Nios2Bstatus"), true);
            CpuDrawSupport.drawTrace(g, 170, 40, scale, this);
            if (Nios2State.this.nrOfIrqs > 0) {
                CpuDrawSupport.drawIRQs(g, 0, 500, scale, Nios2State.this.nrOfIrqs, this.ipending, this.ienable);
            }
        }

        @Override
        public void destroy() {
            SocUpMenuProvider.SOCUPMENUPROVIDER.deregisterCpuState(this, this.myInstance);
        }

        @Override
        public void windowOpened(WindowEvent e) {
            this.repaint();
            this.visible = true;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.visible = false;
        }

        @Override
        public void windowIconified(WindowEvent e) {
            this.visible = false;
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
            this.repaint();
            this.visible = true;
        }

        @Override
        public void windowActivated(WindowEvent e) {
            this.visible = true;
        }

        @Override
        public int getLastRegisterWritten() {
            return this.lastRegisterWritten;
        }

        @Override
        public String getRegisterAbiName(int index) {
            return registerABINames[index];
        }

        @Override
        public String getRegisterNormalName(int index) {
            return "r" + index;
        }

        @Override
        public LinkedList<TraceInfo> getTraces() {
            return this.instrTrace;
        }

        @Override
        public WindowListener getWindowListener() {
            return this;
        }

        @Override
        public JPanel getStatePanel() {
            return this;
        }

        @Override
        public String getProcessorType() {
            return "Nios2s";
        }

        @Override
        public AssemblerInterface getAssembler() {
            return ASSEMBLER;
        }

        @Override
        public SocProcessorInterface getProcessorInterface() {
            return this.myInstance.getAttributeValue(Nios2Attributes.NIOS2_STATE);
        }

        @Override
        public int getElfType() {
            return 113;
        }
    }
}

