/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.pio;

import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.data.SocSupport;
import com.cburch.logisim.soc.pio.PioAttributes;
import com.cburch.logisim.soc.pio.PioState;
import com.cburch.logisim.tools.MenuExtender;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class PioMenu
implements ActionListener,
MenuExtender {
    private final Instance instance;
    private Frame frame;
    private JMenuItem exportC;

    public PioMenu(Instance inst) {
        this.instance = inst;
    }

    @Override
    public void configureMenu(JPopupMenu menu, Project proj) {
        this.frame = proj.getFrame();
        this.exportC = SocSupport.createItem(this, Strings.S.get("ExportC"));
        menu.addSeparator();
        menu.add(this.exportC);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.exportC) {
            this.exportC();
        }
    }

    private void exportC() {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        int result = fc.showDialog(this.frame, Strings.S.get("SelectDirectoryToStoreC"));
        if (result == 0) {
            String functName;
            PioState myState = this.instance.getAttributeValue(PioAttributes.PIO_STATE);
            if (myState == null) {
                throw new NullPointerException("BUG in PioMenu.java");
            }
            String compName = myState.getName().replace(" ", "_").replace("@", "_").replace(",", "_").toUpperCase();
            String headerFileName = fc.getSelectedFile().getAbsolutePath() + File.separator + compName + ".h";
            String cFileName = fc.getSelectedFile().getAbsolutePath() + File.separator + compName + ".c";
            FileWriter headerFile = null;
            FileWriter cFile = null;
            try {
                headerFile = new FileWriter(headerFileName, false);
            }
            catch (IOException e) {
                headerFile = null;
            }
            try {
                cFile = new FileWriter(cFileName, false);
            }
            catch (IOException e) {
                cFile = null;
            }
            if (headerFile == null || cFile == null) {
                OptionPane.showMessageDialog(this.frame, Strings.S.get("ErrorCreatingHeaderAndOrCFile"), Strings.S.get("ExportC"), 0);
                return;
            }
            PrintWriter headerWriter = new PrintWriter(headerFile);
            PrintWriter cWriter = new PrintWriter(cFile);
            headerWriter.println("/* Logisim automatically generated file for a PIO-component */\n");
            cWriter.println("/* Logisim automatically generated file for a PIO-component */\n");
            headerWriter.println("#ifndef __" + compName + "_H__");
            headerWriter.println("#define __" + compName + "_H__");
            headerWriter.println();
            int base = myState.getStartAddress();
            int nrBits = myState.getNrOfIOs().getWidth();
            if (myState.getPortDirection() != PioAttributes.PORT_INPUT) {
                functName = "OutputValue";
                headerWriter.println(Strings.S.get("PioMenuOutputDataFunctionRemark", Integer.toString(nrBits)));
                SocSupport.addSetterFunction(headerWriter, compName, functName, base, 0, true);
                headerWriter.println();
                SocSupport.addSetterFunction(cWriter, compName, functName, base, 0, false);
            }
            if (myState.getPortDirection() != PioAttributes.PORT_OUTPUT) {
                functName = "InputValue";
                headerWriter.println(Strings.S.get("PioMenuInputDataFunctionRemark", Integer.toString(nrBits)));
                SocSupport.addGetterFunction(headerWriter, compName, functName, base, 0, true);
                headerWriter.println();
                SocSupport.addGetterFunction(cWriter, compName, functName, base, 0, false);
                if (myState.getPortDirection() == PioAttributes.PORT_BIDIR) {
                    functName = "DirectionReg";
                    headerWriter.println(Strings.S.get("PioMenuBidirFunctionsRemark", Integer.toString(nrBits)));
                    SocSupport.addAllFunctions(headerWriter, cWriter, compName, functName, base, 2);
                }
                if (myState.inputGeneratesIrq().booleanValue()) {
                    functName = "IrqMaskReg";
                    String reactName = myState.getIrqType() == PioAttributes.IRQ_EDGE ? Strings.S.get("PioMenuIrqEdge") : Strings.S.get("PioMenuIrqLevel");
                    headerWriter.println(Strings.S.get("PioMenuMaskFunctionsRemark", reactName, Integer.toString(nrBits)));
                    SocSupport.addAllFunctions(headerWriter, cWriter, compName, functName, base, 2);
                }
                if (myState.inputIsCapturedSynchronisely().booleanValue()) {
                    functName = "EdgeCapturReg";
                    String EdgeName = Strings.S.get("PioMenuCaptureAny");
                    if (myState.getInputCaptureEdge() == PioAttributes.CAPT_RISING) {
                        EdgeName = Strings.S.get("PioMenuCaptureRising");
                    }
                    if (myState.getInputCaptureEdge() == PioAttributes.CAPT_FALLING) {
                        EdgeName = Strings.S.get("PioMenuCaptureFalling");
                    }
                    String ClearName = myState.inputCaptureSupportsBitClearing() != false ? Strings.S.get("PioMenuCaptureBit") : Strings.S.get("PioMenuCaptureAll");
                    headerWriter.println(Strings.S.get("PioMenuEdgeCaptureRemark", EdgeName, ClearName, Integer.toString(nrBits)));
                    SocSupport.addAllFunctions(headerWriter, cWriter, compName, functName, base, 3);
                }
                if (myState.outputSupportsBitManipulations().booleanValue()) {
                    functName = "OutsetReg";
                    headerWriter.println(Strings.S.get("PioMenuOutSetRemark", Integer.toString(nrBits)));
                    SocSupport.addSetterFunction(headerWriter, compName, functName, base, 4, true);
                    headerWriter.println();
                    SocSupport.addSetterFunction(cWriter, compName, functName, base, 4, false);
                    functName = "OutclearReg";
                    headerWriter.println(Strings.S.get("PioMenuOutClearRemark", Integer.toString(nrBits)));
                    SocSupport.addSetterFunction(headerWriter, compName, functName, base, 5, true);
                    headerWriter.println();
                    SocSupport.addSetterFunction(cWriter, compName, functName, base, 5, false);
                }
            }
            headerWriter.println("#endif");
            headerWriter.close();
            cWriter.close();
            OptionPane.showMessageDialog(this.frame, Strings.S.get("SuccesCreatingHeaderAndCFile", headerFileName, cFileName));
        }
    }
}

