/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.pio;

import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceComponent;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.soc.data.SocBusInfo;
import com.cburch.logisim.soc.data.SocBusSlaveInterface;
import com.cburch.logisim.soc.data.SocBusSlaveListener;
import com.cburch.logisim.soc.data.SocBusTransaction;
import com.cburch.logisim.soc.data.SocSupport;
import com.cburch.logisim.soc.pio.PioAttributes;
import com.cburch.logisim.util.StringUtil;
import java.util.ArrayList;

public class PioState
implements SocBusSlaveInterface {
    private static final int DATA_REG_INDEX = 0;
    private static final int DIR_REG_INDEX = 4;
    private static final int IRQ_MASK_INDEX = 8;
    private static final int EDGE_CAPT_INDEX = 12;
    private static final int OUT_SET_INDEX = 16;
    private static final int OUT_CLEAR_INDEX = 20;
    private BitWidth nrOfIOs = BitWidth.create(1);
    private String label = "";
    private final SocBusInfo attachedBus = new SocBusInfo("");
    private Integer startAddress = 0;
    private final ArrayList<SocBusSlaveListener> listeners = new ArrayList();
    private AttributeOption direction = PioAttributes.PORT_INPUT;
    private Integer outputResetValue = 0;
    private Boolean outputEnableBitManipulations = false;
    private Boolean inputSynchronousCapture = false;
    private AttributeOption edgeCaptureType = PioAttributes.CAPT_RISING;
    private Boolean inputCaptBitClearing = false;
    private Boolean inputGeneratesIrq = false;
    private AttributeOption irqType = PioAttributes.IRQ_LEVEL;

    public void copyInto(PioState d) {
        d.nrOfIOs = this.nrOfIOs;
        d.label = this.label;
        d.attachedBus.setBusId(this.attachedBus.getBusId());
        d.startAddress = this.startAddress;
        d.direction = this.direction;
        d.outputResetValue = this.outputResetValue;
        d.outputEnableBitManipulations = this.outputEnableBitManipulations;
        d.inputSynchronousCapture = this.inputSynchronousCapture;
        d.edgeCaptureType = this.edgeCaptureType;
        d.inputCaptBitClearing = this.inputCaptBitClearing;
        d.inputGeneratesIrq = this.inputGeneratesIrq;
        d.irqType = this.irqType;
    }

    public BitWidth getNrOfIOs() {
        return this.nrOfIOs;
    }

    public String getLabel() {
        return this.label;
    }

    public SocBusInfo getAttachedBus() {
        return this.attachedBus;
    }

    public AttributeOption getPortDirection() {
        return this.direction;
    }

    public Integer getOutputResetValue() {
        return this.outputResetValue;
    }

    public Boolean outputSupportsBitManipulations() {
        return this.outputEnableBitManipulations;
    }

    public Boolean inputIsCapturedSynchronisely() {
        return this.inputSynchronousCapture;
    }

    public AttributeOption getInputCaptureEdge() {
        return this.edgeCaptureType;
    }

    public Boolean inputCaptureSupportsBitClearing() {
        return this.inputCaptBitClearing;
    }

    public Boolean inputGeneratesIrq() {
        return this.inputGeneratesIrq != false && this.direction != PioAttributes.PORT_OUTPUT;
    }

    public AttributeOption getIrqType() {
        return this.inputGeneratesIrq() != false && this.inputIsCapturedSynchronisely() != false ? this.irqType : PioAttributes.IRQ_LEVEL;
    }

    public boolean setNrOfIOs(BitWidth nr) {
        if (nr.getWidth() == this.nrOfIOs.getWidth()) {
            return false;
        }
        this.nrOfIOs = nr;
        return true;
    }

    public boolean setLabel(String l) {
        if (this.label.equals(l)) {
            return false;
        }
        this.label = l;
        this.fireNameChanged();
        return true;
    }

    public boolean setAttachedBus(SocBusInfo i) {
        if (this.attachedBus.getBusId().equals(i.getBusId())) {
            return false;
        }
        this.attachedBus.setBusId(i.getBusId());
        return true;
    }

    public boolean setStartAddress(Integer addr) {
        if (this.startAddress.equals(addr)) {
            return false;
        }
        this.startAddress = addr;
        this.firememMapChanged();
        return true;
    }

    public boolean setPortDirection(AttributeOption dir) {
        if (this.direction == dir) {
            return false;
        }
        this.direction = dir;
        return true;
    }

    public boolean setOutputResetValue(Integer val) {
        if (this.outputResetValue.equals(val)) {
            return false;
        }
        this.outputResetValue = val;
        return true;
    }

    public boolean setOutputBitManupulations(Boolean b) {
        if (this.outputEnableBitManipulations.equals(b)) {
            return false;
        }
        this.outputEnableBitManipulations = b;
        return true;
    }

    public boolean setInputSynchronousCapture(Boolean b) {
        if (this.inputSynchronousCapture.equals(b)) {
            return false;
        }
        this.inputSynchronousCapture = b;
        return true;
    }

    public boolean setInputCaptureEdge(AttributeOption val) {
        if (this.edgeCaptureType == val) {
            return false;
        }
        this.edgeCaptureType = val;
        return true;
    }

    public boolean setInputCaptureBitClearing(Boolean b) {
        if (this.inputCaptBitClearing.equals(b)) {
            return false;
        }
        this.inputCaptBitClearing = b;
        return true;
    }

    public boolean setIrqGeneration(Boolean b) {
        if (this.inputGeneratesIrq.equals(b)) {
            return false;
        }
        this.inputGeneratesIrq = b;
        return true;
    }

    public boolean setIrqType(AttributeOption val) {
        if (this.irqType == val) {
            return false;
        }
        this.irqType = val;
        return true;
    }

    public int handleOperations(InstanceState state, boolean captureOnly) {
        int i;
        PioRegState regs = (PioRegState)state.getData();
        if (regs == null) {
            regs = new PioRegState();
            state.setData(regs);
        }
        if (state.getPortValue(0) == Value.TRUE) {
            regs.reset();
        }
        int index = this.inputGeneratesIrq() != false ? 2 : 1;
        int nrOfBits = this.nrOfIOs.getWidth();
        int outputStart = index + (this.direction == PioAttributes.PORT_INOUT ? this.nrOfIOs.getWidth() : 0);
        int inputs = 0;
        for (i = 0; i < nrOfBits; ++i) {
            if (state.getPortValue(index + i) != Value.TRUE) continue;
            inputs |= 1 << i;
        }
        if (this.inputGeneratesIrq().booleanValue()) {
            boolean isIrq;
            int irqSource = this.irqType == PioAttributes.IRQ_LEVEL ? inputs : regs.captureRegister;
            int irqs = irqSource & regs.interruptMask;
            boolean bl = isIrq = irqs != 0;
            if (!regs.oldIrqValid || isIrq != regs.oldIrq) {
                state.setPort(1, isIrq ? Value.TRUE : Value.FALSE, 10);
            }
            regs.oldIrqValid = true;
            regs.oldIrq = isIrq;
        }
        if (captureOnly) {
            return inputs;
        }
        regs.updateCaptureRegister(inputs);
        if (this.direction != PioAttributes.PORT_INPUT) {
            for (i = 0; i < nrOfBits; ++i) {
                boolean isOutput;
                Value val = (regs.outputRegister & 1 << i) != 0 ? Value.TRUE : Value.FALSE;
                boolean bl = isOutput = this.direction != PioAttributes.PORT_BIDIR || (regs.directionRegister >> i & 1) != 0;
                if (!isOutput) continue;
                state.setPort(outputStart + i, val, 10);
            }
        }
        return 0;
    }

    private PioRegState getRegPropagateState() {
        return (PioRegState)this.attachedBus.getSocSimulationManager().getdata(this.attachedBus.getComponent());
    }

    private InstanceState getPropagateState() {
        return this.attachedBus.getSocSimulationManager().getState(this.attachedBus.getComponent());
    }

    private void handleOutputWriteTransaction(SocBusTransaction trans) {
        if (this.direction == PioAttributes.PORT_INPUT) {
            trans.setError(8);
        } else {
            PioRegState pdata = this.getRegPropagateState();
            pdata.outputRegister = trans.getWriteData();
            this.handleOperations(this.getPropagateState(), false);
        }
    }

    private void handleInputReadTransaction(SocBusTransaction trans) {
        if (this.direction == PioAttributes.PORT_OUTPUT) {
            trans.setError(9);
        } else {
            trans.setReadData(this.handleOperations(this.getPropagateState(), true));
        }
    }

    private void handleDirectionRegister(SocBusTransaction trans) {
        if (this.direction != PioAttributes.PORT_BIDIR) {
            trans.setError(10);
            return;
        }
        PioRegState s = this.getRegPropagateState();
        if (trans.isReadTransaction()) {
            trans.setReadData(s.directionRegister);
        }
        if (trans.isWriteTransaction()) {
            s.directionRegister = trans.getWriteData();
        }
    }

    private void handleIrqMaskRegister(SocBusTransaction trans) {
        if (!this.inputGeneratesIrq().booleanValue()) {
            trans.setError(10);
            return;
        }
        PioRegState s = this.getRegPropagateState();
        if (trans.isReadTransaction()) {
            trans.setReadData(s.interruptMask);
        } else {
            s.interruptMask = trans.getWriteData();
        }
    }

    private void handleCaptureRegister(SocBusTransaction trans) {
        if (!this.inputIsCapturedSynchronisely().booleanValue()) {
            trans.setError(10);
            return;
        }
        PioRegState s = this.getRegPropagateState();
        if (trans.isReadTransaction()) {
            trans.setReadData(s.captureRegister);
        }
        if (trans.isWriteTransaction()) {
            if (this.inputCaptureSupportsBitClearing().booleanValue()) {
                int mask = ~trans.getWriteData();
                s.captureRegister &= mask;
            } else {
                s.captureRegister = 0;
            }
        }
    }

    private void handleOutputBitOperation(SocBusTransaction trans, boolean clear) {
        if (!this.outputSupportsBitManipulations().booleanValue()) {
            trans.setError(10);
            return;
        }
        if (trans.isReadTransaction()) {
            trans.setError(9);
        }
        PioRegState s = this.getRegPropagateState();
        int mask = trans.getWriteData();
        s.outputRegister = clear ? (s.outputRegister &= (mask ^= 0xFFFFFFFF)) : (s.outputRegister |= mask);
        this.handleOperations(this.getPropagateState(), false);
    }

    @Override
    public boolean canHandleTransaction(SocBusTransaction trans) {
        long addr = SocSupport.convUnsignedInt(trans.getAddress());
        long start = SocSupport.convUnsignedInt(this.startAddress);
        long end = start + 24L;
        return addr >= start && addr < end;
    }

    @Override
    public void handleTransaction(SocBusTransaction trans) {
        if (!this.canHandleTransaction(trans)) {
            return;
        }
        trans.setTransactionResponder(this.attachedBus.getComponent());
        long addr = SocSupport.convUnsignedInt(trans.getAddress());
        long start = SocSupport.convUnsignedInt(this.startAddress);
        int index = (int)(addr - start);
        if (trans.getAccessType() != 3) {
            trans.setError(7);
            return;
        }
        switch (index) {
            case 0: {
                if (trans.isWriteTransaction()) {
                    this.handleOutputWriteTransaction(trans);
                }
                if (!trans.isReadTransaction()) break;
                this.handleInputReadTransaction(trans);
                break;
            }
            case 4: {
                this.handleDirectionRegister(trans);
                break;
            }
            case 8: {
                this.handleIrqMaskRegister(trans);
                break;
            }
            case 12: {
                this.handleCaptureRegister(trans);
                break;
            }
            case 16: {
                this.handleOutputBitOperation(trans, false);
                break;
            }
            case 20: {
                this.handleOutputBitOperation(trans, true);
                break;
            }
            default: {
                trans.setError(6);
            }
        }
    }

    @Override
    public Integer getStartAddress() {
        return this.startAddress;
    }

    @Override
    public Integer getMemorySize() {
        return 24;
    }

    @Override
    public String getName() {
        String name = "BUG: Unknown";
        if (this.attachedBus != null && this.attachedBus.getComponent() != null && StringUtil.isNullOrEmpty(name = this.label)) {
            Location loc = this.attachedBus.getComponent().getLocation();
            name = String.format("%s@%d,%d", this.attachedBus.getComponent().getFactory().getDisplayName(), loc.getX(), loc.getY());
        }
        return name;
    }

    @Override
    public void registerListener(SocBusSlaveListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    @Override
    public void removeListener(SocBusSlaveListener l) {
        this.listeners.remove(l);
    }

    @Override
    public InstanceComponent getComponent() {
        if (this.attachedBus == null || this.attachedBus.getComponent() == null) {
            return null;
        }
        return (InstanceComponent)this.attachedBus.getComponent();
    }

    private void fireNameChanged() {
        for (SocBusSlaveListener l : this.listeners) {
            l.labelChanged();
        }
    }

    private void firememMapChanged() {
        for (SocBusSlaveListener l : this.listeners) {
            l.memoryMapChanged();
        }
    }

    public class PioRegState
    implements InstanceData,
    Cloneable {
        public int outputRegister;
        public int captureRegister;
        public int directionRegister;
        public int interruptMask;
        public boolean oldIrq;
        public boolean oldIrqValid;
        private int oldInputs;
        private boolean oldInputsValid;

        public PioRegState() {
            this.reset();
        }

        @Override
        public PioRegState clone() {
            try {
                return (PioRegState)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public void updateCaptureRegister(int newInputs) {
            if (this.oldInputsValid && newInputs == this.oldInputs) {
                return;
            }
            if (this.oldInputsValid && PioState.this.inputIsCapturedSynchronisely().booleanValue()) {
                for (int i = 0; i < PioState.this.nrOfIOs.getWidth(); ++i) {
                    int oldi = this.oldInputs >> i & 1;
                    int newi = newInputs >> i & 1;
                    if (PioState.this.edgeCaptureType == PioAttributes.CAPT_ANY) {
                        if (oldi == newi) continue;
                        this.captureRegister |= 1 << i;
                        continue;
                    }
                    if (PioState.this.edgeCaptureType == PioAttributes.CAPT_RISING) {
                        if (oldi != 0 || newi != 1) continue;
                        this.captureRegister |= 1 << i;
                        continue;
                    }
                    if (oldi != 1 || newi != 0) continue;
                    this.captureRegister |= 1 << i;
                }
            }
            this.oldInputsValid = true;
            this.oldInputs = newInputs;
        }

        public void reset() {
            this.outputRegister = PioState.this.outputResetValue;
            this.captureRegister = 0;
            this.directionRegister = 0;
            this.oldInputs = 0;
            this.oldInputsValid = false;
            this.interruptMask = 0;
            this.oldIrq = false;
            this.oldIrqValid = false;
        }
    }
}

