/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.rv32im;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.rv32im.RV32imSupport;
import com.cburch.logisim.soc.util.AssemblerAsmInstruction;
import com.cburch.logisim.soc.util.AssemblerExecutionInterface;
import java.util.ArrayList;
import java.util.Arrays;

public class RV32imEnvironmentCallAndBreakpoints
implements AssemblerExecutionInterface {
    private static final int SYSTEM = 115;
    private static final int INSTR_ECALL = 0;
    private static final int INSTR_EBREAK = 1;
    private static final String[] AsmOpcodes = new String[]{"ECALL", "EBREAK"};
    private int instruction = 0;
    private int operation;
    private boolean valid;

    @Override
    public ArrayList<String> getInstructions() {
        return new ArrayList<String>(Arrays.asList(AsmOpcodes));
    }

    @Override
    public boolean execute(Object state, CircuitState cState) {
        if (!this.valid) {
            return false;
        }
        OptionPane.showMessageDialog(null, Strings.S.get("Rv32imECABNotImplmented"));
        return true;
    }

    @Override
    public String getAsmInstruction() {
        if (!this.valid) {
            return null;
        }
        return AsmOpcodes[this.operation].toLowerCase();
    }

    @Override
    public int getBinInstruction() {
        return this.instruction;
    }

    @Override
    public boolean setBinInstruction(int instr) {
        this.instruction = instr;
        this.valid = this.decodeBin();
        return this.valid;
    }

    @Override
    public boolean performedJump() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    private boolean decodeBin() {
        if (RV32imSupport.getOpcode(this.instruction) == 115) {
            int funct12 = this.instruction >> 20 & 0xFFF;
            if (funct12 > 1) {
                return false;
            }
            this.operation = funct12;
            return true;
        }
        return false;
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public int getInstructionSizeInBytes(String instruction) {
        if (this.getInstructions().contains(instruction.toUpperCase())) {
            return 4;
        }
        return -1;
    }

    @Override
    public boolean setAsmInstruction(AssemblerAsmInstruction instr) {
        int operation = -1;
        for (int i = 0; i < AsmOpcodes.length; ++i) {
            if (!AsmOpcodes[i].equals(instr.getOpcode().toUpperCase())) continue;
            operation = i;
        }
        if (operation < 0) {
            this.valid = false;
            return false;
        }
        if (instr.getNrOfParameters() != 0) {
            instr.setError(instr.getInstruction(), Strings.S.getter("AssemblerExpectedNoArguments"));
            this.valid = false;
            return true;
        }
        this.instruction = RV32imSupport.getITypeInstruction(115, 0, 0, 0, operation);
        this.valid = true;
        instr.setInstructionByteCode(this.instruction, 4);
        return true;
    }
}

