/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.util;

import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.util.AssemblerInterface;
import com.cburch.logisim.soc.util.AssemblerToken;
import com.cburch.logisim.util.StringGetter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class AssemblerMacro {
    private final String name;
    private final int nrOfParameters;
    private final LinkedList<AssemblerToken> tokens;
    private final HashMap<String, Long> localLabels;
    private final ArrayList<AssemblerToken[]> parameters;
    private boolean sizeDeterminationActive;
    private long macroSize;

    public AssemblerMacro(String name, int nrOfParameters) {
        this.name = name;
        this.nrOfParameters = nrOfParameters;
        this.tokens = new LinkedList();
        this.localLabels = new HashMap();
        this.parameters = new ArrayList();
        this.sizeDeterminationActive = false;
        this.macroSize = -1L;
    }

    public String getName() {
        return this.name;
    }

    public int getNrOfParameters() {
        return this.nrOfParameters;
    }

    public void addToken(AssemblerToken token) {
        this.tokens.add(token);
    }

    public void addLabel(String label) {
        this.localLabels.put(label, -1L);
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    public void addParameter(AssemblerToken[] param) {
        this.parameters.add(param);
    }

    public boolean hasCorrectNumberOfParameters() {
        return this.nrOfParameters == this.parameters.size();
    }

    public boolean checkParameters(HashMap<AssemblerToken, StringGetter> errors) {
        boolean hasErrors = false;
        for (AssemblerToken token : this.tokens) {
            if (token.getType() != 24 || token.getNumberValue() >= 1 && token.getNumberValue() <= this.nrOfParameters) continue;
            hasErrors = true;
            errors.put(token, Strings.S.getter("AssemblerMacroParameterNotDefined"));
        }
        return !hasErrors;
    }

    public LinkedList<AssemblerToken> getMacroTokens() {
        LinkedList<AssemblerToken> makroTokens = new LinkedList<AssemblerToken>();
        for (AssemblerToken token : this.tokens) {
            if (token.getType() == 24) {
                int index = token.getNumberValue() - 1;
                AssemblerToken[] param = this.parameters.get(index);
                makroTokens.addAll(Arrays.asList(param));
                continue;
            }
            AssemblerToken copy = new AssemblerToken(token.getType(), token.getValue(), token.getoffset());
            makroTokens.add(copy);
        }
        return makroTokens;
    }

    public boolean checkForMacros(HashMap<AssemblerToken, StringGetter> errors, Set<String> names) {
        boolean hasErrors = false;
        for (AssemblerToken token : this.tokens) {
            if (token.getType() != 8) continue;
            if (token.getValue().equals(this.name)) {
                errors.put(token, Strings.S.getter("AssemblerMacroCannotUseRecurency"));
                hasErrors = true;
            }
            if (!names.contains(token.getValue())) continue;
            token.setType(23);
        }
        return hasErrors;
    }

    public long getMacroSize(HashMap<AssemblerToken, StringGetter> errors, AssemblerInterface assembler, HashMap<String, AssemblerMacro> macros, ArrayList<AssemblerToken> hierarchy) {
        if (this.macroSize >= 0L) {
            return this.macroSize;
        }
        if (this.sizeDeterminationActive) {
            for (AssemblerToken asm : hierarchy) {
                errors.put(asm, Strings.S.getter("AssemblerMacroCallingEachotherDeadlock"));
            }
            return -1L;
        }
        this.sizeDeterminationActive = true;
        long pc = 0L;
        Iterator iter = this.tokens.iterator();
        while (iter.hasNext()) {
            AssemblerToken asm = (AssemblerToken)iter.next();
            if (asm.getType() == 2) {
                pc += (long)assembler.getInstructionSize(asm.getValue());
                continue;
            }
            if (asm.getType() == 23) {
                hierarchy.add(asm);
                long msize = macros.get(asm.getValue()).getMacroSize(errors, assembler, macros, hierarchy);
                if (msize < 0L) {
                    return -1L;
                }
                pc += msize;
                continue;
            }
            if (asm.getType() != 1 || !this.localLabels.containsKey(asm.getValue())) continue;
            this.localLabels.put(asm.getValue(), pc);
            iter.remove();
        }
        this.sizeDeterminationActive = false;
        this.macroSize = pc;
        return this.macroSize;
    }

    public boolean replaceLabels(HashMap<String, Long> globalLabels, HashMap<AssemblerToken, StringGetter> errors, AssemblerInterface assembler, HashMap<String, AssemblerMacro> macros) {
        ArrayList<AssemblerToken> hierarchy = new ArrayList<AssemblerToken>();
        long msize = this.getMacroSize(errors, assembler, macros, hierarchy);
        if (msize < 0L) {
            return false;
        }
        boolean hasErrors = false;
        long pc = 0L;
        long nextpc = 0L;
        hierarchy.clear();
        for (int i = 0; i < this.tokens.size(); ++i) {
            AssemblerToken asm = this.tokens.get(i);
            if (asm.getType() == 2) {
                pc = nextpc;
                nextpc += (long)assembler.getInstructionSize(asm.getValue());
            } else if (asm.getType() == 23) {
                pc = nextpc;
                nextpc += macros.get(asm.getValue()).getMacroSize(errors, assembler, macros, hierarchy);
            }
            if (asm.getType() != 16 || globalLabels.containsKey(asm.getValue())) continue;
            if (this.localLabels.containsKey(asm.getValue())) {
                boolean negative;
                long target = this.localLabels.get(asm.getValue());
                long offset = target - pc;
                boolean bl = negative = offset < 0L;
                if (negative) {
                    offset = -offset;
                }
                asm.setType(7);
                asm.setValue(String.format("0x%X", offset));
                AssemblerToken operator = new AssemblerToken(negative ? 14 : 15, null, asm.getoffset());
                AssemblerToken pcid = new AssemblerToken(22, "pc", asm.getoffset());
                this.tokens.add(i, operator);
                this.tokens.add(i, pcid);
                continue;
            }
            hasErrors = true;
            errors.put(asm, Strings.S.getter("AssemblerUnknownLabel"));
        }
        return !hasErrors;
    }
}

